/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.loncomm;

import com.tridium.lonworks.loncomm.LonTransaction;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.util.Vector;
import javax.baja.lonworks.LonException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public final class LonTransactionManager {
    long tryCnt = 0L;
    private static final int MAX_TAG = 14;
    private static final int NUM_OF_LON_TRANSACTIONS = 16;
    private LonTransaction[] lonTransactionBuffers = new LonTransaction[16];
    private boolean transactionInProgress = false;
    private int nextTag = 0;
    private NLonComm lonComm = null;
    private TransactionTimer transactionTimer;
    private Thread timerThread = null;
    private boolean done = false;

    LonTransactionManager(NLonComm lc) {
        this.lonComm = lc;
        for (int index = 0; index < 16; ++index) {
            LonTransaction lonTransaction;
            this.lonTransactionBuffers[index] = lonTransaction = new LonTransaction(index);
        }
    }

    void start() {
        this.done = false;
        this.transactionTimer = new TransactionTimer();
        this.timerThread = new Thread((Runnable)this.transactionTimer, this.lonComm.lonNetwork().getLogName() + ".TransactionTimer");
        this.timerThread.start();
        this.timerThread.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        this.done = true;
        if (this.timerThread != null) {
            this.timerThread.interrupt();
            this.timerThread = null;
        }
        this.notifyAll();
        for (int index = 0; index < 16; ++index) {
            LonTransaction lt = this.lonTransactionBuffers[index];
            this.freeLonTransaction(lt);
            LonTransaction lonTransaction = lt;
            synchronized (lonTransaction) {
                lt.notify();
                continue;
            }
        }
    }

    protected synchronized LonTransaction getLonTransaction(NAppBuffer appBuffer) {
        int index = 0;
        if (appBuffer.isImplicitAddress()) {
            index = appBuffer.getTag();
        } else {
            index = this.nextTag++;
            if (this.nextTag > 14) {
                this.nextTag = 0;
            }
        }
        while (!this.done && (this.transactionInProgress || this.lonTransactionBuffers[index].isUsed())) {
            ++this.tryCnt;
            try {
                this.wait(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.done) {
            return null;
        }
        this.initTransaction(index, appBuffer);
        return this.lonTransactionBuffers[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LonTransaction getLonTransactionTag15(NAppBuffer appBuffer) {
        int index = 15;
        while (!this.done) {
            LonTransactionManager lonTransactionManager = this;
            synchronized (lonTransactionManager) {
                if (!this.transactionInProgress && !this.lonTransactionBuffers[index].isUsed()) {
                    this.initTransaction(index, appBuffer);
                    return this.lonTransactionBuffers[index];
                }
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private void initTransaction(int index, NAppBuffer appBuffer) {
        LonTransaction transaction = this.lonTransactionBuffers[index];
        transaction.setUsed(true);
        transaction.setLocal(appBuffer.isLocalAddress());
        transaction.setOutgoingMessage(appBuffer);
        appBuffer.setTransactionTag(index);
        this.transactionTimer.start(transaction);
        this.transactionInProgress = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeLonTransaction(LonTransaction transaction) {
        LonTransactionManager lonTransactionManager = this;
        synchronized (lonTransactionManager) {
            if (this.transactionTimer != null) {
                this.transactionTimer.cancel(transaction);
            }
            transaction.setOutgoingMessage(null);
            transaction.setResponseMessage(null);
            transaction.setLocal(false);
            transaction.setUsed(false);
            transaction.setComplete(false);
            transaction.setException(null);
            this.transactionInProgress = false;
            this.notify();
        }
        Thread.yield();
    }

    protected LonTransaction getLonTransactionMatch(int tag) {
        return this.lonTransactionBuffers[tag];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeOut(LonTransaction transaction) {
        String err = "LonTransaction timed out " + transaction.getTag() + " :";
        NAppBuffer msg = transaction.getOutgoingMessage();
        if (msg != null) {
            err = err.concat(LonByteArrayUtil.toString(msg.getReadBuffer(), msg.getWriteBufferLen()));
        }
        this.lonComm.lonworks.log().warning(err);
        LonTransaction lonTransaction = transaction;
        synchronized (lonTransaction) {
            if (transaction.isUsed() && !transaction.isComplete()) {
                transaction.setResponseMessage(null);
                transaction.setException(new LonException("Timed out waiting for neuron to respond."));
                transaction.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("Transaction Manager");
        out.prop((Object)"transactionInProgress", this.transactionInProgress);
        out.prop((Object)"lastTagUsed", this.nextTag);
        if (this.timerThread != null) {
            out.prop((Object)"timerThread alive", this.timerThread.isAlive());
        }
        out.prop((Object)"done", this.done);
        out.prop((Object)"tryCnt", (Object)Long.toString(this.tryCnt));
        out.endProps();
        out.startTable(true);
        out.trTitle((Object)"transactions", 4);
        out.w((Object)"<tr>").th((Object)"tag").th((Object)"local").th((Object)"cmpl").th((Object)"end").th((Object)"msg").w((Object)"</tr>\n");
        LonTransactionManager lonTransactionManager = this;
        synchronized (lonTransactionManager) {
            long currTime = Clock.ticks();
            for (int i = 0; i < this.lonTransactionBuffers.length; ++i) {
                LonTransaction lt = this.lonTransactionBuffers[i];
                if (!lt.isUsed()) continue;
                out.tr((Object)Integer.toString(lt.getTag()), (Object)Boolean.toString(lt.isLocal()), (Object)Boolean.toString(lt.isComplete()), (Object)Long.toString(lt.getEndTime() - currTime), (Object)Integer.toString(lt.getOutgoingMessage().getMessageCode()));
            }
        }
        out.endTable();
    }

    private class TransactionTimer
    implements Runnable {
        private Vector<LonTransaction> v = new Vector(16);

        private TransactionTimer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!LonTransactionManager.this.done) {
                TransactionTimer transactionTimer = this;
                synchronized (transactionTimer) {
                    long currTime = Clock.ticks();
                    int timeToWait = 10000;
                    if (!this.v.isEmpty()) {
                        LonTransaction curTrans = this.v.firstElement();
                        long toTime = curTrans.getEndTime();
                        if (toTime <= currTime) {
                            this.v.removeElement(curTrans);
                            LonTransactionManager.this.timeOut(curTrans);
                            timeToWait = 0;
                        } else {
                            timeToWait = (int)(toTime - currTime);
                        }
                    }
                    try {
                        this.wait(timeToWait);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        synchronized void start(LonTransaction trans) {
            int i;
            long transTime = trans.getOutgoingMessage().getMaxTransactionTime();
            if (transTime > 8000L) {
                transTime = 8000L;
            }
            long endTime = Clock.ticks() + transTime + 5000L;
            trans.setEndTime(endTime);
            for (i = 0; i < this.v.size() && this.v.elementAt(i).getEndTime() <= endTime; ++i) {
            }
            this.v.insertElementAt(trans, i);
            if (i == 0) {
                this.notifyAll();
            }
        }

        synchronized void cancel(LonTransaction trans) {
            trans.setEndTime(0L);
            this.v.removeElement(trans);
            this.notifyAll();
        }
    }
}

