/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.EnumSet;
import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.Type;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.IOException;

public class TypeFile
extends ResourceFile {
    public byte[] refId = new byte[8];
    public int scope;
    int[] resDeps = new int[7];
    int[] typDeps = new int[7];
    int numNVTs;
    int numCPTs;
    int numEnumSets;
    int numEmptyNVTs = 0;
    int numEmptyCPTs = 0;
    int numEmptyEnumSets = 0;
    int[] dirNVTIndex;
    int[] dirNVTName;
    int[] dirCPTIndex;
    int[] dirCPTName;
    int[] dirEnumIndex;
    int[] dirEnumTag;
    int[] dirEnumFile;
    public Type[] nvTypes;
    public CpType[] cpTypes;
    public EnumSet[] enumSets;
    public static final String SNVT = "SNVT_";
    public static final String UNVT = "UNVT_";
    public static final String SCPT = "SCPT_";
    public static final String UCPT = "UCPT_";

    @Override
    public void parse(ResFileInputStream in) throws IOException {
        int i;
        int i2;
        int i3;
        int i4;
        this.parseHeader(in);
        this.refId = in.readByteArray(8);
        this.scope = in.readUnsigned8();
        for (i4 = 0; i4 < 7; ++i4) {
            this.resDeps[i4] = in.readUnsigned16();
        }
        for (i4 = 0; i4 < 7; ++i4) {
            this.typDeps[i4] = in.readUnsigned16();
        }
        this.numNVTs = in.readUnsigned16();
        this.numCPTs = in.readUnsigned16();
        this.numEnumSets = in.readUnsigned16();
        if (this.majorFmtVer > 3) {
            this.numEmptyNVTs = in.readUnsigned16();
            this.numEmptyCPTs = in.readUnsigned16();
            this.numEmptyEnumSets = in.readUnsigned16();
        }
        this.dirNVTIndex = new int[this.numNVTs];
        for (i4 = 0; i4 < this.numNVTs; ++i4) {
            this.dirNVTIndex[i4] = in.readDirectory(this);
        }
        int nvtNameCnt = this.numNVTs - this.numEmptyNVTs;
        this.dirNVTName = new int[nvtNameCnt];
        for (i3 = 0; i3 < nvtNameCnt; ++i3) {
            this.dirNVTName[i3] = in.readDirectory(this);
        }
        this.dirCPTIndex = new int[this.numCPTs];
        for (i3 = 0; i3 < this.numCPTs; ++i3) {
            this.dirCPTIndex[i3] = in.readDirectory(this);
        }
        int cptNameCnt = this.numCPTs - this.numEmptyCPTs;
        this.dirCPTName = new int[cptNameCnt];
        for (i2 = 0; i2 < cptNameCnt; ++i2) {
            this.dirCPTName[i2] = in.readDirectory(this);
        }
        this.dirEnumIndex = new int[this.numEnumSets];
        for (i2 = 0; i2 < this.numEnumSets; ++i2) {
            this.dirEnumIndex[i2] = in.readDirectory(this);
        }
        int enumNameCnt = this.numEnumSets - this.numEmptyEnumSets;
        this.dirEnumTag = new int[enumNameCnt];
        for (i = 0; i < enumNameCnt; ++i) {
            this.dirEnumTag[i] = in.readDirectory(this);
        }
        this.dirEnumFile = new int[enumNameCnt];
        for (i = 0; i < enumNameCnt; ++i) {
            this.dirEnumFile[i] = in.readDirectory(this);
        }
        this.nvTypes = new Type[this.numNVTs];
        for (i = 0; i < this.numNVTs; ++i) {
            if (this.dirNVTIndex[i] == 0) continue;
            in.seek(this.dirNVTIndex[i]);
            try {
                this.nvTypes[i] = new Type(in, this.userFlag ? UNVT : SNVT, this.scope);
                continue;
            }
            catch (Throwable e) {
                System.out.println(e);
                this.nvTypes[i] = null;
            }
        }
        this.cpTypes = new CpType[this.numCPTs];
        for (i = 0; i < this.numCPTs; ++i) {
            if (this.dirCPTIndex[i] == 0) continue;
            in.seek(this.dirCPTIndex[i]);
            this.cpTypes[i] = new CpType(in, this.userFlag ? UCPT : SCPT, this.scope);
        }
        this.enumSets = new EnumSet[this.numEnumSets];
        for (i = 0; i < this.numEnumSets; ++i) {
            if (this.dirEnumIndex[i] == 0) continue;
            int address = this.dirEnumIndex[i];
            in.seek(address);
            this.enumSets[i] = new EnumSet(in, address);
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("refId         = ").append(LonByteArrayUtil.toString(this.refId)).append("\n");
        sb.append("scope         = ").append(this.scope).append("\n");
        for (i = 0; i < 7; ++i) {
            sb.append("resDeps[" + i + "]    = ").append(this.resDeps[i]).append("\n");
        }
        for (i = 0; i < 7; ++i) {
            sb.append("typDeps[" + i + "]    = ").append(this.typDeps[i]).append("\n");
        }
        sb.append("numNVTs       = ").append(this.numNVTs).append("  numEmptyNVTs     = ").append(this.numEmptyNVTs).append("\n");
        sb.append("numCPTs       = ").append(this.numCPTs).append("  numEmptyCPTs     = ").append(this.numEmptyCPTs).append("\n");
        sb.append("numEnumSets   = ").append(this.numEnumSets).append("  numEmptyEnumSets = ").append(this.numEmptyEnumSets).append("\n");
        for (i = 0; i < this.numNVTs; ++i) {
            this.nvTypes[i].toString(sb);
        }
        for (i = 0; i < this.numCPTs; ++i) {
            this.cpTypes[i].toString(sb);
        }
        for (i = 0; i < this.numEnumSets; ++i) {
            this.enumSets[i].toString(sb);
        }
        return sb.toString();
    }
}

