/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.TypeScalar;
import java.io.IOException;

public class TypeScalar64
extends TypeScalar {
    public long lMinValid = 0L;
    public long lMaxValid = 0L;
    public long lInvalid = 0L;

    public TypeScalar64(ResFileInputStream in, int nodeType) throws IOException {
        this.nodeType = nodeType;
        this.rangeScaleControl = in.readUnsigned8();
        this.lMinValid = (this.rangeScaleControl & 0x80) != 0 ? (nodeType == 17 ? Long.MIN_VALUE : 0L) : ((this.rangeScaleControl & 0x40) != 0 ? -1L : ((this.rangeScaleControl & 0x20) != 0 ? 0L : in.readSigned64()));
        this.lMaxValid = (this.rangeScaleControl & 0x10) != 0 ? (nodeType == 17 ? Long.MAX_VALUE : -1L) : ((this.rangeScaleControl & 8) != 0 ? 0L : in.readSigned64());
        this.readScale(in);
        this.readInvalid(in);
        float res = (float)((double)this.scaleA * Math.pow(10.0, this.scaleB));
        if ((this.rangeScaleControl & 0x80) != 0) {
            this.lMinValid = (long)((float)this.lMinValid * res);
        }
        if ((this.rangeScaleControl & 0x10) != 0) {
            this.lMaxValid = (long)((float)this.lMaxValid * res);
        }
    }

    @Override
    protected void readInvalid(ResFileInputStream in) throws IOException {
        if (in.majorFmtVer < 3) {
            return;
        }
        switch (this.nodeType) {
            case 17: 
            case 18: {
                this.invalidPresent = in.readBool();
                if (!this.invalidPresent) break;
                this.lInvalid = in.readSigned64();
            }
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append("TypeScalar64").append("\n");
        super.toString(sb);
    }

    @Override
    public Number getMinimum() {
        return this.lMinValid;
    }

    @Override
    public Number getMaximum() {
        return this.lMaxValid;
    }

    @Override
    public Number getInvalid() {
        return this.lInvalid;
    }
}

