/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.xml.XLonData;
import java.util.Vector;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Sys;

public class XEnumDef
extends XLonData {
    public String typeSpec = "";
    private Vector<String> tags = new Vector();
    private Vector<String> ids = new Vector();

    public void addEnum(String tag, String id) {
        this.tags.addElement(tag);
        this.ids.addElement(id);
    }

    public void insertEnum(int idx, String tag, String id) {
        this.tags.add(idx, tag);
        this.ids.add(idx, id);
    }

    public void removeEnum(int idx) {
        this.tags.remove(idx);
        this.ids.remove(idx);
    }

    public void setTag(int idx, String tag) {
        this.tags.set(idx, tag);
    }

    public void setId(int idx, String id) {
        this.ids.set(idx, id);
    }

    public void clearEnums() {
        this.tags.clear();
        this.ids.clear();
    }

    public String[] getEnumTags() {
        Object[] a = new String[this.tags.size()];
        this.tags.copyInto(a);
        return a;
    }

    public int[] getEnumIds() {
        int[] a = new int[this.ids.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Integer.parseInt(this.ids.elementAt(i));
        }
        return a;
    }

    public void rename(String origName, String newName) {
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!this.tags.elementAt(i).equals(origName)) continue;
            this.tags.setElementAt(newName, i);
            return;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XEnumDef)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        XEnumDef oenum = (XEnumDef)obj;
        if (this.tags.size() != oenum.tags.size()) {
            return false;
        }
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.elementAt(i).equals(oenum.tags.elementAt(i)) && this.ids.elementAt(i).equals(oenum.ids.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder encoding = new StringBuilder();
        for (int i = 0; i < this.tags.size(); ++i) {
            encoding.append(this.tags.get(i)).append(":").append(this.ids.get(i)).append(";");
        }
        return encoding.toString().hashCode();
    }

    public BLonEnum getEnum() {
        int[] idArray;
        String[] tagArray;
        if (this.typeSpec.length() > 0) {
            try {
                BEnum en = (BEnum)Sys.getType((String)this.typeSpec).getInstance();
                return BLonEnum.make(en);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((tagArray = this.getEnumTags()).length != (idArray = this.getEnumIds()).length) {
            throw new RuntimeException("Error in " + this.getName() + " file.");
        }
        BDynamicEnum ms = BDynamicEnum.make((int)idArray[0], (BEnumRange)BEnumRange.make((int[])idArray, (String[])tagArray));
        return BLonEnum.make((BEnum)ms);
    }
}

