/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.xml.XCpTypeDef;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XLonData;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XTypeDef;
import java.util.Vector;

public class XLonInterfaceFile
extends XLonData {
    public Vector<XLonInterfaceFile> imports = new Vector();
    public Vector<XEnumDef> enums = new Vector();
    public Vector<XTypeDef> types = new Vector();
    public Vector<XLonDevice> devices = new Vector();
    private String file = "";
    public String protect = "";

    @Override
    public void addAttribute(String name, Object obj) {
        if (obj instanceof XEnumDef) {
            this.enums.addElement((XEnumDef)obj);
        } else if (obj instanceof XTypeDef) {
            this.types.addElement((XTypeDef)obj);
        } else if (obj instanceof XLonDevice) {
            this.devices.addElement((XLonDevice)obj);
        } else if (obj instanceof XLonInterfaceFile) {
            this.imports.addElement((XLonInterfaceFile)obj);
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public XLonDevice getLonDevice() {
        if (this.devices.size() == 0) {
            return null;
        }
        return this.devices.elementAt(0);
    }

    public XTypeDef resolveTypeDef(XTypeDef outerType, String name) {
        int i;
        for (i = 0; i < this.types.size(); ++i) {
            XTypeDef t = this.types.elementAt(i);
            if (t == outerType || !t.getName().equals(name)) continue;
            return t;
        }
        for (i = 0; i < this.imports.size(); ++i) {
            XTypeDef def = this.imports.elementAt(i).resolveTypeDef(name);
            if (def == null || def == outerType) continue;
            return def;
        }
        return null;
    }

    public XTypeDef resolveTypeDef(String name) {
        return this.resolveTypeDef(null, name);
    }

    public boolean includes(String lnml) {
        for (int i = 0; i < this.imports.size(); ++i) {
            XLonInterfaceFile xfile = this.imports.elementAt(i);
            if (!xfile.getName().equals(lnml) && !xfile.includes(lnml)) continue;
            return true;
        }
        return false;
    }

    public XEnumDef resolveEnumDef(String name) {
        int i;
        for (i = 0; i < this.enums.size(); ++i) {
            XEnumDef t = this.enums.elementAt(i);
            if (!t.getName().equals(name)) continue;
            return t;
        }
        for (i = 0; i < this.imports.size(); ++i) {
            XEnumDef def = this.imports.elementAt(i).resolveEnumDef(name);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public String resolveTypeDefToLnml(String name) {
        int i;
        for (i = 0; i < this.types.size(); ++i) {
            XTypeDef t = this.types.elementAt(i);
            if (!t.getName().equals(name)) continue;
            return this.getName();
        }
        for (i = 0; i < this.imports.size(); ++i) {
            XLonInterfaceFile xfile = this.imports.elementAt(i);
            XTypeDef def = xfile.resolveTypeDef(name);
            if (def == null) continue;
            return xfile.getName();
        }
        return null;
    }

    public String resolveEnumDefToLnml(String name) {
        int i;
        for (i = 0; i < this.enums.size(); ++i) {
            XEnumDef t = this.enums.elementAt(i);
            if (!t.getName().equals(name)) continue;
            return this.getName();
        }
        for (i = 0; i < this.imports.size(); ++i) {
            XLonInterfaceFile xfile = this.imports.elementAt(i);
            XEnumDef def = xfile.resolveEnumDef(name);
            if (def == null) continue;
            return xfile.getName();
        }
        return null;
    }

    public XTypeDef getXType(String typeScope) {
        for (int i = 0; i < this.types.size(); ++i) {
            XTypeDef t = this.types.elementAt(i);
            if (t.isCpType() || !t.getTypeScope().equals(typeScope)) continue;
            return t;
        }
        return null;
    }

    public XCpTypeDef getXCpType(String typeScope) {
        for (int i = 0; i < this.types.size(); ++i) {
            XTypeDef t = this.types.elementAt(i);
            if (!t.isCpType() || !t.getTypeScope().equals(typeScope)) continue;
            return (XCpTypeDef)t;
        }
        return null;
    }
}

