/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XCpTypeDef;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XIConfig;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XLonTyped;
import com.tridium.lonworks.xml.XNetVariable;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUnion;
import com.tridium.lonworks.xml.XUnionBranch;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BUnionQualifier;
import javax.baja.lonworks.datatypes.BUnionQualifiers;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDataUnion;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class XUtil {
    private static BUnit CELSIUS = UnitDatabase.getUnit((String)"celsius");
    private static XLonInterfaceFile st = null;

    public static BLonData getLonDataNv(XNetVariable xnv, XLonInterfaceFile root) {
        BLonData data = XUtil.getLonDataClass(xnv, root);
        if (data != null) {
            return data;
        }
        int snvt = XLonDataUtil.snvtTypeFromString(xnv.snvtType);
        if (snvt > 0) {
            return SnvtUtil.getLonData(snvt, XLonDataUtil.isDiffQualifier(xnv.snvtType));
        }
        XElementQualifier[] eqs = xnv.getElementQualifiers(root);
        data = XUtil.makeLonData(eqs, xnv.getUnion(), root);
        return data;
    }

    public static BLonData getLonDataNc(XNetworkConfig xnc, XLonInterfaceFile root) {
        BLonData ld = XUtil.getLonDataNv(xnc, root);
        if (ld == null) {
            return null;
        }
        byte[] init = xnc.getInitBytes(root);
        if (init != null) {
            ld.fromNetBytes(init);
        }
        XUtil.addMinMax(xnc, ld);
        return ld;
    }

    public static BLonData getLonDataCp(XConfigProperty xcp, XLonInterfaceFile root, XLonDevice xdev, BLonConfigScope scope, String select, BLonDevice dev, int ndx) {
        byte[] init;
        BLonData ld = XUtil.getLonDataClass(xcp, root);
        try {
            if (ld == null) {
                ld = XUtil.getCpLonData(xcp, scope, select, root, xdev);
            }
        }
        catch (Throwable e) {
            dev.log().warning(dev.getName() + "." + xcp.getName() + ": " + e.getMessage());
        }
        if (ld == null) {
            BLonElementQualifiers eq = BLonElementQualifiers.make(BLonElementType.na, xcp.length);
            ld = new BLonData(BLonByteArray.make(xcp.length), eq, null);
        }
        if ((init = xcp.getInitBytes(root)) != null) {
            byte[] dat = init;
            if (ndx > 0 && init.length >= xcp.length * (ndx + 1)) {
                dat = new byte[xcp.length];
                System.arraycopy(init, xcp.length * ndx, dat, 0, xcp.length);
            }
            ld.fromNetBytes(dat);
        }
        XUtil.addMinMax(xcp, ld);
        return ld;
    }

    private static BLonData getLonDataClass(XLonTyped x, XLonInterfaceFile root) {
        String typeSpec = x.getTypeSpec(root);
        if (typeSpec == null || typeSpec.length() == 0) {
            return null;
        }
        try {
            return (BLonData)Sys.getType((String)typeSpec).getInstance();
        }
        catch (Throwable e) {
            throw new BajaRuntimeException("Unable to create class " + typeSpec, e);
        }
    }

    public static BLonData makeLonData(XElementQualifier[] eqs, XLonInterfaceFile root) {
        return XUtil.makeLonData(eqs, null, root);
    }

    public static BLonData makeLonData(XElementQualifier[] eqs, XUnion union, XLonInterfaceFile root) {
        if (eqs.length == 0) {
            return null;
        }
        boolean useUnion = union != null && XUtil.isValid(union);
        BLonData data = useUnion ? new BLonDataUnion() : new BLonData();
        for (int i = 0; i < eqs.length; ++i) {
            XElementQualifier eq = eqs[i];
            BFacets f = LonFacetsUtil.makeFacets(XUtil.getQuals(eq), XUtil.getUnits(eq.getEngUnit()));
            data.add(eq.getName(), (BValue)XUtil.getLonPrimitive(eq, root), 0, f, null);
        }
        if (useUnion) {
            BUnionQualifiers uqs = ((BLonDataUnion)data).getUnionQuals();
            uqs.setConditionProp(union.branchElem);
            XUnionBranch[] a = union.getUnionBranches();
            for (int i = 0; i < a.length; ++i) {
                XUnionBranch b = a[i];
                BUnionQualifier uq = new BUnionQualifier();
                uq.setBranch(b.branchName);
                uq.setBranchProps(XUtil.getBranchPropsString(b.branchName, eqs));
                uq.setConditions(b.condition);
                uqs.add(b.branchName, (BValue)uq);
            }
        }
        return data;
    }

    private static boolean isValid(XUnion union) {
        if (union.branchElem.indexOf(63) >= 0) {
            return false;
        }
        Vector<XUnionBranch> v = union.branch;
        for (int i = 0; i < v.size(); ++i) {
            XUnionBranch b = v.elementAt(i);
            if (b.branchName.length() == 0 || b.branchName.indexOf(63) >= 0) {
                return false;
            }
            if (b.condition.length() != 0 && b.condition.indexOf(63) < 0) continue;
            return false;
        }
        return true;
    }

    private static String getBranchPropsString(String name, XElementQualifier[] eqs) {
        Array a = new Array(String.class);
        for (int i = 0; i < eqs.length; ++i) {
            String n = eqs[i].getUnionBranch();
            if (n == null || !n.equals(name)) continue;
            a.add((Object)eqs[i].getName());
        }
        return LonStringUtil.toString((String[])a.trim());
    }

    private static BLonElementQualifiers getQuals(XElementQualifier eq) {
        try {
            return BLonElementQualifiers.make(BLonElementType.make(eq.getElementType()), eq.hasMinimum(), eq.getMinimum(), eq.hasMaximum(), eq.getMaximum(), eq.getResolution(), eq.getOffset(), eq.hasByteOffset(), eq.getByteOffset(), eq.getBitOffset(), eq.hasInvalid(), eq.getInvalid(), eq.getLength());
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create element qualifier " + eq.name + "\nencodes to:" + eq.encodeToString());
        }
    }

    private static BUnit getUnits(String units) {
        if (units == null || units.length() == 0) {
            return null;
        }
        try {
            return BUnit.getUnit((String)units);
        }
        catch (RuntimeException e) {
            String s = "Could not find units " + units + "  " + e;
            System.out.println(s);
            return null;
        }
    }

    private static BLonPrimitive getLonPrimitive(XElementQualifier eq, XLonInterfaceFile root) {
        BLonPrimitive prim;
        switch (XElementQualifier.qualTypeFromString(eq.getElementType())) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                prim = BLonFloat.DEFAULT;
                break;
            }
            case 16: {
                prim = BLonDouble.DEFAULT;
                break;
            }
            case 5: 
            case 17: 
            case 18: {
                if (eq.getResolution() < 1.0f) {
                    prim = BLonDouble.DEFAULT;
                    break;
                }
                prim = BLonLong.DEFAULT;
                break;
            }
            case 19: {
                if (eq.getResolution() < 1.0f) {
                    prim = BLonDouble.DEFAULT;
                    break;
                }
                prim = BLonBigInteger.DEFAULT;
                break;
            }
            case 6: 
            case 10: {
                prim = BLonBoolean.FALSE;
                break;
            }
            case 7: 
            case 9: {
                prim = XUtil.getEnum(eq.getEnumDef(), root);
                break;
            }
            case 13: {
                prim = BLonString.DEFAULT;
                break;
            }
            default: {
                prim = BLonByteArray.make(eq.getLength());
            }
        }
        return prim;
    }

    private static BLonPrimitive getEnum(String enumType, XLonInterfaceFile root) {
        XEnumDef ed = root.resolveEnumDef(enumType);
        if (ed == null) {
            throw new RuntimeException("No enumType " + enumType);
        }
        return ed.getEnum();
    }

    private static BLonData getCpLonData(XConfigProperty xcp, BLonConfigScope scope, String sel, XLonInterfaceFile root, XLonDevice xdev) {
        XCpTypeDef cpType = null;
        if (xcp.scptType.length() > 0) {
            cpType = XUtil.findStandardCpType(xcp.scptType);
        } else if (xcp.typeDef.length() > 0) {
            XTypeDef tdef = root.resolveTypeDef(xcp.typeDef);
            if (tdef == null) {
                System.out.println("WARNING:typeDef not found " + xcp.getName() + ":" + xcp.typeDef);
                return null;
            }
            if (!(tdef instanceof XCpTypeDef)) {
                return XUtil.makeLonData(tdef.getElementQualifiers(root), tdef.union, root);
            }
            cpType = (XCpTypeDef)tdef;
        } else {
            return null;
        }
        if (cpType == null) {
            throw new RuntimeException("Could not find type {" + xcp.getName() + "}");
        }
        xcp.setXTypeDef(cpType);
        if (!cpType.inherited) {
            XLonInterfaceFile ifile = xcp.scptType.length() > 0 ? XUtil.getStandard() : root;
            return cpType.getLonData(ifile);
        }
        int nvIndex = -1;
        XNetworkVariable[] nvs = xdev.getNetworkVariables();
        if (scope.equals((Object)BLonConfigScope.nv)) {
            nvIndex = SelfDocUtil.getFirstIndex(sel);
        } else if (scope.equals((Object)BLonConfigScope.object)) {
            nvIndex = XUtil.getInheritanceSourceNv(xcp, xdev, sel);
        } else {
            throw new RuntimeException("Scpt inherits data type from nv but scope is " + (Object)((Object)scope) + " {" + xcp.getName() + "}");
        }
        XNetworkVariable xnv = null;
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i].index > nvIndex || nvs[i].index + nvs[i].arraySize <= nvIndex) continue;
            xnv = nvs[i];
            break;
        }
        if (xnv == null) {
            throw new RuntimeException("Scpt inherits data type from nv " + nvIndex + ".  Unable to find nv. {" + xcp.getName() + "}");
        }
        BLonData ld = XUtil.getLonDataNv(xnv, root);
        if (xcp.scptType.equals("CpSndDelta") || xcp.scptType.equals("CpOffset")) {
            XUtil.tempToDeltaTemp(ld);
        }
        return ld;
    }

    public static int getInheritanceSourceNv(XConfigProperty xcp, XLonDevice xdev, String sel) {
        int nvIndex = -1;
        XNetworkVariable[] nvs = xdev.getNetworkVariables();
        if (xcp.principalNv.length() <= 0) {
            throw new RuntimeException("Inherited type with object scope but no principalNv {" + xcp.getName() + "}");
        }
        int obj = SelfDocUtil.getFirstIndex(sel);
        int mem = Integer.parseInt(xcp.principalNv.substring(1));
        boolean mfgMem = xcp.principalNv.startsWith("#");
        for (int i = 0; i < nvs.length; ++i) {
            XNetworkVariable nv = nvs[i];
            if (nv == null || nv.objectIndex.length() <= 0) continue;
            int firstObj = SelfDocUtil.getFirstIndex(nv.objectIndex);
            int lastObj = SelfDocUtil.getLastIndex(nv.objectIndex);
            if (obj < firstObj || obj > lastObj || mem < nv.memberIndex || mem >= nv.memberIndex + nv.memberArraySize || nv.mfgMember != mfgMem) continue;
            nvIndex = nv.index;
            break;
        }
        if (nvIndex == -1) {
            throw new RuntimeException("Can't find object " + obj + " with member " + xcp.principalNv + " {" + xcp.getName() + "}");
        }
        return nvIndex;
    }

    private static void tempToDeltaTemp(BLonData ld) {
        SlotCursor c = ld.getProperties();
        while (c.nextObject()) {
            BValue obj = c.get();
            Type typ = obj.getType();
            if (typ.is(BLonPrimitive.TYPE)) {
                BUnit u;
                BFacets f = c.property().getFacets();
                if (f == null || (u = (BUnit)f.get("units")) == null || !u.getDimension().equals((Object)CELSIUS.getDimension())) continue;
                u = BUnit.getUnit((String)(u.getUnitName() + " degrees"));
                f = BFacets.make((BFacets)f, (String)"units", (BIDataValue)u);
                ld.setFacets((Slot)c.property(), f);
                continue;
            }
            if (!typ.is(BLonData.TYPE)) continue;
            XUtil.tempToDeltaTemp((BLonData)obj);
        }
    }

    private static XCpTypeDef findStandardCpType(String type) {
        XLonInterfaceFile standard = XUtil.getStandard();
        Vector<XTypeDef> types = standard.types;
        for (int i = 0; i < types.size(); ++i) {
            XTypeDef t = types.elementAt(i);
            if (!t.isCpType() || !type.equals(t.getName())) continue;
            return (XCpTypeDef)t;
        }
        return null;
    }

    public static XCpTypeDef findCpType(String type) {
        XLonInterfaceFile standard = XUtil.getStandard();
        Vector<XTypeDef> types = standard.types;
        for (int i = 0; i < types.size(); ++i) {
            XTypeDef t = types.elementAt(i);
            if (!t.isCpType() || !type.equals(t.getName())) continue;
            return (XCpTypeDef)t;
        }
        return null;
    }

    public static XCpTypeDef findCpType(int scope, int index) {
        XLonInterfaceFile standard = XUtil.getStandard();
        Vector<XTypeDef> types = standard.types;
        String typeScope = Integer.toString(scope) + "," + Integer.toString(index);
        for (int i = 0; i < types.size(); ++i) {
            XTypeDef t = types.elementAt(i);
            if (!t.isCpType() || !t.getTypeScope().equals(typeScope)) continue;
            return (XCpTypeDef)t;
        }
        return null;
    }

    public static void addMinMax(XIConfig xc, BLonData dat) {
        XCpTypeDef xctd;
        XTypeDef xtd = xc.getXTypeDef();
        if (xtd == null || !xtd.isCpType() || (xctd = (XCpTypeDef)xtd).getMax() != null || xctd.getMin() != null) {
            // empty if block
        }
        float[] fmin = null;
        float[] fmax = null;
        if (xc.getMin().length() > 0) {
            fmin = XUtil.getFloats(xc.getMin());
        }
        if (xc.getMax().length() > 0) {
            fmax = XUtil.getFloats(xc.getMax());
        }
        if (fmin == null && fmax == null) {
            return;
        }
        XUtil.setFacets(dat, fmin, fmax, 0);
    }

    private static int setFacets(BLonData dat, float[] fmin, float[] fmax, int cnt) {
        SlotCursor c = dat.getProperties();
        while (c.nextObject()) {
            BValue obj = c.get();
            Type typ = obj.getType();
            if (typ.is(BLonPrimitive.TYPE)) {
                if (typ.is(BLonFloat.TYPE)) {
                    Property p = c.property();
                    BFacets f = p.getFacets();
                    if (fmin != null) {
                        f = BFacets.make((BFacets)f, (String)"min", (BIDataValue)BFloat.make((float)fmin[cnt]));
                    }
                    if (fmax != null) {
                        f = BFacets.make((BFacets)f, (String)"max", (BIDataValue)BFloat.make((float)fmax[cnt]));
                    }
                    dat.setFacets((Slot)p, f);
                }
                ++cnt;
                continue;
            }
            if (!typ.is(BLonData.TYPE)) continue;
            cnt = XUtil.setFacets(dat, fmin, fmax, cnt);
        }
        return cnt;
    }

    private static float[] getFloats(String f) {
        StringTokenizer st = new StringTokenizer(f, " ,|");
        int cnt = st.countTokens();
        float[] fa = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            fa[i] = Float.valueOf(st.nextToken()).floatValue();
        }
        return fa;
    }

    public static XLonInterfaceFile getStandard() {
        if (st == null) {
            try {
                BOrd ref = BOrd.make((String)"module://lonworks/javax/baja/lonworks/standard.lnml");
                st = LonXMLReader.decode(ref);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException("Cannot access standard.lnml " + e);
            }
        }
        return st;
    }
}

