/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.device.BLonLearnNvJob;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BLearnNvParameters;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="xmlFile", type="BOrd", defaultValue="BOrd.NULL", flags=1)
@NiagaraActions(value={@NiagaraAction(name="learnNv", flags=4), @NiagaraAction(name="learnNv_", parameterType="BLearnNvParameters", defaultValue="new BLearnNvParameters()", returnType="BOrd"), @NiagaraAction(name="trim"), @NiagaraAction(name="importXml", parameterType="BImportParameters", defaultValue="new BImportParameters()", flags=4)})
@NiagaraTopic(name="dynamicOpComplete")
public class BDynamicDevice
extends BLonDevice {
    @Generated
    public static final Property xmlFile = BDynamicDevice.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Action learnNv = BDynamicDevice.newAction((int)4, null);
    @Generated
    public static final Action learnNv_ = BDynamicDevice.newAction((int)0, (BValue)new BLearnNvParameters(), null);
    @Generated
    public static final Action trim = BDynamicDevice.newAction((int)0, null);
    @Generated
    public static final Action importXml = BDynamicDevice.newAction((int)4, (BValue)new BImportParameters(), null);
    @Generated
    public static final Topic dynamicOpComplete = BDynamicDevice.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDynamicDevice.class);

    @Generated
    public BOrd getXmlFile() {
        return (BOrd)this.get(xmlFile);
    }

    @Generated
    public void setXmlFile(BOrd v) {
        this.set(xmlFile, (BValue)v, null);
    }

    @Generated
    public void learnNv() {
        this.invoke(learnNv, null, null);
    }

    @Generated
    public BOrd learnNv_(BLearnNvParameters parameter) {
        return (BOrd)this.invoke(learnNv_, (BValue)parameter, null);
    }

    @Generated
    public void trim() {
        this.invoke(trim, null, null);
    }

    @Generated
    public void importXml(BImportParameters parameter) {
        this.invoke(importXml, (BValue)parameter, null);
    }

    @Generated
    public void fireDynamicOpComplete(BValue event) {
        this.fire(dynamicOpComplete, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.getXmlFile() != BOrd.NULL && this.getNetworkVariables().length == 0 && this.getNeuronIdAddress().isZero()) {
            this.doImportXml(new BImportParameters(false, this.getLonNetwork().netmgmt().getUseLonObjects()));
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == learnNv_) {
            BLonNetmgmt nm = this.getLonNetwork().netmgmt();
            this.getComponentSpace().update((BComponent)nm, 1);
            return new BLearnNvParameters(nm.getUseLonObjects());
        }
        return super.getActionParameterDefault(action);
    }

    public void doLearnNv() {
        if (this.getXmlFile() != BOrd.NULL) {
            throw new LocalizableRuntimeException("lonworks", "learnNv.block");
        }
        BLearnNvParameters param = new BLearnNvParameters(this.getLonNetwork().netmgmt().getUseLonObjects());
        new BLonLearnNvJob(this.getLonNetwork(), this, param).submit(null);
    }

    public BOrd doLearnNv_(BLearnNvParameters param) {
        if (this.getXmlFile() != BOrd.NULL) {
            throw new LocalizableRuntimeException("lonworks", "learnNv.block");
        }
        return new BLonLearnNvJob(this.getLonNetwork(), this, param).submit(null);
    }

    public void doImportXml(BImportParameters param) {
        if (this.getXmlFile().isNull()) {
            return;
        }
        XLonInterfaceFile root = LonXMLReader.decode(this.getXmlFile());
        DynaDev.importXLon(this, root, param);
    }

    public final void doImportXml(BImportParameters param, Logger log) {
        this.log = log;
        this.doImportXml(param);
    }

    public void doExportXml() {
        this.log().fine("doExportXml not implemented");
    }

    public final void doTrim() {
        BINetworkVariable[] nvs = this.getNetworkVariables();
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i] == null || !nvs[i].isNetworkVariable()) continue;
            BNetworkVariable nv = (BNetworkVariable)nvs[i];
            BComponent p = (BComponent)nv.getParent();
            Property nvProp = nv.getPropertyInParent();
            BNvConfigData nvCfg = nv.getNvConfigData();
            if (nv.hasProxies() || nvCfg.isBoundNv() || (!nvCfg.isInput() || p.getLinks((Slot)nvProp).length != 0) && (!nvCfg.isOutput() || p.getKnobs((Slot)nvProp).length != 0)) continue;
            p.remove((BComplex)nv);
            if (!this.log().isLoggable(Level.FINE)) continue;
            this.log().fine("trim " + this.getDisplayName(null) + ":" + nv.getDisplayName(null));
        }
    }
}

