/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="forceRead", flags=16), @NiagaraAction(name="forceWrite", flags=16), @NiagaraAction(name="update", parameterType="BLonData", defaultValue="new BLonData()", flags=4)})
public abstract class BLonComponent
extends BLonData {
    @Generated
    public static final Action forceRead = BLonComponent.newAction((int)16, null);
    @Generated
    public static final Action forceWrite = BLonComponent.newAction((int)16, null);
    @Generated
    public static final Action update = BLonComponent.newAction((int)4, (BValue)new BLonData(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonComponent.class);
    private BLonDevice dev = null;
    private BLonNetwork network = null;
    protected int subscribeCount = 0;
    public boolean illegalLength = false;

    @Generated
    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    @Generated
    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    @Generated
    public void update(BLonData parameter) {
        this.invoke(update, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BLonDevice || parent instanceof BLonObject;
    }

    public BLonDevice getDevice() {
        if (this.dev == null) {
            for (BLonComponent p = this; this.dev == null && p != null; p = p.getParent()) {
                if (!p.getType().is(BLonDevice.TYPE)) continue;
                this.dev = (BLonDevice)((Object)p);
            }
        }
        return this.dev;
    }

    private BLonNetwork getNetwork() {
        if (this.network != null) {
            return this.network;
        }
        BComplex p = this.getParent();
        while (!(p instanceof BLonNetwork)) {
            p = p.getParent();
        }
        this.network = (BLonNetwork)p;
        return this.network;
    }

    public final void started() throws Exception {
        super.started();
        this.dev = null;
        this.network = null;
        if (!this.isWriteable()) {
            this.setFlags((Slot)forceWrite, this.getFlags((Slot)forceWrite) | 4);
        }
        if (this.isForeignPersistent()) {
            this.readOk();
        }
        if ((this.isNetworkVariable() || this.isNetworkConfig()) && this.getByteLength() > Lon.maxNvLength()) {
            this.getDevice().log().severe(this.getDisplayName(null) + " disabled because length " + this.getByteLength() + " > " + Lon.maxNvLength() + " bytes");
            this.illegalLength = true;
        }
        this.lonComponentStarted();
    }

    public final void stopped() throws Exception {
        super.stopped();
        this.lonComponentStopped();
        this.dev = null;
        this.network = null;
    }

    public void lonComponentStarted() {
    }

    public void lonComponentStopped() {
    }

    public boolean isNavChild() {
        return Lon.lcInNavTree();
    }

    public BLonData getData() {
        BValue dat = this.get("data");
        if (dat != null && dat instanceof BLonData) {
            return (BLonData)dat;
        }
        return this;
    }

    public void setData(BLonData v) {
        int i;
        String typName = v.getType().getTypeName();
        if (!typName.equals(BLonData.TYPE.getTypeName())) {
            if (this.get("data") != null) {
                this.set("data", (BValue)v);
            } else {
                this.add("data", (BValue)v);
            }
            return;
        }
        Property[] a = this.getPropertiesArray();
        for (i = 0; i < a.length; ++i) {
            if (!BLonComponent.isDataProp(a[i])) continue;
            this.remove(a[i]);
        }
        a = v.getPropertiesArray();
        for (i = 0; i < a.length; ++i) {
            Property prop = a[i];
            if (!BLonComponent.isDataProp(prop)) continue;
            this.add(prop.getName(), v.get(prop), v.getFlags((Slot)prop), prop.getFacets(), null);
        }
    }

    public final BLonData copyData() {
        return (BLonData)this.getData().newCopy(true);
    }

    public final void updateData(BLonData data, boolean write) {
        if (this.isRunning()) {
            this.doUpdate(data);
            if (write) {
                this.doForceWrite();
            }
        } else {
            this.update(data);
            if (write) {
                this.forceWrite();
            }
        }
    }

    public final void doUpdate(BLonData dat) {
        BLonData myData = (BLonData)this.get("data");
        if (myData == null) {
            myData = this;
        }
        this.copyData(dat, myData);
        this.dataChanged(BLonNetwork.lonNoWrite);
    }

    private void copyData(BLonData src, BLonData dest) {
        Property[] pdest;
        Property[] psrc = src.getPropertiesArray();
        if (psrc.length != (pdest = dest.getPropertiesArray()).length) {
            throw new BajaRuntimeException("Unmatched Type in doUpdate " + this.getDisplayName(null));
        }
        for (int i = 0; i < psrc.length; ++i) {
            if (psrc[i].getType() != pdest[i].getType()) {
                throw new BajaRuntimeException("Unmatched Type in doUpdate " + this.getDisplayName(null));
            }
            if (psrc[i].getType().is(BLonPrimitive.TYPE)) {
                dest.set(pdest[i], src.get(psrc[i]), BLonNetwork.lonNoPropagateNoWrite);
                continue;
            }
            if (!psrc[i].getType().is(BLonData.TYPE)) continue;
            this.copyData((BLonData)src.get(psrc[i]), (BLonData)dest.get(pdest[i]));
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(forceRead)) {
            return this.postForceRead(cx);
        }
        if (action.equals(forceWrite)) {
            return this.postForceWrite(cx);
        }
        return super.post(action, arg, cx);
    }

    protected IFuture postForceRead(Context cx) {
        return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, forceRead, null, cx));
    }

    protected IFuture postForceWrite(Context cx) {
        if (!this.isWriteable()) {
            throw new LocalizableRuntimeException("lonworks", "lonComponent.notWritable");
        }
        return this.getNetwork().postWrite((Runnable)new Invocation((BComponent)this, forceWrite, null, cx));
    }

    public abstract void doForceWrite();

    public abstract void doForceRead();

    public boolean isForeignPersistent() {
        return false;
    }

    public boolean isWriteable() {
        return true;
    }

    public BLonDevice lonDevice() {
        return this.getDevice();
    }

    public BLonNetwork lonNetwork() {
        return this.getNetwork();
    }

    public boolean isNetworkVariable() {
        return false;
    }

    public boolean isNetworkConfig() {
        return false;
    }

    public boolean isConfigParameter() {
        return false;
    }

    public boolean isLocalNv() {
        return false;
    }

    public boolean isLocalNci() {
        return false;
    }

    @Override
    public void subscribed() {
        this.readSubscribed();
    }

    @Override
    public void unsubscribed() {
        this.readUnsubscribed();
    }

    @Override
    public void readSubscribed() {
        ++this.subscribeCount;
        if (this.subscribeCount == 1) {
            this.lonComponentSubscribed();
        }
    }

    public String debugName() {
        return this.getParent().getDisplayName(null) + ":" + this.getDisplayName(null) + " ";
    }

    @Override
    public void readUnsubscribed() {
        --this.subscribeCount;
        if (this.subscribeCount == 0) {
            this.lonComponentUnsubscribed();
        }
    }

    protected void lonComponentSubscribed() {
    }

    protected void lonComponentUnsubscribed() {
    }
}

