/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.device.BDownloadJob;
import com.tridium.lonworks.device.BUploadJob;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.local.BPseudoNvContainer;
import com.tridium.lonworks.netmgmt.BChangeNvTypeAction;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BILonLoadable;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.BMessageTag;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BConfigProps;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonObjectRequestEnum;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.proxy.BLonPointDeviceExt;
import javax.baja.lonworks.proxy.BLonPointFolder;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.lonworks.util.LonFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceData", type="BDeviceData", defaultValue="new BDeviceData()", flags=8), @NiagaraProperty(name="points", type="BLonPointDeviceExt", defaultValue="new BLonPointDeviceExt()"), @NiagaraProperty(name="messageIn", type="BMessageTag", defaultValue="new BMessageTag()", flags=1024)})
@NiagaraActions(value={@NiagaraAction(name="upload", parameterType="BUploadParameters", defaultValue="new BUploadParameters()"), @NiagaraAction(name="download", parameterType="BDownloadParameters", defaultValue="new BDownloadParameters()"), @NiagaraAction(name="reset"), @NiagaraAction(name="renewProxies", flags=4), @NiagaraAction(name="initImport", flags=4), @NiagaraAction(name="closeImport", flags=4)})
public class BLonDevice
extends BDevice
implements BINvContainer,
BILonLoadable {
    @Generated
    public static final Property deviceData = BLonDevice.newProperty((int)8, (BValue)new BDeviceData(), null);
    @Generated
    public static final Property points = BLonDevice.newProperty((int)0, (BValue)new BLonPointDeviceExt(), null);
    @Generated
    public static final Property messageIn = BLonDevice.newProperty((int)1024, (BValue)new BMessageTag(), null);
    @Generated
    public static final Action upload = BLonDevice.newAction((int)0, (BValue)new BUploadParameters(), null);
    @Generated
    public static final Action download = BLonDevice.newAction((int)0, (BValue)new BDownloadParameters(), null);
    @Generated
    public static final Action reset = BLonDevice.newAction((int)0, null);
    @Generated
    public static final Action renewProxies = BLonDevice.newAction((int)4, null);
    @Generated
    public static final Action initImport = BLonDevice.newAction((int)4, null);
    @Generated
    public static final Action closeImport = BLonDevice.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonDevice.class);
    NvDev.SaveNv snv = null;
    BLink[] toLnks = null;
    Object nvSync = new Object();
    BINetworkVariable[] nvList;
    protected boolean staleNvList = true;
    boolean linkUpdateDone = false;
    private int fileState = 0;
    private boolean hasReadOnly = false;
    private LonFile lonFile = null;
    private LonFile readWritefile = null;
    private LonFile readOnlyfile = null;
    private static final int FILE_STATE_INIT = 0;
    private static final int FILE_STATE_NO_FILES = 1;
    private static final int FILE_STATE_DOWNLOAD = 2;
    private static final int FILE_STATE_UPLOAD = 3;
    private static final int FILE_STATE_IDLE = 4;
    private int maxInMessageSize = 0;
    private int maxOutMessageSize = 0;
    public int dataPntMismatchCount = 0;
    protected Logger log = null;
    private BLonNetwork net = null;
    protected boolean downloading = false;
    protected boolean uploading = false;

    @Override
    @Generated
    public BDeviceData getDeviceData() {
        return (BDeviceData)this.get(deviceData);
    }

    @Generated
    public void setDeviceData(BDeviceData v) {
        this.set(deviceData, (BValue)v, null);
    }

    @Generated
    public BLonPointDeviceExt getPoints() {
        return (BLonPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BLonPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BMessageTag getMessageIn() {
        return (BMessageTag)this.get(messageIn);
    }

    @Generated
    public void setMessageIn(BMessageTag v) {
        this.set(messageIn, (BValue)v, null);
    }

    @Generated
    public void upload(BUploadParameters parameter) {
        this.invoke(upload, (BValue)parameter, null);
    }

    @Generated
    public void download(BDownloadParameters parameter) {
        this.invoke(download, (BValue)parameter, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public void renewProxies() {
        this.invoke(renewProxies, null, null);
    }

    @Generated
    public void initImport() {
        this.invoke(initImport, null, null);
    }

    @Generated
    public void closeImport() {
        this.invoke(closeImport, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean authenticate() {
        return this.getDeviceData().getAuthenticate();
    }

    public boolean isLocal() {
        return false;
    }

    public boolean programIdChanges() {
        return false;
    }

    public final BNeuronId getNeuronIdAddress() {
        return this.getDeviceData().getNeuronId();
    }

    public final BSubnetNode getSubnetNodeAddress() {
        return this.getDeviceData().getSubnetNodeId();
    }

    public final boolean isConfigOnline() {
        return this.getDeviceData().getNodeState() == BLonNodeState.configOnline;
    }

    public final boolean isConfigOffline() {
        return this.getDeviceData().getNodeState() == BLonNodeState.configOffline;
    }

    public final boolean isConfigured() {
        return this.isConfigOnline() || this.isConfigOffline();
    }

    public boolean isExtended() {
        return this.getDeviceData().isExtended();
    }

    public int getWorkingDomain() {
        return this.getDeviceData().getWorkingDomain();
    }

    public Type getNetworkType() {
        return BLonNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        BLonNetwork net = this.lonNetwork();
        if (!net.isServiceRunning() || this.isFatalFault()) {
            return;
        }
        if (this.lonComm() == null) {
            this.configFail("No LonComm stack available");
            this.log().warning("No LonComm stack available. Fix problems and restart station.");
            return;
        }
        DeviceFacets.moveDeviceFacets(this);
        this.lonDeviceInit();
        net.addressManager().registerLonDevice(this);
        this.lonDeviceStarted();
        this.changeableNvCheck();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.updateFaultCause();
    }

    public final void atSteadyState() {
        if (!this.lonNetwork().isServiceRunning() || this.isFatalFault()) {
            return;
        }
        this.ping();
        this.lonDeviceAtSteadyState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopped() throws Exception {
        try {
            this.net = null;
            this.log = null;
            this.clearFiles();
            Object object = this.nvSync;
            synchronized (object) {
                this.nvList = null;
                this.staleNvList = true;
            }
            this.lonNetwork().addressManager().unregisterLonDevice(this);
            if (!this.lonNetwork().isServiceRunning() || this.isFatalFault()) {
                return;
            }
            this.lonDeviceStopped();
        }
        finally {
            super.stopped();
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        if (property.getType().is(BLonComponent.TYPE)) {
            BLonDevice.lonComponentRenamed(this, property.getName(), oldName, context);
        }
    }

    static void lonComponentRenamed(BLonDevice dev, String newName, String oldName, Context context) {
        BControlPoint[] cps = dev.getLonProxies();
        for (int i = 0; i < cps.length; ++i) {
            BLonProxyExt lp = (BLonProxyExt)cps[i].getProxyExt();
            if (!lp.getTargetComp().equals(oldName)) continue;
            lp.setTargetComp(newName);
            lp.renew();
        }
    }

    public void updateDomainTable() {
        try {
            NmUtil.updateDomainTable(this.lonNetwork().getLonNetmgmt(), this);
        }
        catch (Throwable e) {
            this.log().log(Level.SEVERE, "Unable to update domain table in " + this.getDisplayName(null), e);
        }
    }

    public void updateNodeState() {
        try {
            BDeviceData dd = this.getDeviceData();
            BLonNodeState nState = dd.getNodeState();
            if (nState == BLonNodeState.applicationless && (dd.getHosted() || this.isLocal())) {
                try {
                    this.set(BDeviceData.nodeState, (BValue)NmUtil.getDeviceState(this), AddressManager.noDeviceChange);
                }
                catch (LonException lonException) {
                    // empty catch block
                }
                throw new BajaRuntimeException("Changing this device to applicationless state will render it inoperable.");
            }
            if (Lon.d()) {
                NmUtil.setDeviceState(this, nState);
            }
        }
        catch (Throwable e) {
            this.log().log(Level.SEVERE, "Unable to update nodeState in " + this.getDisplayName(null), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop == status) {
            this.statusChanged();
        }
        if (prop.getType().is(BINetworkVariable.TYPE)) {
            Object object = this.nvSync;
            synchronized (object) {
                this.staleNvList = true;
            }
        }
    }

    private void statusChanged() {
        this.updateFaultCause();
        BINetworkVariable[] nvs = this.getNvList();
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i] == null || !nvs[i].isNetworkVariable()) continue;
            ((BNetworkVariable)nvs[i]).getTuning().transition();
        }
    }

    protected void updateFaultCause() {
        if (this.isFault() && this.getFaultCause().length() == 0 && this.getLonNetwork().isFault()) {
            this.setFaultCause("Network fault: " + this.getLonNetwork().getFaultCause());
        }
        if (!this.isFault()) {
            this.setFaultCause("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(Property prop, Context context) {
        super.added(prop, context);
        if (prop.getType().is(BINetworkVariable.TYPE)) {
            Object object = this.nvSync;
            synchronized (object) {
                this.staleNvList = true;
            }
        } else if (prop.getType().is(BLonLink.TYPE)) {
            BLonLink lnk = (BLonLink)this.get(prop);
            if (this.isRunning() && !lnk.getMessageTag()) {
                lnk.getDestinationNv().lonLinkAdded();
            }
        }
    }

    public void checkRemove(Property prop, Context context) {
        this.snv = NvDev.checkRemove((BComponent)this, prop, context);
        super.checkRemove(prop, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(Property prop, BValue value, Context context) {
        super.removed(prop, value, context);
        if (prop.getType().is(BINetworkVariable.TYPE)) {
            Object object = this.nvSync;
            synchronized (object) {
                this.staleNvList = true;
            }
        }
        NvDev.removed((BComponent)this, this.snv, prop, value, context);
        this.snv = null;
    }

    public final void knobAdded(Knob knob, Context context) {
        NvDev.knobAdded((BComponent)this, knob, context);
    }

    public final void knobRemoved(Knob knob, Context context) {
        NvDev.knobRemoved((BComponent)this, knob, context);
    }

    public IFuture postAsync(Runnable r) {
        return ((BLonNetwork)this.getNetwork()).postAsync(r);
    }

    protected IFuture postPing() {
        return this.postAsync((Runnable)new Invocation((BComponent)this, ping, null, null));
    }

    public final void doUpload(BUploadParameters params, Context cx) throws Exception {
        this.checkState();
        this.checkUpload();
        new BUploadJob(this, params, cx).submit(cx);
    }

    public final void doDownload(BDownloadParameters params, Context cx) throws Exception {
        this.checkState();
        this.checkDownload();
        new BDownloadJob(this, params, cx).submit(cx);
    }

    public void checkState() {
        if (this.isDown()) {
            throw new LocalizableRuntimeException("lonworks", "check.down");
        }
        if (this.isDisabled()) {
            throw new LocalizableRuntimeException("lonworks", "check.disabled");
        }
        if (this.isFault()) {
            throw new LocalizableRuntimeException("lonworks", "check.fault");
        }
    }

    public void beginConfigWrite() {
    }

    public void endConfigWrite() {
    }

    public AgentList getAgents(Context cx) {
        AgentList alist = super.getAgents(cx);
        if (this.getAction("ChangeNvTypeAction") == null) {
            alist.remove("lonworks:ChangeableNvManager");
        }
        return NvDev.fixWireSheet(alist, cx);
    }

    public void doReset() {
        try {
            if (Lon.d()) {
                NmUtil.resetNode(this);
            }
        }
        catch (Throwable e) {
            this.log().log(Level.SEVERE, "Exception in LonDevice.reset()", e);
        }
    }

    public void doRenewProxies() {
        BControlPoint[] cps = this.getLonProxies();
        for (int i = 0; i < cps.length; ++i) {
            try {
                BLonProxyExt lp = (BLonProxyExt)cps[i].getProxyExt();
                lp.renew(true);
                continue;
            }
            catch (Throwable e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    public void doInitImport() {
        BINvContainer[] nvCntrs = this.getNvContainers();
        Array to = new Array(BLink.class);
        for (int i = 0; i < nvCntrs.length; ++i) {
            BLink[] lnks = nvCntrs[i].asComponent().getLinks();
            for (int ndx = 0; ndx < lnks.length; ++ndx) {
                if (!lnks[ndx].getType().is(BLonLink.TYPE)) continue;
                to.add((Object)lnks[ndx]);
            }
            Knob[] knobs = nvCntrs[i].asComponent().getKnobs();
            for (int ndx = 0; ndx < knobs.length; ++ndx) {
                BLink lnk = knobs[ndx].getLink();
                if (!lnk.getType().is(BLonLink.TYPE)) continue;
                to.add((Object)lnk);
            }
        }
        this.toLnks = (BLink[])to.trim();
    }

    public void doCloseImport() {
        this.doRenewProxies();
        if (this.toLnks == null) {
            return;
        }
        for (int i = 0; i < this.toLnks.length; ++i) {
            this.toLnks[i].deactivate();
            try {
                this.toLnks[i].activate();
                continue;
            }
            catch (Throwable e) {
                if (this.toLnks[i].getParent() == null) continue;
                ((BComponent)this.toLnks[i].getParent()).remove((BComplex)this.toLnks[i]);
            }
        }
        this.toLnks = null;
    }

    protected void lonDeviceInit() {
    }

    protected void lonDeviceStarted() {
    }

    protected void lonDeviceAtSteadyState() {
    }

    protected void lonDeviceStopped() {
    }

    public void deviceDataChanged(Property prop, Context context) {
        if (prop.equals(BDeviceData.programId)) {
            this.changeableNvCheck();
        }
        if (prop.equals(BDeviceData.subnetNodeId)) {
            this.updateLocallyBoundNvs();
        }
        if (prop == BDeviceData.neuronId) {
            this.clearMaxMessageLength();
        }
    }

    public void updateLocalState() {
    }

    public void beginCommission() {
    }

    public void postCommission() {
    }

    private void changeableNvCheck() {
        boolean hasChangeAction;
        if (this.isLocal()) {
            return;
        }
        boolean bl = hasChangeAction = this.getAction("ChangeNvTypeAction") != null;
        if (this.hasChangeableNvs()) {
            if (hasChangeAction) {
                return;
            }
            this.add("ChangeNvTypeAction", (BValue)new BChangeNvTypeAction(), 4);
        } else if (hasChangeAction) {
            this.remove("ChangeNvTypeAction");
        }
    }

    private void updateLocallyBoundNvs() {
        BINetworkVariable[] nvs = this.getNetworkVariables();
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i] == null || !nvs[i].isNetworkVariable()) continue;
            ((BNetworkVariable)nvs[i]).reregisterSelector();
        }
    }

    public boolean hasChangeableNvs() {
        return this.getDeviceData().getProgramId().hasChangeableNvs();
    }

    public void bound(int nvIndex) {
    }

    public void unbound(int nvIndex) {
    }

    public void bindComplete() {
    }

    public final BMessageTag getMessageTag(int mtIndex) {
        if (mtIndex == -1) {
            return this.getMessageIn();
        }
        SlotCursor c = this.getProperties();
        while (c.next(BMessageTag.class)) {
            BMessageTag mt = (BMessageTag)c.get();
            if (mt.getIndex() != mtIndex) continue;
            return mt;
        }
        return null;
    }

    @Override
    public BLonDevice getLonDevice() {
        return this;
    }

    @Override
    public BLonNetwork getLonNetwork() {
        return this.lonNetwork();
    }

    @Override
    public boolean isLonObject() {
        return false;
    }

    public BINvContainer[] getNvContainers() {
        Array a = new Array(BINvContainer.class);
        a.add((Object)this);
        this.doGetNvContainers((BComponent)this, (Array<BINvContainer>)a);
        return (BINvContainer[])a.trim();
    }

    private void doGetNvContainers(BComponent comp, Array<BINvContainer> a) {
        SlotCursor sc = comp.getProperties();
        while (sc.nextComponent()) {
            BComponent c = (BComponent)sc.get();
            if (c.getType().is(BINvContainer.TYPE) && !c.getType().is(BPseudoNvContainer.TYPE)) {
                a.add((Object)((BINvContainer)c));
                continue;
            }
            if (!c.getType().is(BLonObjectFolder.TYPE)) continue;
            this.doGetNvContainers(c, a);
        }
    }

    public BLonObject[] getLonObjects() {
        Array a = new Array(BLonObject.class);
        this.doGetLonObjects((BComponent)this, (Array<BLonObject>)a);
        return (BLonObject[])a.trim();
    }

    private void doGetLonObjects(BComponent comp, Array<BLonObject> a) {
        SlotCursor sc = comp.getProperties();
        while (sc.nextComponent()) {
            BComponent c = (BComponent)sc.get();
            if (c.getType().is(BLonObject.TYPE)) {
                a.add((Object)((BLonObject)c));
                continue;
            }
            if (!c.getType().is(BLonObjectFolder.TYPE)) continue;
            this.doGetLonObjects(c, a);
        }
    }

    public BLonObject getLonObject(int objectId) {
        return this.doGetLonObject((BComponent)this, objectId);
    }

    private BLonObject doGetLonObject(BComponent comp, int id) {
        SlotCursor sc = comp.getProperties();
        while (sc.nextComponent()) {
            BComponent c = (BComponent)sc.get();
            if (c.getType().is(BLonObject.TYPE)) {
                BLonObject lo = (BLonObject)c;
                if (lo.getObjectId() != id) continue;
                return lo;
            }
            if (!c.getType().is(BLonObjectFolder.TYPE)) continue;
            return this.doGetLonObject(c, id);
        }
        return null;
    }

    public final BNetworkVariable getNetworkVariable(int nvIndex) {
        if (nvIndex < 0) {
            return null;
        }
        BINetworkVariable[] nvs = this.getNvList();
        if (nvIndex >= nvs.length || nvs[nvIndex] == null || !nvs[nvIndex].isNetworkVariable()) {
            return null;
        }
        return (BNetworkVariable)nvs[nvIndex];
    }

    public final BNetworkConfig getNetworkConfig(int nvIndex) {
        if (nvIndex < 0) {
            return null;
        }
        BINetworkVariable[] nvs = this.getNvList();
        if (nvIndex >= nvs.length || nvs[nvIndex] == null || !nvs[nvIndex].isNetworkConfig()) {
            return null;
        }
        return (BNetworkConfig)nvs[nvIndex];
    }

    public final Property findLonObjectNvProperty(int objectIndex, int memberIndex, int snvtType) {
        BINetworkVariable[] nvs = this.getNvList();
        for (int i = 0; i < nvs.length; ++i) {
            BNetworkVariable nv;
            if (nvs[i] == null || !nvs[i].isNetworkVariable() || (nv = (BNetworkVariable)nvs[i]).getNvProps().getObjectIndex() != objectIndex || nv.getNvProps().getMemberIndex() != memberIndex) continue;
            if (snvtType > 0 && nv.getSnvtType() != snvtType) {
                throw new BajaRuntimeException("Invalid nvtype for object/member " + objectIndex + "|" + memberIndex + " snvtType=" + nv.getSnvtType() + ". Expected " + snvtType);
            }
            this.log().fine("found nv for " + objectIndex + "  " + memberIndex + " - " + nv.getDisplayName(null));
            return this.getProperty(nv.getName());
        }
        return null;
    }

    public final BINetworkVariable findSnvtType(int snvtType) {
        BINetworkVariable[] nvs = this.getNvList();
        for (int i = 0; i < nvs.length; ++i) {
            if (nvs[i] == null || nvs[i].getSnvtType() != snvtType) continue;
            return nvs[i];
        }
        return null;
    }

    @Override
    public final BINetworkVariable[] getNetworkVariables() {
        return this.getNvList();
    }

    public final BNetworkConfig[] getNetworkConfigs() {
        return (BNetworkConfig[])NmUtil.getDecendantsByClass((BComponent)this, BNetworkConfig.class);
    }

    public final BConfigParameter[] getConfigParameters() {
        return (BConfigParameter[])NmUtil.getDecendantsByClass((BComponent)this, BConfigParameter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshNvList() {
        Object object = this.nvSync;
        synchronized (object) {
            this.staleNvList = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BINetworkVariable[] getNvList() {
        Object object = this.nvSync;
        synchronized (object) {
            if (this.staleNvList) {
                int i;
                Vector<BINetworkVariable> v = new Vector<BINetworkVariable>(100);
                int maxNvIndex = -1;
                BINvContainer[] nvcs = this.getNvContainers();
                for (i = 0; i < nvcs.length; ++i) {
                    SlotCursor c = ((BComponent)nvcs[i]).getProperties();
                    while (c.next(BINetworkVariable.class)) {
                        BINetworkVariable nv = (BINetworkVariable)c.get();
                        int nvIndex = nv.getNvIndex();
                        if (nvIndex > maxNvIndex) {
                            maxNvIndex = nvIndex;
                        }
                        v.add(nv);
                    }
                }
                this.nvList = new BINetworkVariable[maxNvIndex + 1];
                for (i = 0; i < this.nvList.length; ++i) {
                    this.nvList[i] = null;
                }
                for (i = 0; i < v.size(); ++i) {
                    BINetworkVariable nv = (BINetworkVariable)v.elementAt(i);
                    if (nv.getNvIndex() < 0) continue;
                    this.nvList[nv.getNvIndex()] = nv;
                }
                this.staleNvList = false;
            }
            return this.nvList;
        }
    }

    public final BAliasConfigData getAlias(BNetworkVariable nv, int initialIndex) {
        BAliasTable tab = this.getDeviceData().getAliasTable();
        if (tab.getAliasCount() == 0) {
            return null;
        }
        int nvIndex = nv.getNvIndex();
        for (int i = initialIndex; i < tab.getAliasCount(); ++i) {
            BAliasConfigData aDat = tab.getAliasEntry(i);
            if (aDat.getPrimary() != nvIndex) continue;
            return aDat;
        }
        return null;
    }

    public BControlPoint[] getLonProxies() {
        return this.getLonProxies(null);
    }

    public BControlPoint[] getLonProxies(BLonComponent lc) {
        Array a = new Array(BControlPoint.class);
        this.getLonProxies((BComponent)this, (Array<BControlPoint>)a, lc);
        return (BControlPoint[])a.trim();
    }

    private void getLonProxies(BComponent comp, Array<BControlPoint> a, BLonComponent lc) {
        SlotCursor sc = comp.getProperties();
        while (sc.nextComponent()) {
            BAbstractProxyExt ext;
            BComponent c = (BComponent)sc.get();
            if (c.getType().is(BLonPointFolder.TYPE) || c.getType().is(BLonPointDeviceExt.TYPE)) {
                this.getLonProxies(c, a, lc);
                continue;
            }
            if (!c.getType().is(BControlPoint.TYPE) || !((ext = ((BControlPoint)c).getProxyExt()) instanceof BLonProxyExt) || lc != null && !((BLonProxyExt)ext).getTargetComp().equals(lc.getName())) continue;
            a.add((Object)((BControlPoint)c));
        }
    }

    public void doPing() {
        if (!this.isRunning() || !this.getEnabled() || !this.lonNetwork().isServiceRunning() || this.isFatalFault()) {
            return;
        }
        this.pingImpl();
    }

    private void pingImpl() {
        try {
            if (this.getNeuronIdAddress().isZero()) {
                throw new RuntimeException("Neuron id is zero");
            }
            if (this.getDeviceData().getNodeState() == BLonNodeState.unknown) {
                throw new RuntimeException("Unknown state - Device requires commissioning");
            }
            if (Lon.d()) {
                NmUtil.getDeviceState(this);
            }
            this.pingOk();
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)false));
        }
        catch (NotRunningException notRunningException) {
        }
        catch (Throwable e) {
            this.pingFail(e.getMessage());
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
        }
    }

    public boolean isReadyForNvUpdates() {
        return Sys.atSteadyState() && this.getStatus().isValid() && this.isConfigOnline() && this.getEnabled();
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        return NvDev.doNvCheckLink(source, sourceSlot, (BComponent)this, targetSlot, cx);
    }

    @Override
    public void linkUpdate() {
        if (this.linkUpdateDone) {
            return;
        }
        this.getComponentSpace().update((BComponent)this, 1);
        this.getComponentSpace().update((BComponent)this.getDeviceData(), 2);
        this.linkUpdateDone = true;
        BINvContainer[] ca = this.getNvContainers();
        for (int i = 1; i < ca.length; ++i) {
            ca[i].linkUpdate();
        }
    }

    public final BLink makeLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        if (!NvDev.requiresLonLink(targetSlot)) {
            return super.makeLink(source, sourceSlot, targetSlot, cx);
        }
        return NvDev.makeLonLink(source, sourceSlot, (BComponent)this, targetSlot, cx);
    }

    final void initDownload(boolean allowRandomAccess) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return;
            }
            if (this.readWritefile != null && !this.readWritefile.isOpen()) {
                if (!this.hasReadOnly && this.hasReadOnlyCp()) {
                    if (this.readWritefile.supportsRandomAccess()) {
                        this.readWritefile.open(1, true, true);
                    } else {
                        this.readWritefile.open(1, false, false);
                    }
                } else {
                    this.readWritefile.open(1, true, allowRandomAccess);
                }
            }
            if (this.readOnlyfile != null && !this.readOnlyfile.isOpen()) {
                this.readOnlyfile.open(2, true, allowRandomAccess);
            }
        }
        catch (LonException e) {
            this.close();
            this.clearFiles();
            throw new BajaRuntimeException("Unable to open files for download.", (Throwable)((Object)e));
        }
        this.fileState = 2;
    }

    private boolean hasReadOnlyCp() {
        BINvContainer[] nvcs = this.getNvContainers();
        for (int i = 0; i < nvcs.length; ++i) {
            SlotCursor c = ((BComponent)nvcs[i]).getProperties();
            while (c.next(BConfigParameter.class)) {
                BConfigParameter cp = (BConfigParameter)c.get();
                if (cp.isWriteable()) continue;
                return true;
            }
        }
        return false;
    }

    final void cleanupDownload() {
        this.close();
        this.fileState = 4;
    }

    public final boolean isDownLoadInProgress() {
        return this.downloading;
    }

    public final boolean isUpLoadInProgress() {
        return this.uploading;
    }

    public void checkUpload() {
    }

    @Override
    public void beginUpload() {
        this.uploading = true;
        this.initUpload(false);
    }

    @Override
    public void endUpload() {
        this.cleanupUpload();
        this.uploading = false;
    }

    public void checkChangeNvType() {
    }

    public void changeNvTypeComplete() {
    }

    public void checkDownload() {
    }

    @Override
    public void beginDownload() {
        this.downloading = true;
        this.initDownload(false);
    }

    @Override
    public void endDownload() {
        this.cleanupDownload();
        this.downloading = false;
    }

    final void initUpload(boolean allowRandomAccess) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return;
            }
            if (this.readWritefile != null && !this.readWritefile.isOpen()) {
                this.readWritefile.open(1, false, allowRandomAccess);
            }
            if (this.readOnlyfile != null && !this.readOnlyfile.isOpen()) {
                this.readOnlyfile.open(2, false, allowRandomAccess);
            }
        }
        catch (LonException e) {
            this.close();
            this.clearFiles();
            throw new BajaRuntimeException("Unable to open files for upload.", (Throwable)((Object)e));
        }
        this.fileState = 3;
    }

    final void cleanupUpload() {
        this.close();
        this.fileState = 4;
    }

    public final LonFile getLonFileOpen(int fileNum) {
        return this.getLonFileOpen(fileNum, false, true);
    }

    public final LonFile getLonFileOpen(int fileNum, boolean create, boolean random) {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile f = this.lonFile.copy();
            if (fileNum < 0) {
                return f;
            }
            if (f != null && !f.isOpen()) {
                f.open(fileNum, create, random);
            }
            return f;
        }
        catch (LonException e) {
            e.printStackTrace();
            this.log().log(Level.SEVERE, "error accessing file " + fileNum, (Throwable)((Object)e));
            return null;
        }
    }

    protected LonFile getReadWriteFile() {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile f = this.readWritefile;
            if (f != null && !f.isOpen()) {
                f.open(1, false, true);
            }
            return f;
        }
        catch (LonException e) {
            e.printStackTrace();
            this.log().log(Level.SEVERE, "error accessing file readOnly config file", (Throwable)((Object)e));
            return null;
        }
    }

    protected LonFile getReadOnlyFile() {
        try {
            if (this.fileState == 0) {
                this.createFiles();
            }
            if (this.fileState == 1) {
                return null;
            }
            LonFile f = this.readOnlyfile;
            int fnum = 2;
            if (!this.hasReadOnly) {
                f = this.readWritefile;
                fnum = 1;
            }
            if (f != null && !f.isOpen()) {
                f.open(fnum, false, true);
            }
            return f;
        }
        catch (LonException e) {
            e.printStackTrace();
            this.log().log(Level.SEVERE, "error accessing file readOnly config file", (Throwable)((Object)e));
            return null;
        }
    }

    private void createFiles() throws LonException {
        if (!this.getDeviceData().getHasNodeObject()) {
            this.fileState = 1;
            return;
        }
        this.lonFile = LonFile.createFile(this);
        if (this.lonFile == null) {
            this.fileState = 1;
            return;
        }
        if (this.lonFile.findFileNum(2) == 0) {
            this.readWritefile = this.lonFile;
            boolean bl = this.hasReadOnly = this.lonFile.findFileNum(1, 1) > 0;
            if (this.hasReadOnly) {
                this.readOnlyfile = this.lonFile.copy();
            }
        }
        this.fileState = 4;
    }

    private void close() {
        if (this.lonFile != null) {
            try {
                this.lonFile.close();
            }
            catch (LonException lonException) {
                // empty catch block
            }
        }
        if (this.readWritefile != null) {
            try {
                this.readWritefile.close();
            }
            catch (LonException lonException) {
                // empty catch block
            }
        }
        if (this.readOnlyfile != null) {
            try {
                this.readOnlyfile.close();
            }
            catch (LonException lonException) {
                // empty catch block
            }
        }
    }

    public final void clearFiles() {
        this.fileState = 0;
        this.lonFile = null;
        this.readWritefile = null;
        this.readOnlyfile = null;
    }

    @Deprecated
    public boolean disableObjectForCpWrite(BConfigProps configProps) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public void enableObject(BConfigProps configProps) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    public final void resetDevice() {
        throw new UnsupportedOperationException("Deprecated : use doReset()");
    }

    public boolean isObjectDisabled(int objNdx) {
        if (!this.isConfigOnline()) {
            return true;
        }
        Property reqProp = this.findLonObjectNvProperty(0, 1, 92);
        int reqNdx = ((BNetworkVariable)this.get(reqProp)).getNvIndex();
        if (reqNdx < 0) {
            throw new BajaRuntimeException("Can not find SNVT_OBJ_REQUEST in " + this.getDisplayName(null));
        }
        BNetworkVariable reqNv = this.getNetworkVariable(reqNdx);
        Property statNdx = this.findLonObjectNvProperty(0, 2, 93);
        if (statNdx == null) {
            throw new BajaRuntimeException("Can not find nvoStatus.");
        }
        BNetworkVariable statNv = (BNetworkVariable)this.get(statNdx);
        try {
            this.sendObjectRequest(BLonObjectRequestEnum.rqUpdateStatus, objNdx, reqNv);
            NmUtil.wait(50);
            BNetworkVariable objStat = this.getObjectStatus(objNdx, statNv);
            return objStat.getData().getLonBoolean("disabled");
        }
        catch (LonException e) {
            throw new BajaRuntimeException("Unable to set object " + objNdx + " status in " + this.getDisplayName(null), (Throwable)((Object)e));
        }
    }

    public boolean enableObject(int objNdx, boolean en) {
        if (objNdx < 0) {
            return false;
        }
        Property reqProp = this.findLonObjectNvProperty(0, 1, 92);
        int reqNdx = ((BNetworkVariable)this.get(reqProp)).getNvIndex();
        if (reqNdx < 0) {
            return false;
        }
        BNetworkVariable reqNv = this.getNetworkVariable(reqNdx);
        Property statNdx = this.findLonObjectNvProperty(0, 2, 93);
        if (statNdx == null) {
            return false;
        }
        BNetworkVariable statNv = (BNetworkVariable)this.get(statNdx);
        for (int attempts = 3; attempts > 0; --attempts) {
            try {
                BLonObjectRequestEnum req = en ? BLonObjectRequestEnum.rqEnable : BLonObjectRequestEnum.rqDisabled;
                this.sendObjectRequest(req, objNdx, reqNv);
                NmUtil.wait(50);
                BNetworkVariable objStat = this.getObjectStatus(objNdx, statNv);
                if (objStat.getData().getLonBoolean("invalidRequest")) {
                    return false;
                }
                if (objStat.getData().getLonBoolean("disabled") != en) continue;
                return true;
            }
            catch (Exception e) {
                System.out.println("enableObject() " + e);
                e.printStackTrace();
            }
        }
        return false;
    }

    private void sendObjectRequest(BLonObjectRequestEnum req, int objNdx, BNetworkVariable nv) throws LonException {
        BLonData ld = nv.getData();
        ld.setLonInt("objectId", objNdx, BLonNetwork.lonNoWrite);
        ld.setLonEnum("objectRequest", req.getTag(), BLonNetwork.lonNoWrite);
        nv.doForceWrite();
    }

    private BNetworkVariable getObjectStatus(int objNdx, BNetworkVariable statNv) throws LonException {
        for (int i = 0; i < 4; ++i) {
            int objId;
            if (!statNv.getNvProps().getBoundToLocal()) {
                statNv.doForceRead();
            }
            if ((objId = statNv.getData().getLonInt("objectId")) == objNdx) {
                return statNv;
            }
            NmUtil.wait(100);
        }
        throw new LonException("Can not read status nv");
    }

    void disableObjectsForWrite(int[] sels, boolean[] objDis) {
        if (this.isDownLoadInProgress() || !this.isConfigOnline()) {
            for (int i = 0; i < sels.length; ++i) {
                objDis[i] = false;
            }
            return;
        }
        for (int i = 0; i < sels.length; ++i) {
            if (this.isObjectDisabled(sels[i])) {
                objDis[i] = false;
                continue;
            }
            try {
                objDis[i] = this.enableObject(sels[i], false);
                continue;
            }
            catch (Throwable e) {
                objDis[i] = false;
                System.out.println(e);
            }
        }
    }

    void enableObjectsAfterWrite(int[] sels, boolean[] objDis) {
        for (int i = 0; i < sels.length; ++i) {
            if (!objDis[i]) continue;
            try {
                this.enableObject(sels[i], true);
                continue;
            }
            catch (Throwable e) {
                System.out.println(e);
            }
        }
    }

    public int getMaxMessageLengthOut() {
        if (this.maxOutMessageSize == 0) {
            this.updateMaxMessageLength();
        }
        return this.maxOutMessageSize;
    }

    public int getMaxMessageLengthIn() {
        if (this.maxInMessageSize == 0) {
            this.updateMaxMessageLength();
        }
        return this.maxInMessageSize;
    }

    private final void clearMaxMessageLength() {
        this.maxOutMessageSize = 0;
        this.maxInMessageSize = 0;
    }

    public final void updateMaxMessageLength() {
        try {
            if (!Lon.d()) {
                return;
            }
            byte[] a = Neuron.readMemory(this.lonComm(), 1, NmUtil.getSendAddress(this), 21, 5, this.authenticate(), false, 8);
            boolean explicit = (a[0] >> 5 & 1) > 0;
            int appBufOutSize = Neuron.getBufferSize((a[3] & 0xF0) >> 4);
            int appBufInSize = Neuron.getBufferSize(a[3] & 0xF);
            int netBufOutSize = Neuron.getBufferSize((a[4] & 0xF0) >> 4);
            int netBufInSize = Neuron.getBufferSize(a[4] & 0xF);
            int appOverhead = explicit ? 16 : 5;
            this.maxInMessageSize = Math.min(appBufInSize - appOverhead, netBufInSize - 26);
            this.maxOutMessageSize = Math.min(appBufOutSize - appOverhead, netBufOutSize - 26);
            if (!this.isLocal()) {
                BLocalLonDevice local = this.lonNetwork().getLocalLonDevice();
                this.maxInMessageSize = Math.min(this.maxInMessageSize, local.getMaxMessageLengthOut());
                this.maxOutMessageSize = Math.min(this.maxOutMessageSize, local.getMaxMessageLengthIn());
            }
            if (this.maxInMessageSize < 0) {
                this.maxInMessageSize = 8;
            }
            if (this.maxOutMessageSize < 0) {
                this.maxOutMessageSize = 8;
            }
        }
        catch (Exception e) {
            this.maxInMessageSize = 8;
            this.maxOutMessageSize = 8;
            this.log().log(Level.SEVERE, "error reading buffer size ", e);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.trTitle((Object)"LonDevice", 1);
        out.startProps("Files");
        out.prop((Object)"Has node object", this.getDeviceData().getHasNodeObject());
        switch (this.fileState) {
            case 0: {
                out.prop((Object)"File state", (Object)"FILE_STATE_INIT    ");
                break;
            }
            case 1: {
                out.prop((Object)"File state", (Object)"FILE_STATE_NO_FILES");
                break;
            }
            case 2: {
                out.prop((Object)"File state", (Object)"FILE_STATE_DOWNLOAD");
                break;
            }
            case 3: {
                out.prop((Object)"File state", (Object)"FILE_STATE_UPLOAD  ");
                break;
            }
            case 4: {
                out.prop((Object)"File state", (Object)"FILE_STATE_IDLE    ");
                break;
            }
            default: {
                out.prop((Object)"File state", (Object)"unknown");
            }
        }
        out.prop((Object)"Has readWrite file", this.readWritefile != null);
        out.prop((Object)"Has readOnly file", this.readOnlyfile != null);
        out.prop((Object)"maxMessageSizeIn", this.getMaxMessageLengthIn());
        out.prop((Object)"maxMessageSizeOut", this.getMaxMessageLengthOut());
        out.prop((Object)"dataPntMismatchCount", this.dataPntMismatchCount);
        out.prop((Object)"downloading", this.downloading);
        out.prop((Object)"uploading", this.uploading);
        out.endProps();
        DeviceFacets.spy(this, out);
    }

    public final LonComm lonComm() {
        return this.lonNetwork().lonComm();
    }

    public Logger log() {
        if (this.log == null) {
            this.log = this.lonNetwork().log();
        }
        return this.log;
    }

    public final BLonNetwork lonNetwork() {
        if (this.net == null) {
            BComplex p;
            for (p = this.getParent(); p != null && !(p instanceof BLonNetwork); p = p.getParent()) {
            }
            if (p != null) {
                this.net = (BLonNetwork)p;
            }
        }
        return this.net;
    }
}

