/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import javax.baja.util.BNullConverter;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="linkType", type="BLonLinkType", defaultValue="BLonLinkType.standard"), @NiagaraProperty(name="priority", type="boolean", defaultValue="false"), @NiagaraProperty(name="messageTag", type="boolean", defaultValue="false"), @NiagaraProperty(name="remoteLink", type="boolean", defaultValue="false"), @NiagaraProperty(name="pseudoLink", type="boolean", defaultValue="false")})
public class BLonLink
extends BConversionLink {
    @Generated
    public static final Property linkType = BLonLink.newProperty((int)0, (BValue)BLonLinkType.standard, null);
    @Generated
    public static final Property priority = BLonLink.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property messageTag = BLonLink.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property remoteLink = BLonLink.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property pseudoLink = BLonLink.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLonLink.class);

    public BLonLink(BComponent source, Slot sourceSlot, Slot targetSlot) {
        super(source, sourceSlot, targetSlot, (BConverter)new BNullConverter());
    }

    public BLonLink(BOrd sourceOrd, String sourceSlot, String targetSlot, boolean enabled) {
        super(sourceOrd, sourceSlot, targetSlot, enabled, (BConverter)new BNullConverter());
    }

    public BLonLink() {
    }

    @Generated
    public BLonLinkType getLinkType() {
        return (BLonLinkType)this.get(linkType);
    }

    @Generated
    public void setLinkType(BLonLinkType v) {
        this.set(linkType, (BValue)v, null);
    }

    @Generated
    public boolean getPriority() {
        return this.getBoolean(priority);
    }

    @Generated
    public void setPriority(boolean v) {
        this.setBoolean(priority, v, null);
    }

    @Generated
    public boolean getMessageTag() {
        return this.getBoolean(messageTag);
    }

    @Generated
    public void setMessageTag(boolean v) {
        this.setBoolean(messageTag, v, null);
    }

    @Generated
    public boolean getRemoteLink() {
        return this.getBoolean(remoteLink);
    }

    @Generated
    public void setRemoteLink(boolean v) {
        this.setBoolean(remoteLink, v, null);
    }

    @Generated
    public boolean getPseudoLink() {
        return this.getBoolean(pseudoLink);
    }

    @Generated
    public void setPseudoLink(boolean v) {
        this.setBoolean(pseudoLink, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void lonActivate() {
        if (this.getMessageTag()) {
            return;
        }
        this.getDestinationNv();
    }

    void propagateNv(BNetworkVariable srcNv) {
        BLonData destData;
        if (this.getMessageTag()) {
            return;
        }
        BNetworkVariable destNv = this.getDestinationNv();
        if (!this.getRemoteLink() && !this.getPseudoLink() && this.isBound(srcNv, destNv)) {
            return;
        }
        BLonData srcData = srcNv.getData();
        if (!this.propagateObjects(srcData, destData = destNv.getData())) {
            destData.fromNetBytes(srcData.toNetBytes());
        }
        destNv.dataChanged(null);
    }

    public boolean isBound(BNetworkVariable srcNv) {
        if (this.getMessageTag()) {
            return false;
        }
        return this.isBound(srcNv, this.getDestinationNv());
    }

    private boolean isBound(BNetworkVariable srcNv, BNetworkVariable destNv) {
        BNvConfigData srcNvCfg = srcNv.getNvConfigData();
        BNvConfigData destNvCfg = destNv.getNvConfigData();
        if (srcNvCfg.isBoundNv() && destNvCfg.isBoundNv()) {
            if (srcNvCfg.getSelector() == destNvCfg.getSelector()) {
                return true;
            }
            if (srcNv.lonDevice().getAlias(srcNv, 0) != null) {
                return true;
            }
        }
        return false;
    }

    public BNetworkVariable getDestinationNv() {
        BComponent t = this.getTargetComponent();
        Property tProp = this.getTargetSlot().asProperty();
        return (BNetworkVariable)t.get(tProp);
    }

    private BNetworkVariable getSourceNv() {
        BComponent s = this.getSourceComponent();
        Property sProp = this.getSourceSlot().asProperty();
        return (BNetworkVariable)s.get(sProp);
    }

    private boolean propagateObjects(BLonData src, BLonData dest) {
        Property[] da;
        Property[] sa = src.getPropertiesArray();
        if (sa.length != (da = dest.getPropertiesArray()).length) {
            return false;
        }
        try {
            for (int i = 0; i < sa.length; ++i) {
                Property srcProp = sa[i];
                Property destProp = da[i];
                if (srcProp.getType() != destProp.getType()) {
                    return false;
                }
                if (srcProp.getType().is(BLonPrimitive.TYPE)) {
                    dest.set(destProp, src.get(srcProp), BLonNetwork.lonNoWrite);
                    continue;
                }
                if (!srcProp.getType().is(BLonData.TYPE) || this.propagateObjects((BLonData)src.get(srcProp), (BLonData)dest.get(destProp))) continue;
                return false;
            }
        }
        catch (Throwable e) {
            System.out.println("Error in propagateObjects." + this.toString(null) + "\n" + e);
            return false;
        }
        return true;
    }

    public final void propagate(BValue arg) {
        if (this.getMessageTag()) {
            return;
        }
        BNetworkVariable srcNv = this.getSourceNv();
        if (!srcNv.isRunning()) {
            return;
        }
        this.propagateNv(srcNv);
    }

    public String toString(Context c) {
        return (this.getMessageTag() ? "msgTag " : "") + super.toString(c) + "| linkType = " + (Object)((Object)this.getLinkType()) + " priority = " + this.getPriority();
    }
}

