/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BLonInteger
extends BLonPrimitive
implements BINumeric {
    public static final BLonInteger DEFAULT = new BLonInteger(0);
    public static final Type TYPE = Sys.loadType(BLonInteger.class);
    private int value;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BLonInteger make(int value) {
        return new BLonInteger(value);
    }

    private BLonInteger(int value) {
        this.value = value;
    }

    public int getInt() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLonInteger) {
            return ((BLonInteger)((Object)obj)).value == this.value;
        }
        return false;
    }

    public int compareTo(Object obj) {
        int a = this.value;
        int b = ((BNumber)obj).getInt();
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public String toString(Context context) {
        return String.valueOf(this.value);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public BObject decode(DataInput in) throws IOException {
        return BLonInteger.make(in.readInt());
    }

    public String encodeToString() throws IOException {
        return String.valueOf(this.value);
    }

    public static String encodeToString(int value) {
        return String.valueOf(value);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BLonInteger.make(Integer.parseInt(s));
        }
        catch (Throwable e) {
            throw new IOException("Invalid integer: " + s);
        }
    }

    public static int intFromString(String s) throws IOException {
        try {
            return Integer.parseInt(s);
        }
        catch (Throwable e) {
            throw new IOException("Invalid integer: " + s);
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out, BLonElementQualifiers e) {
        switch (e.getElemtype().getOrdinal()) {
            case 0: {
                out.writeUnsigned8(this.value);
                break;
            }
            case 1: {
                out.writeSigned8(this.value);
                break;
            }
            case 2: {
                out.writeUnsigned8(this.value);
                break;
            }
            case 3: {
                out.writeSigned16(this.value);
                break;
            }
            case 4: {
                out.writeUnsigned16(this.value);
                break;
            }
            case 5: {
                out.writeSigned32(this.value);
                break;
            }
            case 12: {
                out.writeBit(this.value, e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 13: {
                out.writeSignedBit(this.value, e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalueid datatype for LonInteger.");
            }
        }
    }

    @Override
    public BLonPrimitive fromInputStream(LonInputStream in, BLonElementQualifiers e) {
        int val;
        switch (e.getElemtype().getOrdinal()) {
            case 0: {
                val = in.readUnsigned8();
                break;
            }
            case 1: {
                val = in.readSigned8();
                break;
            }
            case 2: {
                val = in.readUnsigned8();
                break;
            }
            case 3: {
                val = in.readSigned16();
                break;
            }
            case 4: {
                val = in.readUnsigned16();
                break;
            }
            case 5: {
                val = in.readSigned32();
                break;
            }
            case 12: {
                val = in.readBit(e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            case 13: {
                val = in.readSignedBit(e.getByteOffset(), e.getBitOffset(), e.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonInteger.");
            }
        }
        if (this.value == val) {
            return this;
        }
        return BLonInteger.make(val);
    }

    @Override
    public double getDataAsDouble() {
        return this.value;
    }

    @Override
    public BLonPrimitive makeFromDouble(double value, BLonElementQualifiers e) {
        return BLonInteger.make((int)value);
    }

    @Override
    public final boolean isNumeric() {
        return true;
    }

    @Override
    public boolean getDataAsBoolean() {
        return this.value != 0;
    }

    @Override
    public BLonPrimitive makeFromBoolean(boolean v) {
        return BLonInteger.make(v ? 1 : 0);
    }

    @Override
    public String getDataAsString() {
        return Integer.toString(this.value);
    }

    @Override
    public BLonPrimitive makeFromString(String stringValue) {
        int i = 0;
        try {
            i = Integer.valueOf(stringValue);
        }
        catch (Throwable e) {
            return null;
        }
        return BLonInteger.make(i);
    }

    public double getNumeric() {
        return this.getDataAsDouble();
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }
}

