/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BMemberStateEnum;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.Acknowledge;
import com.tridium.lonIp.messages.ChannelMembership;
import com.tridium.lonIp.messages.ChannelRouting;
import com.tridium.lonIp.messages.DeviceRegistration;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonIp.messages.RequestMessage;
import com.tridium.lonIp.messages.SendList;
import com.tridium.lonIp.messages.StatisticsResp;
import com.tridium.lonworks.util.NmUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.sys.Context;

public class ConfigServer
implements Runnable,
LonIp {
    private boolean isConfigServer = false;
    private boolean useExtendedNat = false;
    private BDateTime sendlistDt = BDateTime.DEFAULT;
    private BDateTime chanMembershipDt = BDateTime.DEFAULT;
    private boolean newTime = false;
    private BLonNetwork lonworks;
    private LonIpLinkLayer link;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private BMemberTable memTab;
    private Thread rcvThread = null;
    private Thread srvThread = null;
    private boolean enabled = false;
    private Logger log = null;
    private DatagramSocket udpPort;
    private Statistics stats;

    public ConfigServer(BLonNetwork lonworks, LonIpLinkLayer link) {
        this.lonworks = lonworks;
        this.link = link;
        this.ipChan = (BIpChannel)lonworks.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        this.log = Logger.getLogger(lonworks.getLogName() + ".configServer");
        this.ipChan.registerConfigServer(this);
        this.stats = new Statistics();
    }

    public void start() throws Exception {
        this.updateListTime(true);
        this.newTime = false;
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (!this.isConfigServer) {
            return;
        }
        InetAddress hostIp = this.netCfg.getMyIpAddress().getInetAddress();
        this.udpPort = new DatagramSocket(this.netCfg.getConfigServerPort(), hostIp);
        if (this.udpPort == null) {
            String err = "DatagramSocket is null!  Socket " + this.netCfg.getConfigServerPort() + " may be in use by another process.";
            this.log.severe(err);
            throw new LonException(err);
        }
        this.enabled = true;
        this.rcvThread = new Thread((Runnable)this, this.lonworks.getLogName() + ".LonIpConfigSvrRcv");
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.srvThread = new Thread((Runnable)new ConfigService(), this.lonworks.getLogName() + ".LonIpConfigSvr");
        this.srvThread.start();
        this.srvThread.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateListTime(boolean updateSendList) {
        this.chanMembershipDt = BDateTime.make();
        if (updateSendList) {
            this.sendlistDt = this.chanMembershipDt;
        }
        this.memTab.setTimeStamp(this.chanMembershipDt);
        ConfigServer configServer = this;
        synchronized (configServer) {
            this.newTime = true;
        }
    }

    public void stop() {
        this.enabled = false;
        if (this.rcvThread != null) {
            this.rcvThread.interrupt();
        }
        if (this.srvThread != null) {
            this.srvThread.interrupt();
        }
        if (this.udpPort != null) {
            this.udpPort.close();
        }
    }

    @Override
    public void run() {
        block7: while (this.enabled) {
            byte[] packBuf = new byte[1600];
            try {
                DatagramPacket packIn = new DatagramPacket(packBuf, 1600);
                try {
                    this.udpPort.receive(packIn);
                }
                catch (InterruptedIOException e) {
                    continue;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.link.writeLinkDebug("CS Rcvd:" + packIn.getAddress() + ":" + packIn.getPort() + "  ", packBuf, packIn.getLength());
                }
                int rcvLen = packIn.getLength();
                int offset = 0;
                byte[] b = packBuf;
                while (offset < rcvLen) {
                    LonIpMessage newMsg = LonIpMessage.make(b);
                    newMsg.setSrcAddress(packIn.getAddress());
                    newMsg.setSrcPort(packIn.getPort());
                    this.processIpMessage(newMsg);
                    this.stats.receivedMsg(newMsg, newMsg.getSrcAddress(), newMsg.packetLength);
                    if ((offset += newMsg.packetLength) >= rcvLen) continue;
                    int nxtLen = ((packBuf[offset] & 0xFF) << 8) + (packBuf[offset + 1] & 0xFF);
                    if (nxtLen + offset > rcvLen) continue block7;
                    b = new byte[nxtLen];
                    System.arraycopy(packBuf, offset, b, 0, nxtLen);
                }
            }
            catch (SocketException e) {
                if (!this.enabled) continue;
                this.log.log(Level.SEVERE, "SocketException in ConfigServer!", e);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Error receiving LonIp packet!", e);
            }
            catch (ThreadDeath e) {
                this.enabled = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.log(Level.SEVERE, "LonIpConfigSvr error", e);
            }
        }
    }

    private void processIpMessage(LonIpMessage msg) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        switch (msg.packetType) {
            case 3: 
            case 113: {
                this.rcvDeviceRegistration((DeviceRegistration)msg);
                break;
            }
            case 8: {
                this.rcvChannelRouting((ChannelRouting)msg);
                break;
            }
            case 7: {
                this.rcvAcknowledge((Acknowledge)msg);
                break;
            }
            case 100: {
                this.rcvChannelMembershipRequest((RequestMessage)msg);
                break;
            }
            case 102: {
                this.rcvSendListRequest((RequestMessage)msg);
                break;
            }
            case 104: {
                this.rcvChannelRoutingRequest((RequestMessage)msg);
                break;
            }
            case 96: {
                this.rcvStatusRequest((RequestMessage)msg);
                break;
            }
            case 4: 
            case 6: 
            case 99: 
            case 112: {
                this.sendAck(msg, 5);
                break;
            }
            default: {
                if (!this.log.isLoggable(Level.FINE)) break;
                this.log.fine("cs Packet type not implemented:" + Integer.toString(msg.packetType, 16));
            }
        }
    }

    public void networkConfigChanged(Context cx) {
        if (!this.lonworks.isRunning()) {
            return;
        }
        boolean wasConfigServer = this.isConfigServer;
        this.isConfigServer = this.netCfg.getIsConfigServer();
        this.useExtendedNat = this.netCfg.getUseExtendedNat();
        if (this.isConfigServer && !wasConfigServer) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("cs enabled");
            }
            try {
                this.start();
            }
            catch (Throwable e) {
                this.lonworks.configFail(e.toString());
            }
        } else if (!this.isConfigServer && wasConfigServer) {
            this.stop();
        }
    }

    public void addMember(BChannelMember cm) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs add member " + cm.getCnName());
        }
        this.updateListTime(true);
        if (this.netCfg.isLocal(cm)) {
            cm.storeLocalConfiguration(this.netCfg, this.lonworks);
            cm.setIState(BMemberStateEnum.UpToDate);
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("cs new member " + cm.getCnName() + ": send DEVICE_CONFIGURATION_REQUEST ");
            }
            RequestMessage rm = new RequestMessage(99);
            this.send(rm, cm.getSegmentIp(this.netCfg).getInetAddress(), cm.getIpUcPort(), cm.getSequence());
        }
    }

    public void removeMember(BChannelMember cm) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs remove member " + cm.getCnName());
        }
        this.updateListTime(true);
    }

    public void updateMember(BChannelMember cm, boolean changeSL) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs update member " + cm.getCnName());
        }
        this.updateListTime(changeSL);
    }

    public void routeChanged(BChannelMember cm) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs routeChanged on " + cm.getCnName());
        }
        this.updateListTime(false);
    }

    public void doUpdateMember(BChannelMember cm) {
        if (!this.isConfigServer || !this.enabled) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs doUpdate member " + cm.getCnName());
        }
        BDateTime nt = BDateTime.make();
        if (cm.getConfigTimeStamp().isLaterThan(nt)) {
            nt = BDateTime.make(cm.getConfigTimeStamp().getSeconds() + 1L);
        }
        cm.setConfigTimeStamp(nt);
        cm.setIState(BMemberStateEnum.SentDR);
        this.sendDeviceConfig(cm);
    }

    private void updateLocal() {
        BChannelMember cm = this.ipChan.getLocalMember();
        if (cm == null) {
            cm = new BChannelMember();
            cm.storeLocalConfiguration(this.netCfg, this.lonworks);
            cm.setIState(BMemberStateEnum.UpToDate);
            this.memTab.addMember(cm, BMemberTable.internalChange);
        }
        if (cm.getIState() != BMemberStateEnum.UpToDate) {
            cm.storeLocalConfiguration(this.netCfg, this.lonworks);
            cm.setIState(BMemberStateEnum.UpToDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configDevices() {
        BChannelMember[] a = this.memTab.getChannelMembers();
        for (int i = 0; i < a.length; ++i) {
            BChannelMember cm = a[i];
            if (this.netCfg.isLocal(cm)) continue;
            BChannelMember bChannelMember = cm;
            synchronized (bChannelMember) {
                cm.setIState(BMemberStateEnum.SentDRReq);
            }
            this.sendDeviceConfigReq(cm);
            NmUtil.wait((int)50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevices() {
        BChannelMember[] a = this.memTab.getChannelMembers();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs updateDevices");
        }
        for (int i = 0; i < a.length; ++i) {
            BChannelMember cm = a[i];
            if (this.netCfg.isLocal(cm)) continue;
            BChannelMember bChannelMember = cm;
            synchronized (bChannelMember) {
                cm.setIState(BMemberStateEnum.SentDR);
            }
            this.sendDeviceConfig(cm);
            NmUtil.wait((int)50);
        }
        ConfigServer configServer = this;
        synchronized (configServer) {
            this.newTime = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDevices() {
        BChannelMember[] a = this.memTab.getChannelMembers();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.fine(".");
        }
        block8: for (int i = 0; i < a.length; ++i) {
            BMemberStateEnum istate;
            BChannelMember cm = a[i];
            if (this.netCfg.isLocal(cm)) continue;
            BChannelMember bChannelMember = cm;
            synchronized (bChannelMember) {
                istate = cm.getIState();
            }
            switch (istate.getOrdinal()) {
                case 0: 
                case 1: {
                    this.sendDeviceConfigReq(cm);
                    NmUtil.wait((int)50);
                    continue block8;
                }
                case 2: {
                    this.sendDeviceConfig(cm);
                    NmUtil.wait((int)50);
                    continue block8;
                }
                case 3: {
                    this.sendChannelRouteReq(cm);
                    NmUtil.wait((int)50);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcvDeviceRegistration(DeviceRegistration msg) {
        BChannelMember cm = this.findChannelMember(msg);
        if (cm == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvDeviceRegistration from " + cm.getCnName() + "\n" + msg.toString());
        }
        cm.storeDeviceConfiguration(msg);
        BChannelMember bChannelMember = cm;
        synchronized (bChannelMember) {
            cm.setIState(BMemberStateEnum.SentDR);
        }
        DeviceRegistration dr = this.createDeviceRegistration(cm);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send DEVICE_CONFIGURATION to " + cm.getCnName() + "\n" + dr.toString());
        }
        this.sendResponse(dr, msg);
    }

    private DeviceRegistration createDeviceRegistration(BChannelMember cm) {
        DeviceRegistration dr = new DeviceRegistration(113);
        dr.dateTime = cm.getConfigTimeStamp();
        dr.ipFlags = cm.getIpFlags();
        dr.routerType = cm.getRouterType();
        dr.cnFlags = cm.getCnFlags();
        dr.nodeType = cm.getNodeType();
        dr.ucIpPort = cm.getIpUcPort();
        dr.ucIpAdr = cm.getSegmentIp(this.netCfg);
        dr.chanMembershipDt = this.chanMembershipDt;
        dr.sendlistDt = this.sendlistDt;
        dr.configServerIp = this.netCfg.getSegmentConfigServerIp(cm);
        dr.configServerPort = this.udpPort.getLocalPort();
        dr.mcIps = new BIpAddress[0];
        dr.mcPorts = new int[0];
        dr.id = cm.getNeuronId().getByteArray();
        dr.name = cm.getCnName();
        return dr;
    }

    private void sendDeviceConfigReq(BChannelMember cm) {
        if (cm.incrementRetryCount() > 5) {
            cm.error("Device will not respond to DEVICE_CONFIGURATION_REQUEST ");
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send DEVICE_CONFIGURATION_REQUEST to " + cm.getCnName());
        }
        RequestMessage rm = new RequestMessage(99);
        this.send(rm, cm.getSegmentIp(this.netCfg).getInetAddress(), cm.getIpUcPort(), cm.getSequence());
    }

    private void sendDeviceConfig(BChannelMember cm) {
        if (cm.incrementRetryCount() > 5) {
            cm.error("Device will not ack DEVICE_CONFIGURATION ");
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send DEVICE_CONFIGURATION to " + cm.getCnName());
        }
        DeviceRegistration dr = this.createDeviceRegistration(cm);
        this.send(dr, cm.getSegmentIp(this.netCfg).getInetAddress(), cm.getIpUcPort(), cm.getSequence());
    }

    BChannelMember findChannelMember(LonIpMessage msg) {
        return this.memTab.findEntry(BIpAddress.make(msg.getSrcAddress()), msg.getSrcPort());
    }

    BChannelMember findChannelMember(BIpAddress ipAdr, int port) {
        return this.memTab.findEntry(ipAdr, port);
    }

    private void rcvChannelMembershipRequest(RequestMessage req) {
        BChannelMember cm;
        String n = this.getName(req.getSrcAddress(), req.getSrcPort());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvChannelMembershipRequest from " + n);
        }
        if ((cm = this.findChannelMember(req)) == null) {
            this.sendAck(req, 4);
            return;
        }
        ChannelMembership cmMsg = this.createChannelMembership(cm);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send CHANNEL_MEMBERSHIP to " + n + "\n" + cmMsg.toString());
        }
        this.sendResponse(cmMsg, req);
    }

    private ChannelMembership createChannelMembership(BChannelMember cm) {
        ChannelMembership cms = new ChannelMembership();
        cms.dateTime = this.chanMembershipDt;
        cms.sendlistDt = this.sendlistDt;
        BChannelMember[] a = this.memTab.getChannelMembers();
        cms.ips = new BIpAddress[a.length];
        cms.ports = new int[a.length];
        cms.chanRouteTime = new BDateTime[a.length];
        for (int i = 0; i < a.length; ++i) {
            cms.ips[i] = a[i].getSegmentIp(cm);
            cms.ports[i] = a[i].getIpUcPort();
            cms.chanRouteTime[i] = a[i].getRouteTimeStamp();
        }
        return cms;
    }

    private void rcvSendListRequest(RequestMessage req) {
        BChannelMember cm;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvSendListRequest from " + this.getName(req.getSrcAddress(), req.getSrcPort()));
        }
        if ((cm = this.findChannelMember(req)) == null) {
            this.sendAck(req, 4);
            return;
        }
        SendList sl = this.createSendList(cm);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send SEND_LIST\n" + sl.toString());
        }
        this.sendResponse(sl, req);
    }

    private SendList createSendList(BChannelMember cm) {
        SendList sl = new SendList();
        sl.dateTime = this.sendlistDt;
        BChannelMember[] a = this.memTab.getChannelMembers();
        sl.ips = new BIpAddress[a.length];
        sl.ports = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            sl.ips[i] = a[i].getSegmentIp(cm);
            sl.ports[i] = a[i].getIpUcPort();
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcvChannelRouting(ChannelRouting msg) {
        BChannelMember cm = this.findChannelMember(msg.ucIpAdr, msg.ucIpPort);
        if (cm == null) {
            this.log.warning("cs received ChannelRouting msg for unknown ip " + (Object)((Object)msg.ucIpAdr));
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvChannelRouting from " + cm.getCnName() + "\n" + msg);
        }
        if (cm.storeChannelRoute(msg, this.log)) {
            this.routeChanged(cm);
        }
        boolean sendAck = true;
        BChannelMember bChannelMember = cm;
        synchronized (bChannelMember) {
            if (cm.getIState() == BMemberStateEnum.SentCRReq) {
                sendAck = false;
            }
            cm.setIState(BMemberStateEnum.UpToDate);
        }
        if (sendAck) {
            this.sendAck(msg, 0);
        }
    }

    private void rcvChannelRoutingRequest(RequestMessage req) {
        BIpAddress ipAddress = req.ipAddress;
        int ipPort = req.ipUcPort;
        BChannelMember clientCm = this.findChannelMember(req);
        if (clientCm == null) {
            this.sendAck(req, 4);
            return;
        }
        if (ipAddress.equals((Object)BIpAddress.DEFAULT)) {
            this.sendAck(req, 5);
            return;
        }
        BChannelMember cm = this.memTab.findSegmentMember(ipAddress, ipPort, clientCm);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvChannelRoutingRequest for " + cm.getCnName() + " from " + clientCm.getCnName());
        }
        ChannelRouting cr = this.createChannelRouting(cm, clientCm);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send CHANNEL_ROUTING to " + clientCm.getCnName() + "\n" + cr.toString());
        }
        this.sendResponse(cr, req);
    }

    private ChannelRouting createChannelRouting(BChannelMember cm, BChannelMember clientCm) {
        ChannelRouting cr = new ChannelRouting();
        cr.dateTime = cm.getRouteTimeStamp();
        cr.ucIpPort = cm.getIpUcPort();
        cr.ucIpAdr = cm.getSegmentIp(clientCm);
        cr.nids = new BNeuronId[]{cm.getNeuronId()};
        cr.ipFlags = cm.getIpFlags();
        cr.routerType = cm.getRouterType();
        cr.cnFlags = cm.getCnFlags();
        cr.nodeType = cm.getNodeType();
        ChannelRouting.SubnetNodeRecord snr = new ChannelRouting.SubnetNodeRecord();
        snr.sn = cm.getSubnetNode();
        snr.domainNdx = 0;
        snr.nidNdx = 0;
        cr.snRec = new ChannelRouting.SubnetNodeRecord[]{snr};
        ChannelRouting.DomainRecord dmr = new ChannelRouting.DomainRecord();
        dmr.domainId = this.lonworks.getLonNetmgmt().getDomainId();
        dmr.subnetMask = cm.getSubnetMask().getByteArrayCopy();
        dmr.groupMask = cm.getGroupMask().getByteArrayCopy();
        cr.domRec = new ChannelRouting.DomainRecord[]{dmr};
        return cr;
    }

    private void sendChannelRouteReq(BChannelMember cm) {
        if (cm.incrementRetryCount() > 5) {
            cm.error("Device will not respond to CHANNEL_ROUTING_REQUEST ");
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs send CHANNEL_ROUTING_REQUEST to " + cm.getCnName());
        }
        RequestMessage rm = new RequestMessage(104);
        rm.ipAddress = cm.getSegmentIp(this.netCfg);
        this.send(rm, cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcvAcknowledge(Acknowledge msg) {
        BChannelMember cm = this.findChannelMember(msg);
        if (cm == null) {
            return;
        }
        boolean sendCRReq = false;
        BChannelMember bChannelMember = cm;
        synchronized (bChannelMember) {
            if (cm.getIState() == BMemberStateEnum.SentDR) {
                cm.setIState(BMemberStateEnum.SentCRReq);
                sendCRReq = true;
            }
        }
        if (sendCRReq) {
            this.sendChannelRouteReq(cm);
        }
    }

    private void sendAck(LonIpMessage msg, int ackType) {
        Acknowledge ack = new Acknowledge();
        ack.dateTime = BDateTime.make();
        ack.ackType = ackType;
        if (msg instanceof RequestMessage) {
            ack.requestId = ((RequestMessage)msg).requestId;
        }
        this.send(ack, msg.getSrcAddress(), msg.getSrcPort(), msg.sequenceNumber);
    }

    private void rcvStatusRequest(RequestMessage req) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("cs rcvStatusRequest : " + this.getName(req.getSrcAddress(), req.getSrcPort()));
        }
        this.stats.updateGlobalStats(this.ipChan);
        StatisticsResp sr = new StatisticsResp(this.stats);
        if (req.clear) {
            this.stats = new Statistics();
        }
        this.sendResponse(sr, req);
    }

    private void sendResponse(LonIpMessage rspMsg, LonIpMessage origMsg) {
        this.send(rspMsg, origMsg.getSrcAddress(), origMsg.getSrcPort(), origMsg.sequenceNumber);
    }

    private void send(LonIpMessage msg, BChannelMember cm) {
        this.send(msg, cm.getSegmentIp(this.netCfg).getInetAddress(), cm.getIpUcPort(), cm.getSequence());
    }

    private void send(LonIpMessage msg, InetAddress ip, int port, int seq) {
        if (this.useExtendedNat) {
            msg.addExtendedNat(this.netCfg, true);
        }
        msg.sequenceNumber = seq;
        byte[] a = msg.toNetworkBytes();
        if (this.log.isLoggable(Level.FINE)) {
            System.out.println();
            this.link.writeLinkDebug("CS Send " + ip + ":" + port + ":", a, a.length);
        }
        DatagramPacket packOut = new DatagramPacket(a, a.length, ip, port);
        try {
            this.udpPort.send(packOut);
            this.stats.sentMsg(msg, ip, a.length);
        }
        catch (Exception e) {
            this.log.warning("Can not send to " + ip + ":" + port);
        }
    }

    private String getName(InetAddress in, int port) {
        BChannelMember cm = this.findChannelMember(BIpAddress.make(in), port);
        return cm != null ? cm.getCnName() : in.toString();
    }

    private class ConfigService
    implements Runnable {
        private ConfigService() {
        }

        @Override
        public void run() {
            ConfigServer.this.updateLocal();
            ConfigServer.this.configDevices();
            while (ConfigServer.this.enabled) {
                if (ConfigServer.this.newTime) {
                    ConfigServer.this.updateDevices();
                } else {
                    ConfigServer.this.scanDevices();
                }
                NmUtil.wait((int)1000);
            }
        }
    }
}

