/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.datatypes;

import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BDateTime
extends BSimple {
    public static final BDateTime DEFAULT = new BDateTime(new byte[]{0, 0, 0, 0});
    public static final Type TYPE = Sys.loadType(BDateTime.class);
    private static final int DATE_TIME_LENGTH = 4;
    public static final long SECONDS_NTP_TO_UTC = 2208988800L;
    private byte[] timeStamp = new byte[4];
    private BAbsTime absTime = null;
    public static final BFacets DisplayFacets = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showTimeZone", (BIDataValue)BBoolean.TRUE);

    public Type getType() {
        return TYPE;
    }

    public static BDateTime make() {
        long time = System.currentTimeMillis() / 1000L + 2208988800L;
        return BDateTime.make(time);
    }

    public static BDateTime make(long time) {
        byte[] dt = new byte[4];
        dt[3] = (byte)(time & 0xFFL);
        dt[2] = (byte)(time >> 8 & 0xFFL);
        dt[1] = (byte)(time >> 16 & 0xFFL);
        dt[0] = (byte)(time >> 24 & 0xFFL);
        return new BDateTime(dt);
    }

    public static BDateTime make(BAbsTime abs) {
        long m = abs.getMillis() / 1000L;
        if (m == 0L) {
            return DEFAULT;
        }
        BDateTime dt = BDateTime.make(m += 2208988800L);
        dt.absTime = abs;
        return dt;
    }

    public static BDateTime make(byte[] t) {
        return new BDateTime(t);
    }

    private BDateTime(byte[] t) {
        this.timeStamp = t;
    }

    public byte[] getByteArray() {
        return this.timeStamp;
    }

    public long getSeconds() {
        long t = this.timeStamp[3] & 0xFF | (this.timeStamp[2] & 0xFF) << 8 | (this.timeStamp[1] & 0xFF) << 16 | (this.timeStamp[0] & 0xFF) << 24;
        return t & 0xFFFFFFFFL;
    }

    public long getMillis() {
        return this.getSeconds() * 1000L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BDateTime)) {
            return false;
        }
        BDateTime comp = (BDateTime)((Object)obj);
        for (int i = 0; i < comp.timeStamp.length; ++i) {
            if (this.timeStamp[i] == comp.timeStamp[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isLaterThan(BDateTime comp) {
        return this.getSeconds() > comp.getSeconds();
    }

    public String toString(Context context) {
        return this.getAbsTime().toString((Context)DisplayFacets);
    }

    public BAbsTime getAbsTime() {
        if (this.absTime == null) {
            long m = this.getSeconds();
            m = m > 2208988800L ? m - 2208988800L : 0L;
            this.absTime = BAbsTime.make((long)(m * 1000L));
        }
        return this.absTime;
    }

    public void encode(DataOutput out) throws IOException {
        out.write(this.timeStamp);
    }

    public BObject decode(DataInput in) throws IOException {
        byte[] dt = new byte[4];
        in.readFully(dt, 0, 4);
        return new BDateTime(dt);
    }

    public String encodeToString() {
        return LonByteArrayUtil.toString((byte[])this.timeStamp);
    }

    public BObject decodeFromString(String s) throws IOException {
        return new BDateTime(LonByteArrayUtil.getBytes((String)s, (int)4));
    }

    public static BDateTime fromInputStream(LonInputStream in) throws LonException {
        byte[] dt = in.readByteArray(4);
        return new BDateTime(dt);
    }

    public void toOutputStream(LonOutputStream out) {
        out.writeByteArray(this.timeStamp);
    }

    public static void main(String[] args) {
        BDateTime.test(new byte[]{-51, -58, -40, -103});
        BDateTime.test(new byte[]{-51, -63, 68, -58});
    }

    private static void test(byte[] a) {
        BDateTime dt = BDateTime.make(a);
        System.out.println(LonByteArrayUtil.toString((byte[])a) + "  " + (Object)((Object)dt));
    }
}

