/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.link;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.messages.LonIpMessage;
import java.net.InetAddress;

public class LonIpAddress {
    public InetAddress inetAdr;
    public int port;
    public LonIpAddress next = null;
    public BChannelMember chanMem;

    public LonIpAddress() {
    }

    public LonIpAddress(BChannelMember mem, BIpLonNetworkConfig netCfg) {
        this.inetAdr = mem.getSegmentIp(netCfg).getInetAddress();
        this.port = mem.getIpUcPort();
        this.chanMem = mem;
    }

    public LonIpAddress copy() {
        LonIpAddress l = new LonIpAddress();
        l.inetAdr = this.inetAdr;
        l.port = this.port;
        l.chanMem = this.chanMem;
        return l;
    }

    public LonIpAddress copy(LonIpAddress repeats) {
        LonIpAddress l = new LonIpAddress();
        l.inetAdr = this.inetAdr;
        l.port = this.port;
        l.chanMem = this.chanMem;
        l.copyToNext(repeats);
        return l;
    }

    public void copyToNext(LonIpAddress repeats) {
        LonIpAddress rpts = repeats;
        LonIpAddress nxt = this;
        while (rpts != null) {
            LonIpAddress chk = this;
            boolean dup = false;
            while (chk != null) {
                if (chk.inetAdr.equals(rpts.inetAdr) && chk.port == rpts.port) {
                    dup = true;
                    break;
                }
                chk = chk.next;
            }
            if (dup) {
                rpts = rpts.next;
                continue;
            }
            nxt.next = rpts.copy();
            rpts = rpts.next;
            nxt = nxt.next;
        }
    }

    public static LonIpAddress make(LonIpMessage msg) {
        LonIpAddress l = new LonIpAddress();
        l.inetAdr = msg.getSrcAddress();
        l.port = msg.getSrcPort();
        return l;
    }

    public static LonIpAddress make(InetAddress inetAdr, int port) {
        LonIpAddress l = new LonIpAddress();
        l.inetAdr = inetAdr;
        l.port = port;
        return l;
    }

    public String toString() {
        return this.inetAdr + ":" + this.port;
    }

    public int getSequence() {
        if (this.chanMem == null) {
            return 0;
        }
        return this.chanMem.getSequenceAndIncrement();
    }
}

