/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class ChannelMembership
extends LonIpMessage {
    public BDateTime dateTime = BDateTime.DEFAULT;
    public BDateTime sendlistDt = BDateTime.DEFAULT;
    public BIpAddress[] ips;
    public int[] ports;
    public BDateTime[] chanRouteTime;

    public ChannelMembership() {
        this.packetType = 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dateTime=").append((Object)this.dateTime).append("\n");
        sb.append("sendlistDt=").append((Object)this.sendlistDt).append("\n");
        for (int i = 0; i < this.ips.length; ++i) {
            sb.append((Object)this.ips[i]).append(":").append(this.ports[i]).append("  ").append((Object)this.chanRouteTime[i]).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.dateTime = BDateTime.fromInputStream(in);
        this.sendlistDt = BDateTime.fromInputStream(in);
        in.readSigned32();
        int listSize = in.readUnsigned16();
        in.readUnsigned16();
        this.ips = new BIpAddress[listSize];
        this.ports = new int[listSize];
        this.chanRouteTime = new BDateTime[listSize];
        for (int i = 0; i < listSize; ++i) {
            this.ips[i] = BIpAddress.fromInputStream(in);
            this.ports[i] = in.readUnsigned16();
            in.readUnsigned16();
            this.chanRouteTime[i] = BDateTime.fromInputStream(in);
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        this.dateTime.toOutputStream(out);
        this.sendlistDt.toOutputStream(out);
        out.writeSigned32(0);
        int listSize = this.ips.length;
        out.writeUnsigned16(listSize);
        out.writeUnsigned16(0);
        for (int i = 0; i < listSize; ++i) {
            this.ips[i].toOutputStream(out);
            out.writeUnsigned16(this.ports[i]);
            out.writeUnsigned16(0);
            this.chanRouteTime[i].toOutputStream(out);
        }
    }
}

