/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.datatypes.BIpAddress;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class RequestMessage
extends LonIpMessage {
    public BDateTime dateTime;
    public int reason;
    public int requestAll;
    public boolean clear;
    public int requestId;
    public int segmentId;
    public BDateTime since;
    public BIpAddress ipAddress = BIpAddress.DEFAULT;
    public int ipUcPort = 0;

    public RequestMessage() {
    }

    public RequestMessage(int type) {
        this(type, BDateTime.DEFAULT);
    }

    public RequestMessage(int type, BDateTime s) {
        this.packetType = type;
        this.dateTime = BDateTime.make();
        this.requestId = 1;
        this.reason = 0;
        this.requestAll = 4;
        this.since = s;
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.dateTime = BDateTime.fromInputStream(in);
        int n = in.readUnsigned8();
        this.reason = n & 3;
        this.requestAll = n & 4;
        this.clear = (n & 8) > 0;
        this.requestId = in.readUnsigned16();
        this.segmentId = in.readUnsigned8();
        this.since = BDateTime.fromInputStream(in);
        this.ipAddress = BIpAddress.fromInputStream(in);
        if (in.available() >= 4) {
            in.readUnsigned16();
            this.ipUcPort = in.readUnsigned16();
        }
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        this.dateTime.toOutputStream(out);
        out.writeUnsigned8(this.reason | this.requestAll | (this.clear ? 8 : 0));
        out.writeUnsigned16(this.requestId);
        out.writeUnsigned8(this.segmentId);
        this.since.toOutputStream(out);
        this.ipAddress.toOutputStream(out);
        if (this.ipUcPort > 0) {
            out.writeUnsigned16(0);
            out.writeUnsigned16(this.ipUcPort);
        }
    }
}

