/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.messages;

import com.tridium.lonIp.Statistics;
import com.tridium.lonIp.datatypes.BDateTime;
import com.tridium.lonIp.messages.LonIpMessage;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class StatisticsResp
extends LonIpMessage {
    public Statistics stats;

    public StatisticsResp() {
        this.stats = new Statistics();
        this.packetType = 112;
    }

    public StatisticsResp(Statistics stats) {
        this.stats = stats;
        this.packetType = 112;
    }

    @Override
    public void fromInputStream(LonInputStream in) throws LonException {
        this.stats.TimeSinceCounterReset = this.readStat(in);
        this.stats.TimeOfLastCounterReset = BDateTime.fromInputStream(in);
        this.stats.NumberOfChannelMembers = this.readStat(in);
        this.stats.NumberOfMembersSentTo = this.readStat(in);
        this.stats.LonPacketsRcvdFromLonChan = this.readStat(in);
        this.stats.LonPacketsRcvdAndDiscarded = this.readStat(in);
        this.stats.LonTotalBytesReceived = this.readStat(in);
        this.stats.LonPacktsSentOnLonChan = this.readStat(in);
        this.stats.LonTotalBytesSent = this.readStat(in);
        this.stats.LonPacketsSentToIpChan = this.readStat(in);
        this.stats.LonBytesSentToIpChan = this.readStat(in);
        this.stats.LonPacketsFromIpChan = this.readStat(in);
        this.stats.LonBytesFromIpChan = this.readStat(in);
        this.stats.IPPacketsWithLonToIpChan = this.readStat(in);
        this.stats.IPPacketsWithLonFromIp = this.readStat(in);
        this.stats.AverageAggregateToIpChan = this.readStat(in);
        this.stats.AverageAggregateFromIp = this.readStat(in);
        this.stats.NumOfUDPPacketsSent = this.readStat(in);
        this.stats.NumOfTCPPacketsSent = this.readStat(in);
        this.stats.NumOfMcastPacketsSent = this.readStat(in);
        this.stats.StaleIpDropped = this.readStat(in);
        this.stats.TCPConnectionFailures = this.readStat(in);
        this.stats.TCPHostFailures = this.readStat(in);
        this.stats.RouterConfigMsgSent = this.readStat(in);
        this.stats.RouterConfigMsgRcvd = this.readStat(in);
        this.stats.ConfigurationChanges = this.readStat(in);
        this.stats.AverageUdpPerSecSent = this.readStat(in);
        this.stats.AverageUdpPerSecRcvd = this.readStat(in);
        this.stats.AverageTcpPerSecSent = this.readStat(in);
        this.stats.AverageTcpPerSecRcvd = this.readStat(in);
    }

    @Override
    public void toOutputStream(LonOutputStream out) {
        long totalSecs = BDateTime.make().getSeconds() - this.stats.TimeOfLastCounterReset.getSeconds();
        this.writeStat(out, totalSecs);
        this.stats.TimeOfLastCounterReset.toOutputStream(out);
        this.writeStat(out, this.stats.NumberOfChannelMembers);
        this.writeStat(out, this.stats.NumberOfMembersSentTo);
        this.writeStat(out, this.stats.LonPacketsRcvdFromLonChan);
        this.writeStat(out, this.stats.LonPacketsRcvdAndDiscarded);
        this.writeStat(out, this.stats.LonTotalBytesReceived);
        this.writeStat(out, this.stats.LonPacktsSentOnLonChan);
        this.writeStat(out, this.stats.LonTotalBytesSent);
        this.writeStat(out, this.stats.LonPacketsSentToIpChan);
        this.writeStat(out, this.stats.LonBytesSentToIpChan);
        this.writeStat(out, this.stats.LonPacketsFromIpChan);
        this.writeStat(out, this.stats.LonBytesFromIpChan);
        this.writeStat(out, this.stats.IPPacketsWithLonToIpChan);
        this.writeStat(out, this.stats.IPPacketsWithLonFromIp);
        this.writeStat(out, this.stats.AverageAggregateToIpChan);
        this.writeStat(out, this.stats.AverageAggregateFromIp);
        this.writeStat(out, this.stats.NumOfUDPPacketsSent);
        this.writeStat(out, this.stats.NumOfTCPPacketsSent);
        this.writeStat(out, this.stats.NumOfMcastPacketsSent);
        this.writeStat(out, this.stats.StaleIpDropped);
        this.writeStat(out, this.stats.TCPConnectionFailures);
        this.writeStat(out, this.stats.TCPHostFailures);
        this.writeStat(out, this.stats.RouterConfigMsgSent);
        this.writeStat(out, this.stats.RouterConfigMsgRcvd);
        this.writeStat(out, this.stats.ConfigurationChanges);
        this.writeStat(out, totalSecs > 0L ? this.stats.NumOfUDPPacketsSent / totalSecs : 0L);
        this.writeStat(out, totalSecs > 0L ? this.stats.NumOfUDPPacketsRcvd / totalSecs : 0L);
        this.writeStat(out, this.stats.AverageTcpPerSecSent);
        this.writeStat(out, this.stats.AverageTcpPerSecRcvd);
    }

    long readStat(LonInputStream in) {
        long val = in.readUnsigned32();
        if (val == 0xFFFFFFFFL) {
            val = -1L;
        } else if (val == 0xFFFFFFFEL) {
            val = -2L;
        }
        return val;
    }

    void writeStat(LonOutputStream out, long val) {
        if (val == -1L) {
            out.writeUnsigned32(0xFFFFFFFFL);
        } else if (val > 0xFFFFFFFDL) {
            out.writeUnsigned32(0xFFFFFFFEL);
        } else {
            out.writeUnsigned32(val);
        }
    }
}

