/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonIp.util;

import com.tridium.lonIp.datatypes.BChannelMember;
import com.tridium.lonIp.datatypes.BIpChannel;
import com.tridium.lonIp.datatypes.BIpLonNetworkConfig;
import com.tridium.lonIp.datatypes.BMemberTable;
import com.tridium.lonIp.enums.BIpLonRouterTypeEnum;
import com.tridium.lonIp.link.LonIpAddress;
import com.tridium.lonIp.link.LonIpLinkLayer;
import com.tridium.lonIp.messages.LonIp;
import com.tridium.lonIp.messages.LonIpMessage;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.loncomm.NAppBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;

public class LonIpAddressManager
implements LonIp {
    int state = 0;
    int tag;
    LonAddress sndAdr;
    private static final int WAIT = 0;
    private static final int USED_HASH = 1;
    private static final int USED_BCAST = 2;
    private static final int RCV_RESP = 3;
    LonIpMessage ipMsgHold = null;
    LonIpAddress bcast;
    LonIpAddress repeats;
    Hashtable<LonAddress, LonIpAddress> adrHash;
    boolean staleSend = true;
    private BLonNetwork lonworks;
    private BIpChannel ipChan;
    private BIpLonNetworkConfig netCfg;
    private BMemberTable memTab;

    public LonIpAddressManager(BLonNetwork lonworks, LonIpLinkLayer link) {
        this.lonworks = lonworks;
        this.ipChan = (BIpChannel)lonworks.get("ipChannel");
        this.netCfg = this.ipChan.getNetworkConfig();
        this.memTab = this.ipChan.getMemberTable();
        ((BIpChannel)lonworks.get("ipChannel")).registerAddressManager(this);
    }

    public synchronized void receivedResponseMessage(LonIpMessage ipMsg, int tag) {
        if (this.state == 2 && this.tag == tag) {
            BChannelMember cm = this.memTab.findEntry(ipMsg.getSrcAddress(), ipMsg.getSrcPort());
            LonIpAddress adr = new LonIpAddress(cm, this.netCfg);
            adr.copyToNext(this.repeats);
            this.adrHash.put(this.sndAdr, adr);
        }
        if (this.tag == tag && this.ipMsgHold != null) {
            this.ipMsgHold.responseReceived();
            this.ipMsgHold = null;
        }
        this.state = 3;
    }

    public synchronized void getSendList(LonIpMessage ipMsg, NAppBuffer appBuf) {
        if (this.staleSend) {
            this.updateSendLists();
        }
        if (this.state == 1) {
            this.adrHash.remove(this.sndAdr);
        }
        LonAddress adr = appBuf.getDestAddress();
        switch (adr.getAddressType()) {
            case 0: 
            case 3: 
            case 126: {
                this.state = 0;
                ipMsg.sendList = this.bcast;
                return;
            }
        }
        this.tag = appBuf.getTag();
        boolean expectReply = false;
        if (!appBuf.isResp()) {
            BLonRepeatTimer tmr = null;
            switch (appBuf.getServiceType().getOrdinal()) {
                case 0: {
                    expectReply = true;
                    tmr = appBuf.getTransmitTimer();
                    break;
                }
                case 3: {
                    expectReply = true;
                    tmr = appBuf.getTransmitTimer();
                    break;
                }
                case 1: {
                    tmr = appBuf.getRepeatTimer();
                }
            }
            if (tmr != null) {
                ipMsg.retries = appBuf.getRetryCount();
                ipMsg.repeatTime = tmr.getTime();
            }
        }
        LonIpAddress ip = this.adrHash.get(adr);
        this.sndAdr = adr;
        if (ip != null) {
            this.state = expectReply ? 1 : 0;
            ipMsg.sendList = ip;
        } else {
            this.state = 2;
            ipMsg.sendList = this.bcast;
        }
        if (expectReply) {
            this.ipMsgHold = ipMsg;
        }
    }

    public void memberChanged(Context cx) {
        this.staleSend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSendLists() {
        int i;
        BChannelMember[] mems = this.memTab.getChannelMembers();
        int maxSubnet = 1;
        int maxGroup = 0;
        LonIpAddress list = null;
        LonIpAddress rptList = null;
        Hashtable<Object, LonIpAddress> hash = new Hashtable<Object, LonIpAddress>(64);
        for (i = 0; i < mems.length; ++i) {
            BIpLonRouterTypeEnum t = mems[i].getRouterType();
            if (t != BIpLonRouterTypeEnum.Bridge && t != BIpLonRouterTypeEnum.Repeater) continue;
            LonIpAddress ip = new LonIpAddress(mems[i], this.netCfg);
            ip.next = rptList;
            rptList = ip;
        }
        for (i = 0; i < mems.length; ++i) {
            if (this.netCfg.isLocal(mems[i])) continue;
            maxSubnet = this.findMax(mems[i].getSubnetMask(), maxSubnet);
            maxGroup = this.findMax(mems[i].getGroupMask(), maxGroup);
            LonIpAddress ip = new LonIpAddress(mems[i], this.netCfg);
            ip.next = list;
            list = ip;
            hash.put(mems[i].getSubnetNode(), ip.copy(rptList));
            hash.put(mems[i].getNeuronId(), ip.copy(rptList));
        }
        LonIpAddressManager lonIpAddressManager = this;
        synchronized (lonIpAddressManager) {
            this.bcast = list;
            this.staleSend = false;
            this.adrHash = hash;
            this.repeats = rptList;
        }
    }

    private int findMax(BLonRouteTable rt, int max) {
        for (int i = max; i < 255; ++i) {
            if (rt.getFlag(i)) continue;
            max = i;
        }
        return max;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"sendlist", 1);
        out.prop((Object)"bcast", (Object)this.ipToString(this.bcast));
        out.prop((Object)"repeats", (Object)this.ipToString(this.repeats));
        out.endProps();
        out.startProps();
        out.trTitle((Object)"adrHash", 1);
        if (this.adrHash == null) {
            this.updateSendLists();
        }
        Enumeration<LonAddress> e = this.adrHash.keys();
        while (e.hasMoreElements()) {
            LonAddress adr = e.nextElement();
            LonIpAddress ipAdr = this.adrHash.get(adr);
            out.prop((Object)adr, (Object)this.ipToString(ipAdr));
        }
        out.endProps();
    }

    private String ipToString(LonIpAddress ip) {
        StringBuilder sb = new StringBuilder();
        while (ip != null) {
            sb.append(ip).append(", ");
            ip = ip.next;
        }
        return sb.toString();
    }
}

