/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.core;

import com.amazonaws.services.iot.client.AWSIotConnectionStatus;
import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.core.AbstractAwsIotClient;
import com.amazonaws.services.iot.client.core.AwsIotConnectionCallback;
import com.amazonaws.services.iot.client.core.AwsIotMessageCallback;
import com.amazonaws.services.iot.client.core.AwsIotRetryableException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AwsIotConnection
implements AwsIotConnectionCallback {
    private static final Logger LOGGER = Logger.getLogger(AwsIotConnection.class.getName());
    protected AbstractAwsIotClient client;
    protected AWSIotConnectionStatus connectionStatus = AWSIotConnectionStatus.DISCONNECTED;
    private Future<?> retryTask;
    private int retryTimes;
    private AwsIotMessageCallback connectCallback;
    private boolean userDisconnect;
    private ConcurrentLinkedQueue<AWSIotMessage> publishQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AWSIotMessage> subscribeQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AWSIotMessage> unsubscribeQueue = new ConcurrentLinkedQueue();

    public AwsIotConnection(AbstractAwsIotClient client) {
        this.client = client;
    }

    protected abstract void openConnection(AwsIotMessageCallback var1) throws AWSIotException;

    protected abstract void closeConnection(AwsIotMessageCallback var1) throws AWSIotException;

    protected abstract void publishMessage(AWSIotMessage var1) throws AWSIotException, AwsIotRetryableException;

    protected abstract void subscribeTopic(AWSIotMessage var1) throws AWSIotException, AwsIotRetryableException;

    protected abstract void unsubscribeTopic(AWSIotMessage var1) throws AWSIotException, AwsIotRetryableException;

    public void publish(AWSIotMessage message) throws AWSIotException {
        try {
            this.publishMessage(message);
        }
        catch (AwsIotRetryableException e) {
            if (this.client.getMaxOfflineQueueSize() > 0 && this.publishQueue.size() < this.client.getMaxOfflineQueueSize()) {
                this.publishQueue.add(message);
            }
            LOGGER.info("Failed to publish message to " + message.getTopic());
            throw new AWSIotException(e);
        }
    }

    public void updateCredentials(String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
    }

    public void subscribe(AWSIotMessage message) throws AWSIotException {
        try {
            this.subscribeTopic(message);
        }
        catch (AwsIotRetryableException e) {
            if (this.client.getMaxOfflineQueueSize() > 0 && this.subscribeQueue.size() < this.client.getMaxOfflineQueueSize()) {
                this.subscribeQueue.add(message);
            }
            LOGGER.info("Failed to subscribe to " + message.getTopic());
            throw new AWSIotException(e);
        }
    }

    public void unsubscribe(AWSIotMessage message) throws AWSIotException {
        try {
            this.unsubscribeTopic(message);
        }
        catch (AwsIotRetryableException e) {
            if (this.client.getMaxOfflineQueueSize() > 0 && this.unsubscribeQueue.size() < this.client.getMaxOfflineQueueSize()) {
                this.unsubscribeQueue.add(message);
            }
            LOGGER.info("Failed to unsubscribe to " + message.getTopic());
            throw new AWSIotException(e);
        }
    }

    public void connect(AwsIotMessageCallback callback) throws AWSIotException {
        this.cancelRetry();
        this.retryTimes = 0;
        this.userDisconnect = false;
        this.connectCallback = callback;
        this.openConnection(null);
    }

    public void disconnect(AwsIotMessageCallback callback) throws AWSIotException {
        this.cancelRetry();
        this.retryTimes = 0;
        this.userDisconnect = true;
        this.connectCallback = null;
        this.closeConnection(callback);
    }

    @Override
    public void onConnectionSuccess() {
        LOGGER.info("Connection successfully established");
        this.connectionStatus = AWSIotConnectionStatus.CONNECTED;
        this.retryTimes = 0;
        this.cancelRetry();
        try {
            AWSIotMessage message;
            while (this.subscribeQueue.size() > 0) {
                message = this.subscribeQueue.poll();
                this.subscribeTopic(message);
            }
            while (this.unsubscribeQueue.size() > 0) {
                message = this.unsubscribeQueue.poll();
                this.unsubscribeTopic(message);
            }
            while (this.publishQueue.size() > 0) {
                message = this.publishQueue.poll();
                this.publishMessage(message);
            }
        }
        catch (AWSIotException | AwsIotRetryableException e) {
            LOGGER.log(Level.WARNING, "Failed to send queued messages, will disconnect", e);
            try {
                this.closeConnection(null);
            }
            catch (AWSIotException ie) {
                LOGGER.log(Level.WARNING, "Failed to disconnect", ie);
            }
        }
        this.client.onConnectionSuccess();
        if (this.connectCallback != null) {
            this.connectCallback.onSuccess();
            this.connectCallback = null;
        }
    }

    @Override
    public void onConnectionFailure() {
        LOGGER.info("Connection temporarily lost");
        this.connectionStatus = AWSIotConnectionStatus.DISCONNECTED;
        this.cancelRetry();
        if (this.shouldRetry()) {
            this.retryConnection();
            this.client.onConnectionFailure();
        } else {
            LOGGER.info("Connection retry cancelled or exceeded maximum retries");
            if (this.connectCallback != null) {
                this.connectCallback.onFailure();
                this.connectCallback = null;
            }
            this.client.onConnectionClosed();
        }
    }

    @Override
    public void onConnectionClosed() {
        LOGGER.info("Connection permanently closed");
        this.connectionStatus = AWSIotConnectionStatus.DISCONNECTED;
        this.cancelRetry();
        if (this.connectCallback != null) {
            this.connectCallback.onFailure();
            this.connectCallback = null;
        }
        this.client.onConnectionClosed();
    }

    private boolean shouldRetry() {
        return !this.userDisconnect && this.client.getMaxConnectionRetries() > 0 && this.retryTimes < this.client.getMaxConnectionRetries();
    }

    private void cancelRetry() {
        if (this.retryTask != null) {
            this.retryTask.cancel(false);
            this.retryTask = null;
        }
    }

    long getRetryDelay() {
        double delay = Math.pow(2.0, this.retryTimes) * (double)this.client.getBaseRetryDelay();
        delay = Math.min(delay, (double)this.client.getMaxRetryDelay());
        delay = Math.max(delay, 0.0);
        return (long)delay;
    }

    private void retryConnection() {
        if (this.retryTask != null) {
            LOGGER.warning("Connection retry already in progress");
            return;
        }
        this.retryTask = this.client.scheduleTimeoutTask(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("Connection is being retried");
                AwsIotConnection.this.connectionStatus = AWSIotConnectionStatus.RECONNECTING;
                AwsIotConnection.this.retryTimes++;
                try {
                    AwsIotConnection.this.openConnection(null);
                }
                catch (AWSIotException e) {
                    AwsIotConnection.this.client.onConnectionClosed();
                }
            }
        }, this.getRetryDelay());
    }

    public AbstractAwsIotClient getClient() {
        return this.client;
    }

    public AWSIotConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(AWSIotConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public Future<?> getRetryTask() {
        return this.retryTask;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public AwsIotMessageCallback getConnectCallback() {
        return this.connectCallback;
    }

    public boolean isUserDisconnect() {
        return this.userDisconnect;
    }

    public ConcurrentLinkedQueue<AWSIotMessage> getPublishQueue() {
        return this.publishQueue;
    }

    public ConcurrentLinkedQueue<AWSIotMessage> getSubscribeQueue() {
        return this.subscribeQueue;
    }

    public ConcurrentLinkedQueue<AWSIotMessage> getUnsubscribeQueue() {
        return this.unsubscribeQueue;
    }
}

