/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

public class AwsIotJsonDeserializer {
    public static void deserialize(AbstractAwsIotDevice device, String jsonState) throws IOException {
        ObjectMapper jsonObjectMapper = device.getJsonObjectMapper();
        JsonNode node = jsonObjectMapper.readTree(jsonState);
        if (node == null) {
            throw new IOException("Invalid delta update received for " + device.getThingName());
        }
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            String property = it.next();
            Field field = device.getUpdatableProperties().get(property);
            JsonNode fieldNode = node.get(property);
            if (field == null || fieldNode == null) continue;
            AwsIotJsonDeserializer.updateDeviceProperty(jsonObjectMapper, fieldNode, device, field);
        }
    }

    public static long deserializeVersion(AbstractAwsIotDevice device, String jsonState) throws IOException {
        ObjectMapper jsonObjectMapper = device.getJsonObjectMapper();
        JsonNode node = jsonObjectMapper.readTree(jsonState);
        if (node == null) {
            throw new IOException("Invalid shadow document received for " + device.getThingName());
        }
        JsonNode versionNode = node.get("version");
        if (versionNode == null) {
            throw new IOException("Missing version field from shadow document for " + device.getThingName());
        }
        return versionNode.asLong();
    }

    private static void updateDeviceProperty(ObjectMapper jsonObjectMapper, JsonNode node, AbstractAwsIotDevice device, Field field) throws IOException {
        Object value = jsonObjectMapper.treeToValue((TreeNode)node, field.getType());
        AwsIotJsonDeserializer.invokeSetterMethod(device, field.getName(), field.getType(), value);
    }

    private static void invokeSetterMethod(Object target, String name, Class<?> type, Object value) throws IOException {
        Method method;
        String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            method = target.getClass().getMethod(setter, type);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            method.invoke(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

