/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.util;

import com.amazonaws.services.iot.client.AWSIotException;
import com.amazonaws.services.iot.client.auth.Credentials;
import com.amazonaws.services.iot.client.auth.CredentialsProvider;
import com.amazonaws.services.iot.client.auth.StaticCredentialsProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AwsIotWebSocketUrlSigner {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String KEY_PREFIX = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String TIME_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String UTF8 = "UTF-8";
    private static final String METHOD = "GET";
    private static final String CANONICAL_URI = "/mqtt";
    private static final Pattern EndpointPattern = Pattern.compile("iot\\.([\\w-]+)\\.amazonaws\\..*");
    private static final String ServiceName = "iotdata";
    private static final String REGION_TO_BE_DETERMINED = "";
    private String endpoint;
    private String regionName;
    private CredentialsProvider credentialsProvider;

    public AwsIotWebSocketUrlSigner(String endpoint) {
        this(endpoint, REGION_TO_BE_DETERMINED);
    }

    public AwsIotWebSocketUrlSigner(String endpoint, String region) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Invalid endpoint provided");
        }
        this.endpoint = endpoint.trim().toLowerCase();
        if (region == null) {
            throw new IllegalArgumentException("Invalid region provided");
        }
        if (region.equals(REGION_TO_BE_DETERMINED)) {
            this.regionName = this.getRegionFromEndpoint(this.endpoint);
            if (this.regionName == null) {
                throw new IllegalArgumentException("Could not extract region from endpoint provided");
            }
        } else {
            this.regionName = region;
        }
    }

    public AwsIotWebSocketUrlSigner(String endpoint, CredentialsProvider provider, String region) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Invalid endpoint provided");
        }
        this.endpoint = endpoint.trim().toLowerCase();
        if (region == null) {
            throw new IllegalArgumentException("Invalid region provided");
        }
        if (region.equals(REGION_TO_BE_DETERMINED)) {
            this.regionName = this.getRegionFromEndpoint(this.endpoint);
            if (this.regionName == null) {
                throw new IllegalArgumentException("Could not extract region from endpoint provided");
            }
        } else {
            this.regionName = region;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Invalid credentials provider");
        }
        this.credentialsProvider = provider;
    }

    public AwsIotWebSocketUrlSigner(String endpoint, String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
        this(endpoint);
        this.updateCredentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
    }

    public AwsIotWebSocketUrlSigner(String endpoint, String awsAccessKeyId, String awsSecretAccessKey, String sessionToken, String region) {
        this(endpoint, region);
        this.updateCredentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCredentialsProvider(CredentialsProvider provider) {
        AwsIotWebSocketUrlSigner awsIotWebSocketUrlSigner = this;
        synchronized (awsIotWebSocketUrlSigner) {
            this.credentialsProvider = provider;
        }
    }

    public void updateCredentials(String awsAccessKeyId, String awsSecretAccessKey, String sessionToken) {
        if (awsAccessKeyId == null || awsSecretAccessKey == null) {
            throw new IllegalArgumentException("Missing required data for signing");
        }
        Credentials credentials = new Credentials(awsAccessKeyId, awsSecretAccessKey, sessionToken);
        StaticCredentialsProvider provider = new StaticCredentialsProvider(credentials);
        this.updateCredentialsProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSignedUrl(Date signingDate) throws AWSIotException {
        CredentialsProvider provider = null;
        AwsIotWebSocketUrlSigner awsIotWebSocketUrlSigner = this;
        synchronized (awsIotWebSocketUrlSigner) {
            provider = this.credentialsProvider;
        }
        if (provider == null) {
            throw new AWSIotException("No credentials provider available for signing");
        }
        Credentials credentials = provider.getCredentials();
        if (credentials == null) {
            throw new AWSIotException("Could not source AWS credentials from provider");
        }
        String awsAccessKeyId = credentials.getAccessKeyId();
        Date dateToUse = signingDate;
        if (dateToUse == null) {
            dateToUse = new Date();
        }
        String amzDate = this.getAmzDate(dateToUse);
        String dateStamp = this.getDateStamp(dateToUse);
        String credentialScope = dateStamp + "/" + this.regionName + "/" + ServiceName + "/aws4_request";
        StringBuilder canonicalQueryStringBuilder = new StringBuilder();
        canonicalQueryStringBuilder.append("X-Amz-Algorithm=").append(ALGORITHM);
        canonicalQueryStringBuilder.append("&X-Amz-Credential=");
        try {
            canonicalQueryStringBuilder.append(URLEncoder.encode(awsAccessKeyId + "/" + credentialScope, UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new AWSIotException("Error encoding URL when building WebSocket URL");
        }
        canonicalQueryStringBuilder.append("&X-Amz-Date=").append(amzDate);
        canonicalQueryStringBuilder.append("&X-Amz-SignedHeaders=host");
        String canonicalHeaders = "host:" + this.endpoint + "\n";
        String payloadHash = this.stringToHex(this.hash(REGION_TO_BE_DETERMINED));
        String canonicalRequest = "GET\n/mqtt\n" + canonicalQueryStringBuilder.toString() + "\n" + canonicalHeaders + "\nhost\n" + payloadHash;
        String stringToSign = "AWS4-HMAC-SHA256\n" + amzDate + "\n" + credentialScope + "\n" + this.stringToHex(this.hash(canonicalRequest));
        byte[] signingKey = this.getSigningKey(credentials, dateStamp);
        byte[] signatureBytes = this.sign(stringToSign, signingKey);
        String signature = this.stringToHex(signatureBytes);
        canonicalQueryStringBuilder.append("&X-Amz-Signature=");
        canonicalQueryStringBuilder.append(signature);
        String requestUrl = "wss://" + this.endpoint + CANONICAL_URI + "?" + canonicalQueryStringBuilder.toString();
        String sessionToken = credentials.getSessionToken();
        if (sessionToken != null) {
            try {
                requestUrl = requestUrl + "&X-Amz-Security-Token=" + URLEncoder.encode(sessionToken, UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new AWSIotException(e);
            }
        }
        return requestUrl;
    }

    public String getRegion() {
        return this.regionName;
    }

    private String getRegionFromEndpoint(String endpoint) {
        Matcher matcher = EndpointPattern.matcher(endpoint);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String stringToHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i]);
            if (hex.length() == 1) {
                sb.append("0");
            } else if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            sb.append(hex);
        }
        return sb.toString().toLowerCase();
    }

    private byte[] getSigningKey(Credentials credentials, String dateStamp) throws AWSIotException {
        Mac signingSecretMac = null;
        try {
            byte[] signingSecret = (KEY_PREFIX + credentials.getSecretAccessKey()).getBytes(UTF8);
            signingSecretMac = Mac.getInstance(HMAC_ALGORITHM);
            signingSecretMac.init(new SecretKeySpec(signingSecret, HMAC_ALGORITHM));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AWSIotException("Error in initializing signing secret MAC");
        }
        byte[] signingDate = this.sign(dateStamp, signingSecretMac);
        byte[] signingRegion = this.sign(this.regionName, signingDate);
        byte[] signingService = this.sign(ServiceName, signingRegion);
        return this.sign(TERMINATOR, signingService);
    }

    private String getAmzDate(Date date) {
        SimpleDateFormat fomatter = new SimpleDateFormat(TIME_PATTERN);
        fomatter.setTimeZone(TIME_ZONE);
        return fomatter.format(date);
    }

    private String getDateStamp(Date date) {
        SimpleDateFormat fomatter = new SimpleDateFormat(DATE_PATTERN);
        fomatter.setTimeZone(TIME_ZONE);
        return fomatter.format(date);
    }

    private byte[] hash(String text) throws AWSIotException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
            md.update(text.getBytes(UTF8));
            return md.digest();
        }
        catch (Exception e) {
            throw new AWSIotException("Unable to compute hash while signing request: " + e.getMessage());
        }
    }

    private byte[] sign(String stringData, byte[] key) throws AWSIotException {
        try {
            byte[] data = stringData.getBytes(UTF8);
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(new SecretKeySpec(key, HMAC_ALGORITHM));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new AWSIotException("Unable to calculate a request signature: " + e.getMessage());
        }
    }

    private byte[] sign(String stringData, Mac mac) throws AWSIotException {
        try {
            byte[] data = stringData.getBytes(UTF8);
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new AWSIotException("Unable to calculate a request signature: " + e.getMessage());
        }
    }
}

