/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver;

import com.tridium.mqttClientDriver.BAbstractMqttDriverDeviceFolder;
import com.tridium.mqttClientDriver.BAbstractMqttDriverNetwork;
import com.tridium.mqttClientDriver.IBaseMqttDevice;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.MqttClientValidations;
import com.tridium.mqttClientDriver.point.BMqttClientDriverPointDeviceExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.util.BMqttQualityOfService;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.ndriver.BNDevice;
import com.tridium.util.ComponentTreeCursor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="messageForLWT", type="String", defaultValue="", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="cleanSession", type="boolean", defaultValue="false"), @NiagaraProperty(name="enableLWT", type="boolean", defaultValue="false"), @NiagaraProperty(name="topicForLWT", type="String", defaultValue=""), @NiagaraProperty(name="qosForLWT", type="BMqttQualityOfService", defaultValue="BMqttQualityOfService.FireAndForget"), @NiagaraProperty(name="retainedForLWT", type="boolean", defaultValue="true"), @NiagaraProperty(name="keepAlive", type="int", defaultValue="60", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.UNITS", value="BUnit.make(\"seconds\", BDimension.DEFAULT)")}), @NiagaraProperty(name="connectionTimeout", type="int", defaultValue="300"), @NiagaraProperty(name="statusMessage", type="String", defaultValue="Disconnected"), @NiagaraProperty(name="points", type="BMqttClientDriverPointDeviceExt", defaultValue="new BMqttClientDriverPointDeviceExt()"), @NiagaraProperty(name="connectionLostWaitingTime", type="BRelTime", defaultValue="BRelTime.make(DEFAULT_RECONNECT_MILLIES)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1000)")}), @NiagaraProperty(name="sendEnumAs", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"TAG\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"ORDINAL\")")})})
@NiagaraActions(value={@NiagaraAction(name="connect", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="subscribeAll", flags=16), @NiagaraAction(name="unsubscribeAll", flags=16)})
public class BAbstractMqttDevice
extends BNDevice
implements IBaseMqttDevice {
    private static final long DEFAULT_RECONNECT_MILLIES = 30000L;
    @Generated
    public static final Property pollFrequency = BAbstractMqttDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property messageForLWT = BAbstractMqttDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property cleanSession = BAbstractMqttDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property enableLWT = BAbstractMqttDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property topicForLWT = BAbstractMqttDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property qosForLWT = BAbstractMqttDevice.newProperty((int)0, (BValue)BMqttQualityOfService.FireAndForget, null);
    @Generated
    public static final Property retainedForLWT = BAbstractMqttDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property keepAlive = BAbstractMqttDevice.newProperty((int)0, (int)60, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)65535)), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"seconds", (BDimension)BDimension.DEFAULT))));
    @Generated
    public static final Property connectionTimeout = BAbstractMqttDevice.newProperty((int)0, (int)300, null);
    @Generated
    public static final Property statusMessage = BAbstractMqttDevice.newProperty((int)0, (String)"Disconnected", null);
    @Generated
    public static final Property points = BAbstractMqttDevice.newProperty((int)0, (BValue)new BMqttClientDriverPointDeviceExt(), null);
    @Generated
    public static final Property connectionLostWaitingTime = BAbstractMqttDevice.newProperty((int)0, (BValue)BRelTime.make((long)30000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    @Generated
    public static final Property sendEnumAs = BAbstractMqttDevice.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"TAG")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"ORDINAL"))));
    @Generated
    public static final Action connect = BAbstractMqttDevice.newAction((int)16, null);
    @Generated
    public static final Action disconnect = BAbstractMqttDevice.newAction((int)16, null);
    @Generated
    public static final Action subscribeAll = BAbstractMqttDevice.newAction((int)16, null);
    @Generated
    public static final Action unsubscribeAll = BAbstractMqttDevice.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractMqttDevice.class);
    private BAbstractMqttAuthenticator authenticator;
    public static final Lexicon lex = BAbstractMqttDriverNetwork.lex;
    private INiagaraMqttClient nMqttClient;
    private static final Logger logger = Logger.getLogger("abstractMqttDriver.device");
    private int numberToBulkSubscribe = 500;
    private Clock.Ticket retryTicket;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public String getMessageForLWT() {
        return this.getString(messageForLWT);
    }

    @Generated
    public void setMessageForLWT(String v) {
        this.setString(messageForLWT, v, null);
    }

    @Generated
    public boolean getCleanSession() {
        return this.getBoolean(cleanSession);
    }

    @Generated
    public void setCleanSession(boolean v) {
        this.setBoolean(cleanSession, v, null);
    }

    @Generated
    public boolean getEnableLWT() {
        return this.getBoolean(enableLWT);
    }

    @Generated
    public void setEnableLWT(boolean v) {
        this.setBoolean(enableLWT, v, null);
    }

    @Generated
    public String getTopicForLWT() {
        return this.getString(topicForLWT);
    }

    @Generated
    public void setTopicForLWT(String v) {
        this.setString(topicForLWT, v, null);
    }

    @Generated
    public BMqttQualityOfService getQosForLWT() {
        return (BMqttQualityOfService)this.get(qosForLWT);
    }

    @Generated
    public void setQosForLWT(BMqttQualityOfService v) {
        this.set(qosForLWT, (BValue)v, null);
    }

    @Generated
    public boolean getRetainedForLWT() {
        return this.getBoolean(retainedForLWT);
    }

    @Generated
    public void setRetainedForLWT(boolean v) {
        this.setBoolean(retainedForLWT, v, null);
    }

    @Generated
    public int getKeepAlive() {
        return this.getInt(keepAlive);
    }

    @Generated
    public void setKeepAlive(int v) {
        this.setInt(keepAlive, v, null);
    }

    @Generated
    public int getConnectionTimeout() {
        return this.getInt(connectionTimeout);
    }

    @Generated
    public void setConnectionTimeout(int v) {
        this.setInt(connectionTimeout, v, null);
    }

    @Generated
    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    @Generated
    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    @Generated
    public BMqttClientDriverPointDeviceExt getPoints() {
        return (BMqttClientDriverPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BMqttClientDriverPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BRelTime getConnectionLostWaitingTime() {
        return (BRelTime)this.get(connectionLostWaitingTime);
    }

    @Generated
    public void setConnectionLostWaitingTime(BRelTime v) {
        this.set(connectionLostWaitingTime, (BValue)v, null);
    }

    @Generated
    public boolean getSendEnumAs() {
        return this.getBoolean(sendEnumAs);
    }

    @Generated
    public void setSendEnumAs(boolean v) {
        this.setBoolean(sendEnumAs, v, null);
    }

    @Generated
    public void connect() {
        this.invoke(connect, null, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Generated
    public void subscribeAll() {
        this.invoke(subscribeAll, null, null);
    }

    @Generated
    public void unsubscribeAll() {
        this.invoke(unsubscribeAll, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAbstractMqttAuthenticator getAuthenticator(boolean throwError) {
        if (this.authenticator != null) {
            return this.authenticator;
        }
        BValue authenticator = this.get("authenticator");
        if (authenticator == null || !(authenticator instanceof BAbstractMqttAuthenticator)) {
            if (throwError) {
                throw new LocalizableRuntimeException("abstractMqttDriver", lex.getText("authenticatorRequire"));
            }
            return null;
        }
        this.authenticator = (BAbstractMqttAuthenticator)authenticator;
        return this.authenticator;
    }

    public void doConnect() {
        try {
            BAbstractMqttAuthenticator authenticator = this.getAuthenticator(true);
            this.nMqttClient = authenticator.connect(this);
            this.getMqttClientDriverNetwork().addUniqueClientId(authenticator.getClientID());
            this.addMqttClientToChildren();
            String message = lex.get("connected");
            authenticator.enableAndDisableFields(1);
            this.setStatusMessage(message);
            this.pingOk();
            this.modifySubscriptionOfAll((BComponent)this, true, false);
        }
        catch (Exception e) {
            this.pingFail(lex.getText("pingMessageFail", new Object[]{e.getMessage()}));
            this.setStatusMessage(lex.get("disconnected"));
            logger.log(Level.WARNING, e.getMessage(), logger.isLoggable(Level.FINE) ? e : null);
            this.retryTicket = Clock.schedule((BComponent)this, (BRelTime)this.getConnectionLostWaitingTime(), (Action)connect, null);
        }
    }

    public void doDisconnect() {
        if (this.retryTicket != null) {
            this.retryTicket.cancel();
            this.retryTicket = null;
        }
        if (this.getEnabled() && this.getMqttClientDriverNetwork().getEnabled()) {
            this.disconnectClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectClient() {
        BAbstractMqttAuthenticator authenticator = this.getAuthenticator(true);
        authenticator.setCurrentMqttAction(MqttActions.DISCONNECT);
        this.getMqttClientDriverNetwork().removeClientIdFromList(authenticator.getClientID());
        authenticator.enableAndDisableFields(0);
        if (!MqttClientValidations.getMqttClientValidationsInstance().validateDisconnectParams(this, this.nMqttClient)) {
            return;
        }
        try {
            this.modifySubscriptionOfAll((BComponent)this, false, false);
            this.nMqttClient.disconnect();
            String message = lex.get("disconnected");
            this.setStatusMessage(message);
            this.pingFail(message);
        }
        catch (Exception e) {
            String message = e instanceof LocalizableRuntimeException ? e.getMessage() : lex.get("couldNotDisconnect");
            this.setStatusMessage(message);
            this.pingFail(message);
        }
        finally {
            authenticator.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public void doSubscribeAll() {
        this.modifyBulkSubscription((BComponent)this, true);
    }

    @Override
    public void doUnsubscribeAll() {
        this.modifyBulkSubscription((BComponent)this, false);
    }

    public void modifyBulkSubscription(BComponent comp, boolean subscribe) {
        if (!this.isClientConnectedToBroker()) {
            logger.fine(lex.get("clientNotConnected"));
            return;
        }
        try {
            this.modifySubscriptionOfAll(comp, subscribe, true);
        }
        catch (Exception e) {
            logger.fine(e.getLocalizedMessage());
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getMqttClientDriverNetwork().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void changed(Property property, Context context) {
        BAbstractMqttAuthenticator authenticator;
        super.changed(property, context);
        if (property.equals(enabled) && this.isRunning()) {
            if (this.getEnabled() && !this.isClientConnectedToBroker() && this.getMqttClientDriverNetwork().getEnabled()) {
                this.connect();
            } else if (!this.getEnabled() && this.isClientConnectedToBroker()) {
                this.disconnectClient();
            }
        }
        if (this.getKeepAlive() < 0 || this.getKeepAlive() > 65535) {
            logger.log(Level.WARNING, "Value for keep alive should be in valid range i.e 0-65535");
            this.setKeepAlive(60);
        }
        if ((authenticator = this.getAuthenticator(false)) != null) {
            authenticator.changed(property, context);
            if (this.getBoolean(enableLWT)) {
                this.setFlags((Slot)topicForLWT, 0);
                this.setFlags((Slot)qosForLWT, 0);
                this.setFlags((Slot)retainedForLWT, 0);
                this.setFlags((Slot)messageForLWT, 0);
            } else {
                this.setFlags((Slot)topicForLWT, 1);
                this.setFlags((Slot)qosForLWT, 1);
                this.setFlags((Slot)retainedForLWT, 1);
                this.setFlags((Slot)messageForLWT, 1);
                this.setTopicForLWT(this.getTopicForLWT());
                this.setQosForLWT(BMqttQualityOfService.FireAndForget);
                this.setMessageForLWT("");
            }
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (property.getType().is(BAbstractMqttAuthenticator.TYPE)) {
            if (this.nMqttClient != null && this.nMqttClient.isConnected()) {
                this.disconnectClient();
            }
            this.authenticator.preRemove();
            this.authenticator = null;
        }
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (property.getType().is(BAbstractMqttAuthenticator.TYPE)) {
            this.authenticator = (BAbstractMqttAuthenticator)this.get(property);
        }
    }

    private void modifySubscriptionOfAll(BComponent comp, boolean subscribe, boolean isBulkAction) throws Exception {
        this.getAuthenticator(true).getSubscriberMap().clearSubscriberMap();
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Integer> qosList = null;
        if (subscribe) {
            qosList = new ArrayList<Integer>();
        }
        ComponentTreeCursor cursor = new ComponentTreeCursor(comp, BMqttClientAbstractSubscriberPoint.TYPE, null);
        while (cursor.next(BMqttClientAbstractSubscriberPoint.class)) {
            BMqttClientAbstractSubscriberPoint subscriberChild = (BMqttClientAbstractSubscriberPoint)cursor.get();
            if (subscribe) {
                if (isBulkAction) {
                    this.subscribeTopics(topics, qosList, subscriberChild);
                    subscriberChild.setSubscribeOnStart(true);
                    continue;
                }
                if (!subscriberChild.getSubscribeOnStart()) continue;
                this.subscribeTopics(topics, qosList, subscriberChild);
                continue;
            }
            if (isBulkAction) {
                this.unsubscribeTopics(topics, subscriberChild);
                subscriberChild.setSubscribeOnStart(false);
                continue;
            }
            this.unsubscribeTopics(topics, subscriberChild);
        }
        this.modifyTopicsIfNotAdded(subscribe, topics, qosList);
    }

    private void subscribeTopics(ArrayList<String> topics, ArrayList<Integer> qosList, BMqttClientAbstractSubscriberPoint subscriberChild) {
        String topic = subscriberChild.getTopic();
        if (!this.getAuthenticator(true).getSubscriberMap().isValidTopic(topic)) {
            logger.fine(topic + lex.get("invalidTopic"));
            return;
        }
        subscriberChild.addToBulkSubscribedLists(topics, qosList);
        subscriberChild.setFlagsForTopicAndQos();
        if (topics.size() >= this.numberToBulkSubscribe) {
            this.checkAndBulkSubscribe(topics, qosList);
            topics.clear();
            qosList.clear();
        }
    }

    private void modifyTopicsIfNotAdded(boolean subscribe, ArrayList<String> topics, ArrayList<Integer> qosList) throws Exception {
        if (topics.size() > 0) {
            String[] topicsArray = topics.toArray(new String[0]);
            try {
                if (subscribe) {
                    int[] qosIntList = new int[qosList.size()];
                    for (int i = 0; i < qosList.size(); ++i) {
                        qosIntList[i] = qosList.get(i);
                    }
                    this.nMqttClient.subscribe(topicsArray, qosIntList);
                } else {
                    this.nMqttClient.unsubscribe(topicsArray);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    private void unsubscribeTopics(ArrayList<String> topics, BMqttClientAbstractSubscriberPoint subscriberChild) {
        subscriberChild.addToBulkUnsubscribedList(topics);
        subscriberChild.unsetFlagsForTopicAndQos();
        if (topics.size() > this.numberToBulkSubscribe) {
            try {
                this.nMqttClient.unsubscribe(topics.toArray(new String[0]));
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
            }
            topics.clear();
        }
    }

    private void checkAndBulkSubscribe(ArrayList<String> topics, ArrayList<Integer> qosList) {
        if (topics.size() == 0) {
            return;
        }
        int[] qosIntList = new int[qosList.size()];
        for (int j = 0; j < qosList.size(); ++j) {
            qosIntList[j] = qosList.get(j);
        }
        try {
            this.nMqttClient.subscribe(topics.toArray(new String[0]), qosIntList);
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
        }
    }

    public Type getNetworkType() {
        return BAbstractMqttDriverNetwork.TYPE;
    }

    public void doPing() throws Exception {
        String message = "";
        if (this.isClientConnectedToBroker()) {
            message = lex.get("pingMessageOk");
            this.pingOk();
            this.setStatusMessage(message);
        } else {
            this.doConnect();
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BAbstractMqttAuthenticator && this.getAuthenticator(false) != null) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "authenticatorExist");
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    public Iterator<BINavNode> iterateNavDescendants() {
        return null;
    }

    public final BAbstractMqttDriverNetwork getMqttClientDriverNetwork() {
        if (this.getStatus().isFault() && lex.get("exceededDeviceLimit").equals(this.getFaultCause())) {
            throw new IllegalStateException(this.getFaultCause());
        }
        return (BAbstractMqttDriverNetwork)this.getNetwork();
    }

    public boolean isClientConnectedToBroker() {
        return this.nMqttClient == null ? false : this.nMqttClient.isConnected();
    }

    private void addMqttClientToChildren() {
        this.getPoints().setMqttClient(this.nMqttClient);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractMqttDriverNetwork || parent instanceof BAbstractMqttDriverDeviceFolder;
    }

    public void started() throws Exception {
        super.started();
        String deviceLimit = ((BAbstractMqttDriverNetwork)this.getNetwork()).incrementDeviceCount();
        if (deviceLimit != null) {
            logger.severe(deviceLimit);
            this.configFatal(deviceLimit);
            return;
        }
        if (this.getConnectionLostWaitingTime().getMillis() == 30000L) {
            this.setConnectionLostWaitingTime(BRelTime.make((long)AccessController.doPrivileged(() -> Integer.getInteger("mqtt.connectionLostWaitingTime", 30000)).intValue()));
        }
    }

    public void stopped() throws Exception {
        if (this.isClientConnectedToBroker()) {
            this.doDisconnect();
        }
        super.stopped();
    }

    public void enableAndDisableFields(int flag) {
        this.setFlags((Slot)cleanSession, flag);
        this.setFlags((Slot)enableLWT, flag);
        int lwtFlag = 1;
        if (this.getEnableLWT() && !this.isClientConnectedToBroker()) {
            lwtFlag = 0;
        }
        this.setFlags((Slot)topicForLWT, lwtFlag);
        this.setFlags((Slot)qosForLWT, lwtFlag);
        this.setFlags((Slot)retainedForLWT, lwtFlag);
        this.setFlags((Slot)messageForLWT, lwtFlag);
        this.setFlags((Slot)keepAlive, flag);
        this.setFlags((Slot)connectionTimeout, flag);
    }
}

