/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver;

import com.tridium.mqttClientDriver.BAbstractMqttDriverDeviceFolder;
import com.tridium.mqttClientDriver.BAbstractMqttDriverNetwork;
import com.tridium.mqttClientDriver.IBaseMqttDevice;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.MqttClientValidationsDriverDevice;
import com.tridium.mqttClientDriver.clients.paho.MqttClientPaho;
import com.tridium.mqttClientDriver.point.BMqttClientDriverPointDeviceExt;
import com.tridium.mqttClientDriver.proxyExt.subscribers.BMqttClientAbstractSubscriberPoint;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import com.tridium.mqttClientDriver.util.BMqttQualityOfService;
import com.tridium.mqttClientDriver.util.MqttActions;
import com.tridium.mqttClientDriver.util.MqttClientFactory;
import com.tridium.mqttClientDriver.util.MqttSubscriberTopics;
import com.tridium.mqttClientDriver.util.SupportedClientEnum;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.util.ComponentTreeCursor;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="points", type="BMqttClientDriverPointDeviceExt", defaultValue="new BMqttClientDriverPointDeviceExt()"), @NiagaraProperty(name="messageForLWT", type="String", defaultValue="", facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="cleanSession", type="boolean", defaultValue="false"), @NiagaraProperty(name="enableLWT", type="boolean", defaultValue="false"), @NiagaraProperty(name="topicForLWT", type="String", defaultValue=""), @NiagaraProperty(name="qosForLWT", type="BMqttQualityOfService", defaultValue="BMqttQualityOfService.FireAndForget"), @NiagaraProperty(name="retainedForLWT", type="boolean", defaultValue="true"), @NiagaraProperty(name="keepAlive", type="int", defaultValue="60"), @NiagaraProperty(name="connectionTimeout", type="int", defaultValue="300"), @NiagaraProperty(name="brokerIpAddress", type="String", defaultValue=""), @NiagaraProperty(name="brokerPort", type="int", defaultValue="1883", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65535")}), @NiagaraProperty(name="clientID", type="String", defaultValue="", flags=64), @NiagaraProperty(name="statusMessage", type="String", defaultValue="Disconnected"), @NiagaraProperty(name="connectionType", type="BMqttConnectionType", defaultValue="BMqttConnectionType.UserLoginOverSSL"), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1", flags=64), @NiagaraProperty(name="usernameAndPassword", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64), @NiagaraProperty(name="sendEnumAs", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"TAG\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"ORDINAL\")")})})
@NiagaraActions(value={@NiagaraAction(name="connect", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="subscribeAll", flags=16), @NiagaraAction(name="unsubscribeAll", flags=16)})
public class BAbstractMqttDriverDevice
extends BNDevice
implements IBaseMqttDevice {
    @Generated
    public static final Property status = BAbstractMqttDriverDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Property pollFrequency = BAbstractMqttDriverDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property points = BAbstractMqttDriverDevice.newProperty((int)0, (BValue)new BMqttClientDriverPointDeviceExt(), null);
    @Generated
    public static final Property messageForLWT = BAbstractMqttDriverDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property cleanSession = BAbstractMqttDriverDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property enableLWT = BAbstractMqttDriverDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property topicForLWT = BAbstractMqttDriverDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property qosForLWT = BAbstractMqttDriverDevice.newProperty((int)0, (BValue)BMqttQualityOfService.FireAndForget, null);
    @Generated
    public static final Property retainedForLWT = BAbstractMqttDriverDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property keepAlive = BAbstractMqttDriverDevice.newProperty((int)0, (int)60, null);
    @Generated
    public static final Property connectionTimeout = BAbstractMqttDriverDevice.newProperty((int)0, (int)300, null);
    @Generated
    public static final Property brokerIpAddress = BAbstractMqttDriverDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property brokerPort = BAbstractMqttDriverDevice.newProperty((int)0, (int)1883, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)65535)));
    @Generated
    public static final Property clientID = BAbstractMqttDriverDevice.newProperty((int)64, (String)"", null);
    @Generated
    public static final Property statusMessage = BAbstractMqttDriverDevice.newProperty((int)0, (String)"Disconnected", null);
    @Generated
    public static final Property connectionType = BAbstractMqttDriverDevice.newProperty((int)0, (BValue)BMqttConnectionType.UserLoginOverSSL, null);
    @Generated
    public static final Property sslVersion = BAbstractMqttDriverDevice.newProperty((int)64, (BValue)BSslTlsEnum.tlsv1, null);
    @Generated
    public static final Property usernameAndPassword = BAbstractMqttDriverDevice.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    @Generated
    public static final Property sendEnumAs = BAbstractMqttDriverDevice.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"TAG")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"ORDINAL"))));
    @Generated
    public static final Action connect = BAbstractMqttDriverDevice.newAction((int)16, null);
    @Generated
    public static final Action disconnect = BAbstractMqttDriverDevice.newAction((int)16, null);
    @Generated
    public static final Action subscribeAll = BAbstractMqttDriverDevice.newAction((int)16, null);
    @Generated
    public static final Action unsubscribeAll = BAbstractMqttDriverDevice.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractMqttDriverDevice.class);
    private INiagaraMqttClient nMqttClient;
    private MqttActions currentMqttAction = MqttActions.NONE;
    private SupportedClientEnum supportedClient = SupportedClientEnum.PAHO;
    private MqttSubscriberTopics subscriberMaps = new MqttSubscriberTopics();
    private static final Logger logger = Logger.getLogger("abstractMqttDriver.device");
    public static final Lexicon lex = BAbstractMqttDriverNetwork.lex;
    private int numberToBulkSubscribe = 500;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BMqttClientDriverPointDeviceExt getPoints() {
        return (BMqttClientDriverPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BMqttClientDriverPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public String getMessageForLWT() {
        return this.getString(messageForLWT);
    }

    @Generated
    public void setMessageForLWT(String v) {
        this.setString(messageForLWT, v, null);
    }

    @Generated
    public boolean getCleanSession() {
        return this.getBoolean(cleanSession);
    }

    @Generated
    public void setCleanSession(boolean v) {
        this.setBoolean(cleanSession, v, null);
    }

    @Generated
    public boolean getEnableLWT() {
        return this.getBoolean(enableLWT);
    }

    @Generated
    public void setEnableLWT(boolean v) {
        this.setBoolean(enableLWT, v, null);
    }

    @Generated
    public String getTopicForLWT() {
        return this.getString(topicForLWT);
    }

    @Generated
    public void setTopicForLWT(String v) {
        this.setString(topicForLWT, v, null);
    }

    @Generated
    public BMqttQualityOfService getQosForLWT() {
        return (BMqttQualityOfService)this.get(qosForLWT);
    }

    @Generated
    public void setQosForLWT(BMqttQualityOfService v) {
        this.set(qosForLWT, (BValue)v, null);
    }

    @Generated
    public boolean getRetainedForLWT() {
        return this.getBoolean(retainedForLWT);
    }

    @Generated
    public void setRetainedForLWT(boolean v) {
        this.setBoolean(retainedForLWT, v, null);
    }

    @Generated
    public int getKeepAlive() {
        return this.getInt(keepAlive);
    }

    @Generated
    public void setKeepAlive(int v) {
        this.setInt(keepAlive, v, null);
    }

    @Generated
    public int getConnectionTimeout() {
        return this.getInt(connectionTimeout);
    }

    @Generated
    public void setConnectionTimeout(int v) {
        this.setInt(connectionTimeout, v, null);
    }

    @Generated
    public String getBrokerIpAddress() {
        return this.getString(brokerIpAddress);
    }

    @Generated
    public void setBrokerIpAddress(String v) {
        this.setString(brokerIpAddress, v, null);
    }

    @Generated
    public int getBrokerPort() {
        return this.getInt(brokerPort);
    }

    @Generated
    public void setBrokerPort(int v) {
        this.setInt(brokerPort, v, null);
    }

    @Generated
    public String getClientID() {
        return this.getString(clientID);
    }

    @Generated
    public void setClientID(String v) {
        this.setString(clientID, v, null);
    }

    @Generated
    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    @Generated
    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    @Generated
    public BMqttConnectionType getConnectionType() {
        return (BMqttConnectionType)this.get(connectionType);
    }

    @Generated
    public void setConnectionType(BMqttConnectionType v) {
        this.set(connectionType, (BValue)v, null);
    }

    @Generated
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    @Generated
    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Generated
    public BUsernameAndPassword getUsernameAndPassword() {
        return (BUsernameAndPassword)this.get(usernameAndPassword);
    }

    @Generated
    public void setUsernameAndPassword(BUsernameAndPassword v) {
        this.set(usernameAndPassword, (BValue)v, null);
    }

    @Generated
    public boolean getSendEnumAs() {
        return this.getBoolean(sendEnumAs);
    }

    @Generated
    public void setSendEnumAs(boolean v) {
        this.setBoolean(sendEnumAs, v, null);
    }

    @Generated
    public void connect() {
        this.invoke(connect, null, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Generated
    public void subscribeAll() {
        this.invoke(subscribeAll, null, null);
    }

    @Generated
    public void unsubscribeAll() {
        this.invoke(unsubscribeAll, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BAbstractMqttDriverNetwork.TYPE;
    }

    public void stopped() throws Exception {
        if (this.isClientConnectedToBroker()) {
            this.doDisconnect();
        }
        super.stopped();
    }

    public void doPing() {
        String message = "";
        if (this.isClientConnectedToBroker()) {
            message = lex.get("pingMessageOk");
            this.pingOk();
        } else {
            this.doConnect();
            if (this.isClientConnectedToBroker()) {
                this.pingOk();
            } else {
                message = lex.get("pingMessageFail");
                this.pingFail(message);
            }
        }
        this.setStatusMessage(message);
    }

    public final BAbstractMqttDriverNetwork getMqttClientDriverNetwork() {
        if (this.getStatus().isFault() && lex.get("exceededDeviceLimit").equals(this.getFaultCause())) {
            throw new IllegalStateException(this.getFaultCause());
        }
        return (BAbstractMqttDriverNetwork)this.getNetwork();
    }

    public void doConnect() {
        if (!this.getEnabled() && !this.getMqttClientDriverNetwork().getEnabled()) {
            return;
        }
        this.setCurrentMqttAction(MqttActions.CONNECT);
        if (!MqttClientValidationsDriverDevice.getMqttClientValidationsInstance().validateConnectParams(this, this.nMqttClient)) {
            return;
        }
        try {
            this.nMqttClient = MqttClientFactory.getClient(this);
            this.nMqttClient.connect();
            this.getMqttClientDriverNetwork().addUniqueClientId(this.getClientID());
            this.modifySubscriptionOfAll((BComponent)this, true, false);
            this.addMqttClientToChildren();
            String message = lex.get("connected");
            this.enableAndDisableFields(1);
            this.setStatusMessage(message);
            this.pingOk();
        }
        catch (Exception e) {
            this.enableAndDisableFields(0);
            logger.warning(this.getClientID() + " not Connected. Error: " + e.getMessage());
            String message = e instanceof LocalizableRuntimeException ? e.getMessage() : lex.get("couldNotConnect");
            this.setStatusMessage(message);
            this.pingFail(message);
        }
        finally {
            this.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    @Override
    public void doSubscribeAll() {
        this.modifyBulkSubscription((BComponent)this, true);
    }

    @Override
    public void doUnsubscribeAll() {
        this.modifyBulkSubscription((BComponent)this, false);
    }

    public void modifyBulkSubscription(BComponent comp, boolean subscribe) {
        if (!this.isClientConnectedToBroker()) {
            logger.fine(lex.get("clientNotConnected"));
            return;
        }
        try {
            this.modifySubscriptionOfAll(comp, subscribe, true);
        }
        catch (Exception e) {
            logger.fine(e.getLocalizedMessage());
        }
    }

    public boolean isClientConnectedToBroker() {
        return this.nMqttClient == null ? false : this.nMqttClient.isConnected();
    }

    private void enableAndDisableFields(int flag) {
        this.setFlags((Slot)cleanSession, flag);
        this.setFlags((Slot)enableLWT, flag);
        int lwtFlag = 1;
        if (this.getEnableLWT() && !this.isClientConnectedToBroker()) {
            lwtFlag = 0;
        }
        this.setFlags((Slot)topicForLWT, lwtFlag);
        this.setFlags((Slot)qosForLWT, lwtFlag);
        this.setFlags((Slot)retainedForLWT, lwtFlag);
        this.setFlags((Slot)messageForLWT, lwtFlag);
        this.setFlags((Slot)keepAlive, flag);
        this.setFlags((Slot)connectionTimeout, flag);
        this.setFlags((Slot)brokerIpAddress, flag);
        this.setFlags((Slot)brokerPort, flag);
        this.setFlags((Slot)connectionType, flag);
        this.setFlags((Slot)clientID, flag | 0x40);
        if (this.getConnectionType() == BMqttConnectionType.UserLoginOverSSL && !this.isClientConnectedToBroker()) {
            this.setFlags((Slot)usernameAndPassword, 64);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
        }
        this.setFlags((Slot)sslVersion, flag);
    }

    public void doDisconnect() {
        if (this.getEnabled() && this.getMqttClientDriverNetwork().getEnabled()) {
            this.disconnectClient();
        }
    }

    public void disconnectClient() {
        this.setCurrentMqttAction(MqttActions.DISCONNECT);
        this.getMqttClientDriverNetwork().removeClientIdFromList(this.getClientID());
        this.enableAndDisableFields(0);
        if (!MqttClientValidationsDriverDevice.getMqttClientValidationsInstance().validateDisconnectParams(this, this.nMqttClient)) {
            return;
        }
        try {
            this.modifySubscriptionOfAll((BComponent)this, false, false);
            this.nMqttClient.disconnect();
            String message = lex.get("disconnected");
            this.setStatusMessage(message);
            this.pingFail(message);
        }
        catch (Exception e) {
            String message = e instanceof LocalizableRuntimeException ? e.getMessage() : lex.get("couldNotDisconnect");
            this.setStatusMessage(message);
            this.pingFail(message);
        }
        finally {
            this.setCurrentMqttAction(MqttActions.NONE);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == enabled && this.isRunning()) {
            if (this.getEnabled() && !this.isClientConnectedToBroker() && this.getMqttClientDriverNetwork().getEnabled()) {
                this.connect();
            } else if (!this.getEnabled() && this.isClientConnectedToBroker()) {
                this.disconnectClient();
            }
        }
        if (this.get(connectionType) == BMqttConnectionType.UserLoginOverSSL) {
            this.setFlags((Slot)usernameAndPassword, 64);
            this.setFlags((Slot)sslVersion, 0);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
            this.getUsernameAndPassword().setUsername("");
            this.getUsernameAndPassword().setPassword(BPassword.DEFAULT);
            if (this.get(connectionType) != BMqttConnectionType.Anonymous) {
                this.setFlags((Slot)sslVersion, 0);
            } else {
                this.setFlags((Slot)sslVersion, 1);
            }
        }
        if (this.getBoolean(enableLWT)) {
            this.setFlags((Slot)topicForLWT, 0);
            this.setFlags((Slot)qosForLWT, 0);
            this.setFlags((Slot)retainedForLWT, 0);
            this.setFlags((Slot)messageForLWT, 0);
        } else {
            this.setFlags((Slot)topicForLWT, 1);
            this.setFlags((Slot)qosForLWT, 1);
            this.setFlags((Slot)retainedForLWT, 1);
            this.setFlags((Slot)messageForLWT, 1);
            this.setTopicForLWT("");
            this.setQosForLWT(BMqttQualityOfService.FireAndForget);
            this.setMessageForLWT("");
        }
    }

    public void setCurrentMqttAction(MqttActions action) {
        this.currentMqttAction = action;
    }

    public MqttActions getCurrentMqttAction() {
        return this.currentMqttAction;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.getMqttClientDriverNetwork().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    private void modifySubscriptionOfAll(BComponent comp, boolean subscribe, boolean isBulkAction) throws Exception {
        this.subscriberMaps.clearSubscriberMap();
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Integer> qosList = null;
        if (subscribe) {
            qosList = new ArrayList<Integer>();
        }
        ComponentTreeCursor cursor = new ComponentTreeCursor(comp, BMqttClientAbstractSubscriberPoint.TYPE, null);
        while (cursor.next(BMqttClientAbstractSubscriberPoint.class)) {
            boolean pointSubscribed;
            BMqttClientAbstractSubscriberPoint subscriberChild = (BMqttClientAbstractSubscriberPoint)cursor.get();
            boolean bl = pointSubscribed = subscriberChild.getFlagsOfTopic() == 1;
            if (subscribe && (isBulkAction ? !pointSubscribed : pointSubscribed)) {
                this.subscribeTopics(topics, qosList, subscriberChild);
                continue;
            }
            if (subscribe || !(isBulkAction ? pointSubscribed : !pointSubscribed)) continue;
            this.unsubscribeTopics(topics, subscriberChild);
        }
        this.modifyTopicsIfNotAdded(subscribe, topics, qosList);
    }

    private void modifyTopicsIfNotAdded(boolean subscribe, ArrayList<String> topics, ArrayList<Integer> qosList) throws Exception {
        if (topics.size() > 0) {
            String[] topicsArray = topics.toArray(new String[0]);
            if (subscribe) {
                int[] qosIntList = new int[qosList.size()];
                for (int i = 0; i < qosList.size(); ++i) {
                    qosIntList[i] = qosList.get(i);
                }
                this.nMqttClient.subscribe(topicsArray, qosIntList);
            } else {
                this.nMqttClient.unsubscribe(topicsArray);
            }
        }
    }

    private void unsubscribeTopics(ArrayList<String> topics, BMqttClientAbstractSubscriberPoint subscriberChild) {
        subscriberChild.addToBulkUnsubscribedList(topics);
        subscriberChild.unsetFlagsForTopicAndQos();
        if (topics.size() > this.numberToBulkSubscribe) {
            try {
                this.nMqttClient.unsubscribe(topics.toArray(new String[0]));
            }
            catch (Exception e) {
                logger.fine(e.getMessage());
            }
            topics.clear();
        }
    }

    private void subscribeTopics(ArrayList<String> topics, ArrayList<Integer> qosList, BMqttClientAbstractSubscriberPoint subscriberChild) {
        String topic = subscriberChild.getTopic();
        if (!this.subscriberMaps.isValidTopic(topic)) {
            logger.fine(topic + lex.get("invalidTopic"));
            return;
        }
        subscriberChild.addToBulkSubscribedLists(topics, qosList);
        subscriberChild.setFlagsForTopicAndQos();
        if (topics.size() >= this.numberToBulkSubscribe) {
            this.checkAndBulkSubscribe(topics, qosList);
            topics.clear();
            qosList.clear();
        }
    }

    private void checkAndBulkSubscribe(ArrayList<String> topics, ArrayList<Integer> qosList) {
        if (topics.size() == 0) {
            return;
        }
        int[] qosIntList = new int[qosList.size()];
        for (int j = 0; j < qosList.size(); ++j) {
            qosIntList[j] = qosList.get(j);
        }
        try {
            this.nMqttClient.subscribe(topics.toArray(new String[0]), qosIntList);
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
    }

    private void addMqttClientToChildren() {
        this.getPoints().setMqttClient(this.nMqttClient);
    }

    public SupportedClientEnum getSupportedClient() {
        return this.supportedClient;
    }

    public void setSupportedClient(SupportedClientEnum supportedClient) {
        if (this.isClientConnectedToBroker()) {
            return;
        }
        this.supportedClient = supportedClient;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractMqttDriverNetwork || parent instanceof BAbstractMqttDriverDeviceFolder;
    }

    public void started() throws Exception {
        String deviceLimit;
        if (this.getClientID().isEmpty()) {
            this.setClientID(MqttClientPaho.generateClientId());
        }
        if ((deviceLimit = ((BAbstractMqttDriverNetwork)this.getNetwork()).incrementDeviceCount()) != null) {
            logger.severe(deviceLimit);
            this.configFatal(deviceLimit);
            return;
        }
        super.started();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled() && !this.isFault()) {
            this.doConnect();
        }
    }

    public MqttSubscriberTopics getSubscriberMap() {
        return this.subscriberMaps;
    }
}

