/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.azure;

import com.tridium.azureUtils.AzureIotSasTokenUtils;
import com.tridium.azureUtils.AzureSasException;
import com.tridium.azureUtils.AzureSasTokenParameters;
import com.tridium.azureUtils.BAzureIotSasToken;
import com.tridium.azureUtils.BAzureSasTokenParameters;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.generic.IGenericConnectionOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.paho.MqttClientPaho;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="brokerPort", type="int", defaultValue="8883", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="100000")}, override=true), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="advanceExpiration", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.makeMinutes(1)")}), @NiagaraProperty(name="reconnectAfterTokenGeneration", type="boolean", defaultValue="true"), @NiagaraProperty(name="lastError", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="lastErrorTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="tokenParameters", type="BAzureSasTokenParameters", defaultValue="new BAzureSasTokenParameters()"), @NiagaraProperty(name="currentToken", type="BAzureIotSasToken", defaultValue="new BAzureIotSasToken()")})
@NiagaraActions(value={@NiagaraAction(name="generateNewToken", flags=16), @NiagaraAction(name="setupFromConnectionString", parameterType="BString", defaultValue="BString.DEFAULT")})
public class BAzureMqttSasAuthenticator
extends BAbstractMqttAuthenticator
implements IGenericConnectionOptions {
    @Generated
    public static final Property brokerPort = BAzureMqttSasAuthenticator.newProperty((int)0, (int)8883, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)100000)));
    @Generated
    public static final Property sslVersion = BAzureMqttSasAuthenticator.newProperty((int)0, (BValue)BSslTlsEnum.tlsv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property advanceExpiration = BAzureMqttSasAuthenticator.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeMinutes((int)1))));
    @Generated
    public static final Property reconnectAfterTokenGeneration = BAzureMqttSasAuthenticator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property lastError = BAzureMqttSasAuthenticator.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastErrorTime = BAzureMqttSasAuthenticator.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property tokenParameters = BAzureMqttSasAuthenticator.newProperty((int)0, (BValue)new BAzureSasTokenParameters(), null);
    @Generated
    public static final Property currentToken = BAzureMqttSasAuthenticator.newProperty((int)0, (BValue)new BAzureIotSasToken(), null);
    @Generated
    public static final Action generateNewToken = BAzureMqttSasAuthenticator.newAction((int)16, null);
    @Generated
    public static final Action setupFromConnectionString = BAzureMqttSasAuthenticator.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAzureMqttSasAuthenticator.class);
    private INiagaraMqttClient mqttClientPaho;
    private Clock.Ticket regenTicket;
    private static final int newTokenDelaySecs = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("azure.mqtt.sas.newTokenDelaySecs", "10")));
    private static final Logger LOG = Logger.getLogger("abstractMqttDriver.authenticator.azure");
    private static final Lexicon LEX = Lexicon.make(BAzureMqttSasAuthenticator.class);

    @Override
    @Generated
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    @Generated
    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Generated
    public BRelTime getAdvanceExpiration() {
        return (BRelTime)this.get(advanceExpiration);
    }

    @Generated
    public void setAdvanceExpiration(BRelTime v) {
        this.set(advanceExpiration, (BValue)v, null);
    }

    @Generated
    public boolean getReconnectAfterTokenGeneration() {
        return this.getBoolean(reconnectAfterTokenGeneration);
    }

    @Generated
    public void setReconnectAfterTokenGeneration(boolean v) {
        this.setBoolean(reconnectAfterTokenGeneration, v, null);
    }

    @Generated
    public String getLastError() {
        return this.getString(lastError);
    }

    @Generated
    public void setLastError(String v) {
        this.setString(lastError, v, null);
    }

    @Generated
    public BAbsTime getLastErrorTime() {
        return (BAbsTime)this.get(lastErrorTime);
    }

    @Generated
    public void setLastErrorTime(BAbsTime v) {
        this.set(lastErrorTime, (BValue)v, null);
    }

    @Generated
    public BAzureSasTokenParameters getTokenParameters() {
        return (BAzureSasTokenParameters)this.get(tokenParameters);
    }

    @Generated
    public void setTokenParameters(BAzureSasTokenParameters v) {
        this.set(tokenParameters, (BValue)v, null);
    }

    @Generated
    public BAzureIotSasToken getCurrentToken() {
        return (BAzureIotSasToken)this.get(currentToken);
    }

    @Generated
    public void setCurrentToken(BAzureIotSasToken v) {
        this.set(currentToken, (BValue)v, null);
    }

    @Generated
    public void generateNewToken() {
        this.invoke(generateNewToken, null, null);
    }

    @Generated
    public void setupFromConnectionString(BString parameter) {
        this.invoke(setupFromConnectionString, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStation() && this.getCurrentToken().getTokenStored()) {
            this.scheduleNewTokenGen();
        }
    }

    @Override
    public void preRemove() {
        if (Sys.isStation()) {
            try {
                AzureIotSasTokenUtils.removeFromKeyRing((String)this.getKeyRingStoreKey(), (String[])new String[]{"AzureSharedAccessKey", "AzureSasToken"});
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to clear keyring entries for store: " + this.getKeyRingStoreKey(), e);
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        new Thread((Runnable)new Invocation((BComponent)this, action, argument, cx), "AzureSasAuthActionThread").start();
        return null;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BAbstractMqttDevice.TYPE);
    }

    public void doSetupFromConnectionString(BString connectionString) {
        if (this.isRunning()) {
            try {
                this.setupFromAzureConnectionString(connectionString.getString());
            }
            catch (Exception e) {
                this.error(String.format("Failed to setup new SAS token because: %s", e.getMessage()), e);
            }
        }
    }

    private void setupFromAzureConnectionString(String connectionString) throws AzureSasException {
        AzureSasTokenParameters parameters = AzureIotSasTokenUtils.getParametersForConnectionString((String)connectionString, (String)this.getTokenParameters().getApiVersion());
        this.setBrokerEndpoint(parameters.getAzureHost());
        this.setClientID(parameters.getAzureDeviceId());
        this.getTokenParameters().setAzureHost(parameters.getAzureHost());
        this.getTokenParameters().setAzureDeviceId(parameters.getAzureDeviceId());
        this.getTokenParameters().setUserName(parameters.getUserName());
        this.getTokenParameters().setSharedAccessKey(parameters.getSharedAccessKey());
        this.getTokenParameters().store(this.getKeyRingStoreKey());
        this.generateNewToken();
    }

    public void doGenerateNewToken() {
        this.info("Generating new SAS token");
        try {
            this.getTokenParameters().validate(this.getKeyRingStoreKey());
            this.setCurrentToken(AzureIotSasTokenUtils.generateSasToken((BAzureSasTokenParameters)this.getTokenParameters(), (String)this.getKeyRingStoreKey()));
            this.scheduleNewTokenGen();
            this.info("Generated new SAS token");
            if (this.getReconnectAfterTokenGeneration()) {
                this.reconnect();
            }
        }
        catch (Exception e) {
            this.error(String.format("Failed to generate new SAS token because: %s", e.getMessage()), e);
        }
    }

    private void reconnect() {
        BAbstractMqttDevice device = (BAbstractMqttDevice)this.getParent().as(BAbstractMqttDevice.class);
        this.info("Re-connecting with new SAS token");
        try {
            if (device.isClientConnectedToBroker()) {
                device.doDisconnect();
            }
            this.mqttClientPaho = null;
            device.doConnect();
        }
        catch (Exception e) {
            this.error(String.format("Failed to reconnect device with new token: %s", e.getMessage()), e);
        }
    }

    private void scheduleNewTokenGen() {
        BAbsTime nextRegenTime;
        if (this.regenTicket != null && !this.regenTicket.isExpired()) {
            this.regenTicket.cancel();
        }
        if ((nextRegenTime = this.getCurrentToken().getNextExpiryTime().subtract(this.getAdvanceExpiration())).isBefore(BAbsTime.now())) {
            nextRegenTime = BAbsTime.now().add(BRelTime.makeSeconds((int)newTokenDelaySecs));
        }
        this.info(String.format("Scheduled next SAS token generation at %s", nextRegenTime));
        this.regenTicket = Clock.schedule((BComponent)this, (BAbsTime)nextRegenTime, (Action)generateNewToken, null);
    }

    private String getKeyRingStoreKey() {
        return this.getHandle().toString();
    }

    @Override
    public INiagaraMqttClient connect(BAbstractMqttDevice device) throws Exception {
        if (this.mqttClientPaho == null) {
            this.mqttClientPaho = new MqttClientPaho(this);
        }
        if (!this.mqttClientPaho.isConnected()) {
            this.mqttClientPaho.connect();
        }
        return this.mqttClientPaho;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mqttClientPaho != null) {
            this.mqttClientPaho.disconnect();
        }
    }

    @Override
    public BMqttConnectionType getConnectionType() {
        return BMqttConnectionType.UserLoginOverSSL;
    }

    @Override
    public BUsernameAndPassword getUsernameAndPassword() {
        String userName = this.getTokenParameters().getUserName();
        try {
            return new BUsernameAndPassword(userName, this.getCurrentToken().getTokenValue(this.getKeyRingStoreKey()));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, LEX.get("azure.sas.keyring.notoken"), e);
            return new BUsernameAndPassword(userName, "");
        }
    }

    @Override
    public void enableAndDisableFields(int i) {
    }

    private void info(String message) {
        LOG.info(this.formattedLogLine(message));
    }

    private void error(String message, Exception e) {
        LOG.log(Level.SEVERE, this.formattedLogLine(message), e);
        this.setLastError(message);
        this.setLastErrorTime(BAbsTime.now());
    }

    private String formattedLogLine(String message) {
        return String.format("Azure SAS device: [%s]: %s", this.getDevice().getName(), message);
    }
}

