/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.azure;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverNetwork;
import com.tridium.mqttClientDriver.authenticator.azure.BAzureMqttSasAuthenticator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.baja.driver.BDevice;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"abstractMqttDriver:AbstractMqttDriverNetwork"})})
public class BAzureMqttSasSecurityAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAzureMqttSasSecurityAgent.class);
    private SecurityDashboardItemBuilder builder;
    private BAbstractMqttDriverNetwork network;
    private List<BDevice> azureDevices;
    private List<BDevice> goodDevices;
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private static final int RECOMMENDED_TOKEN_EXP_DAYS = 1;
    private static final long MAX_TOKEN_MILLIS = 86400000L;
    private static final String SECTION_HEADER = "securityDashboard.azure.sectionHeader";
    public static final String DEVICES_OK_SUMMARY = "securityDashboard.mqtt.azure.ok.summary";
    public static final String DEVICES_OK_DESCRIPTION = "securityDashboard.mqtt.azure.ok.description";
    public static final String TLS_VERSION_SUMMARY = "securityDashboard.mqttTlsProtocol.summary";
    public static final String TLS_VERSION_DESCRIPTION = "securityDashboard.mqttTlsProtocol.description";
    public static final String TOKEN_EXPIRED_SUMMARY = "securityDashboard.mqtt.azure.tokenExpired.summary";
    public static final String TOKEN_EXPIRED_DESCRIPTION = "securityDashboard.mqtt.azure.tokenExpired.description";
    public static final String LONG_TOKEN_EXPIRATION_SUMMARY = "securityDashboard.mqtt.azure.longToken.summary";
    public static final String LONG_TOKEN_EXPIRATION_SETTING_SUMMARY = "securityDashboard.mqtt.azure.longTokenSetting.summary";
    public static final String LONG_TOKEN_EXPIRATION_DESCRIPTION = "securityDashboard.mqtt.azure.longToken.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.network = (BAbstractMqttDriverNetwork)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this.network);
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.network.getNavOrd().relativizeToSession();
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.initDeviceList();
        this.checkDevices(BSecurityItemStatus.securityStatusWarning, items, TLS_VERSION_SUMMARY, TLS_VERSION_DESCRIPTION, BSslTlsEnum.tlsv1_2, BAzureMqttSasSecurityAgent::isTlsVersionWeak, cx);
        this.checkDevices(BSecurityItemStatus.securityStatusWarning, items, LONG_TOKEN_EXPIRATION_SUMMARY, LONG_TOKEN_EXPIRATION_DESCRIPTION, 1, BAzureMqttSasSecurityAgent::isTokenExpirationTooGreat, cx);
        this.checkDevices(BSecurityItemStatus.securityStatusWarning, items, LONG_TOKEN_EXPIRATION_SETTING_SUMMARY, LONG_TOKEN_EXPIRATION_DESCRIPTION, 1, BAzureMqttSasSecurityAgent::isNextTokenExpirationTooGreat, cx);
        this.checkDevices(BSecurityItemStatus.securityStatusAlert, items, TOKEN_EXPIRED_SUMMARY, TOKEN_EXPIRED_DESCRIPTION, null, BAzureMqttSasSecurityAgent::isTokenExpired, cx);
        this.rewardGoodDevices(items, cx);
        return items;
    }

    private void initDeviceList() {
        List devices = this.network.getBDeviceList();
        this.azureDevices = devices.stream().map(dev -> (BAbstractMqttDevice)dev.as(BAbstractMqttDevice.class)).filter(dev -> dev.getEnabled()).filter(BAzureMqttSasSecurityAgent::isAzureDevice).collect(Collectors.toList());
        this.goodDevices = new ArrayList<BDevice>(this.azureDevices);
    }

    private void checkDevices(BSecurityItemStatus securityStatus, List<SecurityDashboardItem> items, String summaryKey, String descriptionKey, Object descriptionArg, Predicate<BAbstractMqttDevice> secCheck, Context cx) {
        List<BAbstractMqttDevice> badDevices = this.azureDevices.stream().map(dev -> (BAbstractMqttDevice)dev.as(BAbstractMqttDevice.class)).filter(secCheck).collect(Collectors.toList());
        badDevices.forEach(dev -> this.goodDevices.remove(dev));
        List<String> deviceNames = badDevices.stream().map(dev -> dev.getDisplayName(cx)).sorted().collect(Collectors.toList());
        this.createItem(securityStatus, items, summaryKey, descriptionKey, descriptionArg, deviceNames);
    }

    private void rewardGoodDevices(List<SecurityDashboardItem> items, Context cx) {
        List<String> goodDeviceNames = this.goodDevices.stream().map(dev -> dev.getDisplayName(cx)).sorted().collect(Collectors.toList());
        this.createItem(BSecurityItemStatus.securityStatusOK, items, DEVICES_OK_SUMMARY, DEVICES_OK_DESCRIPTION, null, goodDeviceNames);
    }

    private void createItem(BSecurityItemStatus securityStatus, List<SecurityDashboardItem> items, String summaryKey, String descriptionKey, Object descriptionArg, List<String> clients) {
        if (!clients.isEmpty()) {
            items.add(this.builder.make(securityStatus).withSummary(summaryKey, new Object[]{String.join((CharSequence)", ", clients)}).withDescription(descriptionKey, new Object[]{descriptionArg}));
        }
    }

    private static boolean isAzureDevice(BAbstractMqttDevice device) {
        BAbstractMqttAuthenticator authenticator = device.getAuthenticator(false);
        return authenticator instanceof BAzureMqttSasAuthenticator;
    }

    private static boolean isTlsVersionWeak(BAbstractMqttDevice device) {
        return BAzureMqttSasSecurityAgent.isTlsVersionWeak(BAzureMqttSasSecurityAgent.getAuthenticator(device).getSslVersion());
    }

    private static boolean isTlsVersionWeak(BSslTlsEnum tlsVersion) {
        return tlsVersion.getOrdinal() < BSslTlsEnum.tlsv1_2.getOrdinal();
    }

    private static boolean isTokenExpirationTooGreat(BAbstractMqttDevice device) {
        BAbsTime currentTokenExpiration = BAzureMqttSasSecurityAgent.getAuthenticator(device).getCurrentToken().getNextExpiryTime();
        return currentTokenExpiration.isAfter(BAbsTime.DEFAULT) && BAbsTime.now().delta(currentTokenExpiration).getMillis() > 86400000L;
    }

    private static boolean isNextTokenExpirationTooGreat(BAbstractMqttDevice device) {
        BRelTime tokenExpirationSetting = BAzureMqttSasSecurityAgent.getAuthenticator(device).getTokenParameters().getNextTokenExpiryPeriod();
        return tokenExpirationSetting.getMillis() > 86400000L;
    }

    private static boolean isTokenExpired(BAbstractMqttDevice device) {
        BAbsTime currentTokenExpiration = BAzureMqttSasSecurityAgent.getAuthenticator(device).getCurrentToken().getNextExpiryTime();
        return currentTokenExpiration.isAfter(BAbsTime.DEFAULT) && currentTokenExpiration.isBefore(BAbsTime.now());
    }

    private static BAzureMqttSasAuthenticator getAuthenticator(BAbstractMqttDevice device) {
        BAbstractMqttAuthenticator authenticator = device.getAuthenticator(false);
        return (BAzureMqttSasAuthenticator)authenticator.as(BAzureMqttSasAuthenticator.class);
    }
}

