/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.authenticator.generic;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.generic.IGenericConnectionOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.paho.MqttClientPaho;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import com.tridium.nre.security.SigningPasswordPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.mqttClientDriver.authenticator.BAbstractMqttAuthenticator;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BICertificateAliasAndPasswordContainer;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="connectionType", type="BMqttConnectionType", defaultValue="BMqttConnectionType.UserLoginOverSSL", facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="sslVersion", type="BSslTlsEnum", defaultValue="BSslTlsEnum.tlsv1_2", flags=64, facets={@Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="usernameAndPassword", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64), @NiagaraProperty(name="useTlsClientAuth", type="boolean", defaultValue="false", flags=64), @NiagaraProperty(name="certificateAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", flags=64, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BGenericMqttAuthenticator
extends BAbstractMqttAuthenticator
implements IGenericConnectionOptions,
BICertificateAliasAndPasswordContainer {
    @Generated
    public static final Property connectionType = BGenericMqttAuthenticator.newProperty((int)0, (BValue)BMqttConnectionType.UserLoginOverSSL, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property sslVersion = BGenericMqttAuthenticator.newProperty((int)64, (BValue)BSslTlsEnum.tlsv1_2, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property usernameAndPassword = BGenericMqttAuthenticator.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    @Generated
    public static final Property useTlsClientAuth = BGenericMqttAuthenticator.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Property certificateAliasAndPassword = BGenericMqttAuthenticator.newProperty((int)64, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BGenericMqttAuthenticator.class);
    private BAbstractMqttDevice device;
    private INiagaraMqttClient mqttClientPaho;
    private static final Logger LOG = Logger.getLogger("abstractMqttDriver.authenticator.generic");

    @Override
    @Generated
    public BMqttConnectionType getConnectionType() {
        return (BMqttConnectionType)this.get(connectionType);
    }

    @Generated
    public void setConnectionType(BMqttConnectionType v) {
        this.set(connectionType, (BValue)v, null);
    }

    @Override
    @Generated
    public BSslTlsEnum getSslVersion() {
        return (BSslTlsEnum)this.get(sslVersion);
    }

    @Generated
    public void setSslVersion(BSslTlsEnum v) {
        this.set(sslVersion, (BValue)v, null);
    }

    @Override
    @Generated
    public BUsernameAndPassword getUsernameAndPassword() {
        return (BUsernameAndPassword)this.get(usernameAndPassword);
    }

    @Generated
    public void setUsernameAndPassword(BUsernameAndPassword v) {
        this.set(usernameAndPassword, (BValue)v, null);
    }

    @Override
    @Generated
    public boolean getUseTlsClientAuth() {
        return this.getBoolean(useTlsClientAuth);
    }

    @Generated
    public void setUseTlsClientAuth(boolean v) {
        this.setBoolean(useTlsClientAuth, v, null);
    }

    @Override
    @Generated
    public BCertificateAliasAndPassword getCertificateAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certificateAliasAndPassword);
    }

    @Generated
    public void setCertificateAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certificateAliasAndPassword, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public INiagaraMqttClient connect(BAbstractMqttDevice device) throws Exception {
        this.device = device;
        if (this.mqttClientPaho == null) {
            this.mqttClientPaho = new MqttClientPaho(this);
        }
        if (this.mqttClientPaho != null && !this.mqttClientPaho.isConnected()) {
            this.mqttClientPaho.connect();
        }
        return this.mqttClientPaho;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mqttClientPaho != null) {
            this.mqttClientPaho.disconnect();
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getClientID().isEmpty()) {
            this.setClientID(MqttClientPaho.generateClientId());
        }
        this.getCertificateAliasAndPassword().setFacets((Slot)BCertificateAliasAndPassword.alias, BFacets.make((String)"purposeId", (String)KeyPurpose.CLIENT_CERT.name()));
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (this.get(connectionType) == BMqttConnectionType.UserLoginOverSSL) {
            this.setFlags((Slot)usernameAndPassword, 64);
            this.setFlags((Slot)sslVersion, 0);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
            this.getUsernameAndPassword().setUsername("");
            this.getUsernameAndPassword().setPassword(BPassword.DEFAULT);
            if (this.get(connectionType) != BMqttConnectionType.Anonymous) {
                this.setFlags((Slot)sslVersion, 0);
            } else {
                this.setFlags((Slot)sslVersion, 1);
            }
        }
    }

    @Override
    public void enableAndDisableFields(int flag) {
        this.device.enableAndDisableFields(flag);
        this.setFlags((Slot)brokerEndpoint, flag);
        this.setFlags((Slot)brokerPort, flag);
        this.setFlags((Slot)connectionType, flag);
        this.setFlags((Slot)clientID, flag | 0x40);
        if (this.getConnectionType() == BMqttConnectionType.UserLoginOverSSL && !((BAbstractMqttDevice)this.getDevice()).isClientConnectedToBroker()) {
            this.setFlags((Slot)usernameAndPassword, 64);
        } else {
            this.setFlags((Slot)usernameAndPassword, 65);
        }
        this.setFlags((Slot)sslVersion, flag);
    }

    public Property getCertificateAliasAndPasswordProperty(Context context) {
        return certificateAliasAndPassword;
    }

    public BPassword retrieveCertificatePassword(Property certAliasAndPasswordProperty, Context context) {
        BGenericMqttAuthenticator.certPropertyCheck(certAliasAndPasswordProperty);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SigningPasswordPermission(TYPE.getTypeSpec().getModuleName()));
        }
        return BPassword.make((String)AccessController.doPrivileged(() -> this.getCertificateAliasAndPassword().getPassword().getValue()));
    }

    public void certificateSigned(Property certAliasAndPasswordProperty, X509Certificate[] certificateChain, Context context) {
        BGenericMqttAuthenticator.certPropertyCheck(certAliasAndPasswordProperty);
        if (certificateChain.length > 0) {
            X509Certificate deviceCert = certificateChain[0];
            LOG.fine(() -> String.format("New Certificate [%s] obtained for device [%s], next expiry: [%s]", deviceCert.getSubjectX500Principal(), this.getDevice().getName(), deviceCert.getNotAfter()));
        }
    }

    public String supplyRecommendedCertificateAlias(String containerName, Context context) {
        return Sys.getStation().getStationName() + '-' + this.getDevice().getDisplayName(context);
    }

    private static void certPropertyCheck(Property certAliasAndPasswordProperty) {
        if (!certificateAliasAndPassword.equals(certAliasAndPasswordProperty)) {
            throw new IllegalArgumentException("Unexpected CertificateAliasAndPassword property argument: \"" + certAliasAndPasswordProperty + "\" != \"" + certificateAliasAndPassword + '\"');
        }
    }
}

