/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.generic.IGenericConnectionOptions;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.util.BMqttConnectionType;
import javax.baja.security.BPassword;
import javax.baja.sys.LocalizableRuntimeException;

public class MqttClientValidations {
    private static MqttClientValidations clientValidations = new MqttClientValidations();

    private MqttClientValidations() {
    }

    public static MqttClientValidations getMqttClientValidationsInstance() {
        return clientValidations;
    }

    public boolean validateConnectParams(BAbstractMqttDevice device, INiagaraMqttClient client) {
        if (client != null && client.isConnected()) {
            String message = BAbstractMqttDevice.lex.get("clientAlreadyConnectedConnectionError", null);
            device.setStatusMessage(message);
            return false;
        }
        return true;
    }

    public boolean validateDisconnectParams(BAbstractMqttDevice device, INiagaraMqttClient client) {
        if (client != null && !client.isConnected()) {
            String message = BAbstractMqttDevice.lex.get("clientAlreadyDisconnectedConnectionError");
            device.setStatusMessage(message);
            return false;
        }
        return true;
    }

    public boolean validateMQTTParams(BAbstractMqttDevice device, IGenericConnectionOptions options) {
        if (device == null) {
            throw new LocalizableRuntimeException("abstractMqttDriver", "nullBMqttClientDriverDeviceObject");
        }
        String brokerEndpoint = options.getBrokerEndpoint();
        boolean enableLogin = options.getConnectionType() == BMqttConnectionType.UserLoginOverSSL;
        String username = options.getUsernameAndPassword().getUsername();
        BPassword password = options.getUsernameAndPassword().getPassword();
        boolean enableLWT = ((BAbstractMqttDevice)options.getDevice()).getEnableLWT();
        String topicLWT = ((BAbstractMqttDevice)options.getDevice()).getTopicForLWT();
        String messageForLWT = ((BAbstractMqttDevice)options.getDevice()).getMessageForLWT();
        String clientId = options.getClientID();
        if (clientId == null || "".equals(clientId)) {
            String message = BAbstractMqttDevice.lex.get("emptyClientIdConnectionError");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "emptyClientIdConnectionError");
        }
        if (brokerEndpoint == null || "".equals(brokerEndpoint)) {
            String message = BAbstractMqttDevice.lex.get("emptyIpAddressConnectionError");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "emptyIpAddressConnectionError");
        }
        if (enableLogin) {
            if (username == null || "".equals(username)) {
                String message = BAbstractMqttDevice.lex.get("emptyUsernameConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyUsernameConnectionError");
            }
            if (password == BPassword.DEFAULT || password == null || "".equals(password) || password.isNull() || "".equals(password.getValue())) {
                String message = BAbstractMqttDevice.lex.get("emptyPasswordConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyPasswordConnectionError");
            }
        }
        if (enableLWT) {
            if (topicLWT == null || "".equals(topicLWT)) {
                String message = BAbstractMqttDevice.lex.get("emptyTopicForLWTConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyTopicForLWTConnectionError");
            }
            if (messageForLWT == null || "".equals(messageForLWT)) {
                String message = BAbstractMqttDevice.lex.get("emptyMessageForLWTForLWTConnectionError");
                device.setStatusMessage(message);
                throw new LocalizableRuntimeException("abstractMqttDriver", "emptyMessageForLWTForLWTConnectionError");
            }
        }
        if (device.getMqttClientDriverNetwork().clientIdExists(clientId)) {
            String message = BAbstractMqttDevice.lex.get("duplicateClientId");
            device.setStatusMessage(message);
            throw new LocalizableRuntimeException("abstractMqttDriver", "duplicateClientId");
        }
        return true;
    }
}

