/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.jwt;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.authenticator.gcp.BGcpAuthenticator;
import com.tridium.platcrypto.core.BCertManagerService;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public final class MqttConnectOptionBuilder {
    public static final String DEFAULT_USERNAME = "unused";

    private MqttConnectOptionBuilder() {
    }

    public static MqttConnectOptions build(BGcpAuthenticator authenticator) throws Exception {
        MqttConnectOptions options = new MqttConnectOptions();
        MqttConnectOptionBuilder.applyLoginOptions(authenticator, options);
        MqttConnectOptionBuilder.applyConnectOptions(authenticator, options);
        MqttConnectOptionBuilder.applyLwtOptions(authenticator.getMqttDevice(), options);
        return options;
    }

    private static void applyLoginOptions(BGcpAuthenticator auth, MqttConnectOptions options) throws Exception {
        options.setUserName(DEFAULT_USERNAME);
        auth.getTokenParameters().addTokenAsPassword(options);
        ICryptoManager cryptoManager = CertManagerFactory.getInstance();
        if (cryptoManager instanceof BCertManagerService) {
            BCertManagerService certManagerService = (BCertManagerService)cryptoManager;
            ClientTlsParameters tlsParameters = new ClientTlsParameters(auth.getSslVersion().getTag());
            SocketFactory socketFactory = certManagerService.getClientSocketFactory(tlsParameters);
            options.setSocketFactory(socketFactory);
        }
    }

    private static void applyConnectOptions(BGcpAuthenticator auth, MqttConnectOptions options) {
        BAbstractMqttDevice device = auth.getMqttDevice();
        options.setCleanSession(device.getCleanSession());
        options.setConnectionTimeout(device.getConnectionTimeout());
        options.setKeepAliveInterval(device.getKeepAlive());
        options.setMaxInflight(auth.getMaxInFlight());
    }

    private static void applyLwtOptions(BAbstractMqttDevice device, MqttConnectOptions options) {
        if (device.getEnableLWT()) {
            options.setWill(device.getTopicForLWT(), device.getMessageForLWT().getBytes(), device.getQosForLWT().getOrdinal(), device.getRetainedForLWT());
        }
    }
}

