/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util;

import com.tridium.mqttClientDriver.BAbstractMqttDriverDevice;
import com.tridium.mqttClientDriver.clients.INiagaraMqttClient;
import com.tridium.mqttClientDriver.clients.MqttClientValidationsDriverDevice;
import com.tridium.mqttClientDriver.clients.paho.MqttClientPahoDriverDevice;
import com.tridium.mqttClientDriver.util.SupportedClientEnum;
import java.util.concurrent.Future;

public class MqttClientFactory {
    public static INiagaraMqttClient getClient(final BAbstractMqttDriverDevice device) {
        SupportedClientEnum clientType = device.getSupportedClient();
        switch (clientType) {
            case PAHO: {
                return new MqttClientPahoDriverDevice(device);
            }
            case TEST_CLIENT: {
                return new INiagaraMqttClient(){
                    boolean val;
                    boolean isConnected;
                    {
                        this.val = MqttClientValidationsDriverDevice.getMqttClientValidationsInstance().validateMQTTParams(device);
                        this.isConnected = false;
                    }

                    @Override
                    public void unsubscribe(String topic) throws Exception {
                    }

                    @Override
                    public void subscribe(String topic, int qos) throws Exception {
                    }

                    @Override
                    public Future<String> publish(String topic, int qos, String message, boolean retained) throws Exception {
                        return null;
                    }

                    @Override
                    public boolean isConnected() {
                        return this.isConnected;
                    }

                    @Override
                    public void subscribe(String[] topics, int[] qosList) throws Exception {
                    }

                    @Override
                    public void unsubscribe(String[] topicsArray) throws Exception {
                    }

                    public String generateClientId() {
                        return "1233";
                    }

                    @Override
                    public void disconnect() throws Exception {
                        this.isConnected = false;
                    }

                    @Override
                    public void connect() throws Exception {
                        this.isConnected = true;
                    }
                };
            }
        }
        return null;
    }
}

