/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.property;

import com.tridium.ui.px.PxPropertyComponent;
import com.tridium.ui.px.PxPropertyComponentArray;
import com.tridium.ui.px.Target;
import com.tridium.ui.px.TargetArray;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.px.PxProperty;

public abstract class PxPropertyUtil {
    public static void insert(BPxEditor editor, int index, PxProperty prop, CommandArtifact removalArtifact) {
        ArrayList<PxProperty> arr = new ArrayList<PxProperty>(Arrays.asList(editor.getPxProperties()));
        arr.add(index, prop);
        editor.setPxProperties(arr.toArray(new PxProperty[0]));
        if (removalArtifact != null) {
            try {
                removalArtifact.undo();
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    public static CommandArtifact remove(BPxEditor editor, PxProperty prop, PxPropertyComponentArray cs) {
        ArrayList<PxProperty> arr = new ArrayList<PxProperty>(Arrays.asList(editor.getPxProperties()));
        arr.remove(prop);
        editor.setPxProperties(arr.toArray(new PxProperty[0]));
        Artifact artifact = new Artifact(prop, cs);
        try {
            artifact.redo();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return artifact;
    }

    private static class Artifact
    implements CommandArtifact {
        private PxProperty prop;
        private PxPropertyComponentArray cs;
        private RemovedTarget[] removedTargets;
        private PxPropertyComponent[] removedComponents;

        private Artifact(PxProperty prop, PxPropertyComponentArray cs) {
            this.prop = prop;
            this.cs = cs;
        }

        public void redo() throws Exception {
            ArrayList<RemovedTarget> rt = new ArrayList<RemovedTarget>();
            ArrayList<PxPropertyComponent> rc = new ArrayList<PxPropertyComponent>();
            int n = 0;
            while (n < this.cs.size()) {
                PxPropertyComponent gc = this.cs.get(n);
                TargetArray ts = gc.getTargets();
                if (ts.hasProperty(this.prop)) {
                    Target[] t = ts.forProperty(this.prop);
                    ts.removeAll(t);
                    rt.add(new RemovedTarget(ts, t));
                    if (ts.size() == 0) {
                        this.cs.remove(n);
                        rc.add(gc);
                        continue;
                    }
                }
                ++n;
            }
            this.removedTargets = rt.toArray(new RemovedTarget[0]);
            this.removedComponents = rc.toArray(new PxPropertyComponent[0]);
        }

        public void undo() throws Exception {
            int i;
            for (i = 0; i < this.removedTargets.length; ++i) {
                TargetArray ts = this.removedTargets[i].ts;
                Target[] t = this.removedTargets[i].t;
                ts.addAll(t);
            }
            for (i = 0; i < this.removedComponents.length; ++i) {
                this.cs.add(this.removedComponents[i]);
            }
        }

        private static class RemovedTarget {
            private TargetArray ts;
            private Target[] t;

            private RemovedTarget(TargetArray ts, Target[] t) {
                this.ts = ts;
                this.t = t;
            }
        }
    }
}

