/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.binding;

import com.tridium.json.JSONObject;
import com.tridium.px.editor.BPxEditorOptions;
import com.tridium.px.editor.sidebars.binding.BNeqlizeOptionsEditor;
import com.tridium.px.editor.sidebars.binding.BNeqlizeOrdEditor;
import com.tridium.px.editor.sidebars.binding.BOrdChanger;
import com.tridium.ui.theme.Theme;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.entityIo.json.JsonEntityDecoder;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.px.editor.BPxEditor;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tag.util.TagSet;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;

@NiagaraType
public class BNeqlizeOrds
extends BOrdChanger {
    @Generated
    public static final Type TYPE = Sys.loadType(BNeqlizeOrds.class);
    private final BPxEditorOptions pxEditorOptions;
    private final BComponent baseComponent;
    private Collection<Relation> baseRelations;
    private final BOrd[] path;
    private final Map<BOrd, NeqlizeData> neqlizeDataMap = new HashMap<BOrd, NeqlizeData>();
    private static final int PATH_COLUMN = 3;
    private static final double DEFAULT_MAX_COLUMN_WIDTH = 400.0;
    private static final Logger LOGGER = Logger.getLogger("pxEditor");
    private static final Tags EMPTY_TAGS = new TagSet();
    private static final boolean USE_LABEL = true;
    private static final boolean USE_ICON = true;
    private static final Pattern STARTS_WITH_NEQL = Pattern.compile("^neql:");
    private static final Pattern ENDS_WITH_SINGLE = Pattern.compile("\\|single:(.*)$");
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        @Override
        public int read() {
            return -1;
        }
    };
    private static final JsonEntityDecoder ENTITY_DECODER = new JsonEntityDecoder(EMPTY_INPUT_STREAM);
    private static final BOrd ENTITY_RPC_ORD = BOrd.make((String)"type:entityIo:EntityRpc");
    private static final String ENTITY_RPC_METHOD = "getEntityInfo";
    private static final Map<String, Boolean> RETRIEVE_RELATIONS_OPTIONS = BNeqlizeOrds.makeRetrieveRelationsOptions();
    private static final BOrd NEQLIZE_RPC_ORD = BOrd.make((String)"type:tagdictionary:NeqlizeRpc");
    private static final String NEQLIZE_RPC_METHOD = "getIdentifyingTagsRelations";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNeqlizeOrds(BPxEditor editor, BOrd[] before, BComponent baseComponent) {
        super(editor, before);
        this.baseComponent = baseComponent;
        this.path = new BOrd[before.length];
        this.pxEditorOptions = BPxEditorOptions.make();
        this.buildTopPane();
        this.table.setModel((TableModel)new NeqlizeModel());
        this.table.setController((TableController)new NeqlizeController());
        this.table.setCellRenderer((TableCellRenderer)new NeqlizeRenderer());
    }

    private void buildTopPane() {
        BGridPane gridPane = new BGridPane(2);
        gridPane.setColumnGap(10.0);
        gridPane.setColumnAlign(BHalign.right);
        gridPane.setStretchColumn(1);
        gridPane.add(null, (BValue)new BButton((Command)new OpenOptionsEditorCommand(), true, false));
        gridPane.add(null, (BValue)new BButton((Command)new RefreshAllCommand(), true, false));
        this.edge.setTop((BWidget)new BBorderPane((BWidget)gridPane, 10.0, 10.0, 10.0, 10.0));
    }

    @Override
    protected void init() {
        this.totalColumns = 4;
        for (int i = 0; i < this.before.length; ++i) {
            NeqlizeData data = this.resolveBeforeOrd(this.before[i]);
            this.neqlizeDataMap.put(this.before[i], data);
            if (data.component != null) {
                this.path[i] = data.component.getSlotPathOrd();
            }
            this.selectIfSelectable(i, !this.before[i].toString().trim().startsWith("neql:"));
        }
        this.baseRelations = this.retrieveRelations();
    }

    private NeqlizeData resolveBeforeOrd(BOrd beforeOrd) {
        NeqlizeData data = new NeqlizeData();
        try {
            OrdTarget target = beforeOrd.resolve((BObject)this.baseComponent, this.editor.getCurrentContext());
            data.component = BNeqlizeOrds.getComponent(target);
            if (data.component != null) {
                Slot slot;
                Property[] slots = target.getPropertyPathInComponent();
                if (slots == null && (slot = target.getSlotInComponent()) != null) {
                    slots = new Slot[]{slot};
                }
                data.slots = slots;
                data.viewQuery = target.getViewQuery();
                String beforeOrdString = beforeOrd.toString().trim();
                if (beforeOrdString.startsWith("neql:")) {
                    data.userQuery = BNeqlizeOrds.extractNEQLQuery(beforeOrdString);
                }
            } else {
                data.errorMessage = "neqlizeOrds.resolvedButNotComponentBeforeOrd";
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Error resolving " + beforeOrd + " for NeqlizeOrds dialog", e);
            } else {
                LOGGER.severe("Error resolving " + beforeOrd + " for NeqlizeOrds dialog");
            }
            data.component = null;
            data.errorMessage = "neqlizeOrds.problemResolvingBeforeOrd";
        }
        return data;
    }

    public boolean refresh(boolean initSelections) throws Exception {
        Optional<Map<String, Object>> result = this.runNeqlizeRpc();
        if (!result.isPresent()) {
            BDialog.error((BWidget)this.getOwner(), (String)lexicon.getText("neqlizeOrds.conversionError.title"), (Object)lexicon.getText("neqlizeOrds.conversionError.message"));
            return false;
        }
        JSONObject conversionResults = new JSONObject(result.get());
        if (LOGGER.isLoggable(Level.FINE)) {
            BNeqlizeOrds.logResults(conversionResults);
        }
        this.processConversionResults(conversionResults, !initSelections);
        this.updateAfterOrds(initSelections);
        return true;
    }

    private void processConversionResults(JSONObject conversionResults, boolean resetUserQuery) {
        for (int i = 0; i < this.before.length; ++i) {
            this.processConversionResult(conversionResults, this.before[i], resetUserQuery && this.selected[i]);
        }
    }

    private void processConversionResult(JSONObject conversionResults, BOrd beforeOrd, boolean resetUserQuery) {
        JSONObject tags;
        NeqlizeData data = this.neqlizeDataMap.get(beforeOrd);
        if (data.component == null) {
            return;
        }
        if (resetUserQuery) {
            data.userQuery = null;
        }
        data.queryRelation = null;
        data.queryTags = null;
        JSONObject ordConversionResult = conversionResults.optJSONObject(beforeOrd.toString());
        if (ordConversionResult == null) {
            data.errorMessage = "neqlizeOrds.ordConversionNotFound";
            return;
        }
        if (ordConversionResult.has("error")) {
            String errorType;
            switch (errorType = ordConversionResult.optString("error")) {
                case "noTagSetFound": {
                    data.errorMessage = "neqlizeOrds.noTagsFound";
                    return;
                }
                case "notEndpointOrDescendant": {
                    data.errorMessage = "neqlizeOrds.notEndpointOrDescendant";
                    return;
                }
            }
            data.errorMessage = "neqlizeOrds.ordConversionError";
            return;
        }
        String relationId = ordConversionResult.optString("relationId");
        boolean relationIsInbound = ordConversionResult.optBoolean("relationIsInbound");
        if (relationId != null && !relationId.isEmpty()) {
            try {
                BasicRelation ordRelation = new BasicRelation(Id.newId((String)relationId), beforeOrd, EMPTY_TAGS, relationIsInbound);
                data.queryRelation = ordRelation;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to convert relation ID (" + relationId + ") returned by NeqlizeRpc for " + beforeOrd, e);
                data.errorMessage = "neqlizeOrds.ordConversionError";
                return;
            }
        }
        if ((tags = ordConversionResult.optJSONObject("tags")) == null) {
            if (data.queryRelation == null) {
                LOGGER.log(Level.WARNING, "No tags returned by NeqlizeRpc for " + beforeOrd + " when relation is not supplied");
                data.errorMessage = "neqlizeOrds.noTagsFound";
                return;
            }
        } else {
            try {
                data.queryTags = ENTITY_DECODER.decodeTags(tags).getAll();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to decode tags returned by NeqlizeRpc", e);
                data.queryRelation = null;
                data.errorMessage = "neqlizeOrds.ordConversionError";
                return;
            }
        }
        data.errorMessage = null;
        if (beforeOrd.equals((Object)BNeqlizeOrds.makeAfterOrd(data, false))) {
            data.userQuery = null;
        }
    }

    private void updateAfterOrds(boolean initSelections) {
        for (int i = 0; i < this.before.length; ++i) {
            boolean select = initSelections ? !this.before[i].toString().trim().startsWith("neql:") : this.selected[i];
            this.selectIfSelectable(i, select);
            this.updateAfterOrd(i);
        }
        this.repaint();
    }

    private void updateAfterOrd(int index) {
        this.after[index] = this.selected[index] ? this.after(this.before[index]) : this.before[index];
    }

    private static BComponent getComponent(OrdTarget target) {
        return target.getSpace() instanceof BComponentSpace ? target.getComponent() : null;
    }

    private static String extractNEQLQuery(String query) {
        return ENDS_WITH_SINGLE.matcher(STARTS_WITH_NEQL.matcher(query).replaceFirst("")).replaceFirst("");
    }

    private static void logResults(JSONObject result) {
        LOGGER.fine("Tag-Based Ord Conversion results (key, value):");
        Iterator keys = result.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject ordResult = result.optJSONObject(key);
            if (ordResult != null) {
                LOGGER.fine("  " + key + ", " + ordResult);
                continue;
            }
            LOGGER.fine("  Key = " + key + " is not a JSONObject");
        }
    }

    public NeqlizeData getNeqlizeData(BOrd ord) {
        return this.neqlizeDataMap.get(ord);
    }

    private Optional<Map<String, Object>> runNeqlizeRpc() throws Exception {
        if (this.before == null || this.before.length == 0 || this.pxEditorOptions == null) {
            return Optional.empty();
        }
        ArrayList<String> boundOrdStrings = new ArrayList<String>();
        for (BOrd beforeOrd : this.before) {
            NeqlizeData data = this.neqlizeDataMap.get(beforeOrd);
            if (data == null || data.component == null) continue;
            boundOrdStrings.add(beforeOrd.toString());
        }
        JSONObject options = this.buildOptionsJSON();
        return this.callNeqlizeRpc(this.baseComponent, boundOrdStrings, options);
    }

    private JSONObject buildOptionsJSON() {
        JSONObject options = new JSONObject().put("mode", (Object)this.pxEditorOptions.getNeqlizeMode().getTag()).put("useServiceExcludedRelations", this.pxEditorOptions.getUseServiceExcludedRelations()).put("excludedRelations", (Object)this.pxEditorOptions.getNeqlizeExcludedRelations()).put("useServiceExcludedTags", this.pxEditorOptions.getUseServiceExcludedTags()).put("excludedTags", (Object)this.pxEditorOptions.getNeqlizeExcludedTags());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Neqlize Options = " + options.toString(2));
        }
        return options;
    }

    public Optional<Map<String, Object>> callNeqlizeRpc(BComponent baseComponent, List<String> boundOrdStrings, JSONObject options) throws Exception {
        BFoxProxySession session = (BFoxProxySession)baseComponent.getSession();
        return session.rpc(NEQLIZE_RPC_ORD, NEQLIZE_RPC_METHOD, new Object[]{baseComponent.getSlotPath().toString(), boundOrdStrings, options.toString()});
    }

    private Collection<Relation> retrieveRelations() {
        BFoxProxySession session = (BFoxProxySession)this.baseComponent.getSession();
        try {
            Optional rpcResponse = session.rpc(ENTITY_RPC_ORD, ENTITY_RPC_METHOD, new Object[]{this.baseComponent.getOrdInSession().encodeToString(), RETRIEVE_RELATIONS_OPTIONS});
            if (rpcResponse.isPresent()) {
                Entity entity = JsonEntityDecoder.decodeFromString((String)((String)rpcResponse.get()));
                return entity.relations().getAll();
            }
        }
        catch (IOException e) {
            LOGGER.severe("Decoding NeqlizeOrds base component relations retrieval response failed: " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.severe("NeqlizeOrds base component relations retrieval failed: " + e.getMessage());
        }
        LOGGER.warning("Could not retrieve relations for the PX view's component");
        BDialog.error((BWidget)this.getOwner(), (String)lexicon.getText("neqlizeOrds.baseRelationsRetrievalError.title"), (Object)lexicon.getText("neqlizeOrds.baseRelationsRetrievalError.message", new Object[]{this.baseComponent.getSlotPath()}));
        return Collections.emptyList();
    }

    private boolean isRowValid(int row) {
        return this.getDisplayedErrorForRow(row) == null;
    }

    private String getDisplayedErrorForRow(int row) {
        NeqlizeData data = this.neqlizeDataMap.get(this.before[row]);
        if (data.errorMessage != null) {
            return lexicon.getText(data.errorMessage);
        }
        return null;
    }

    public static BOrd makeAfterOrd(NeqlizeData data, boolean considerUserQuery) {
        BOrd query;
        String userQuery;
        if (data.errorMessage != null) {
            return BOrd.NULL;
        }
        String string = userQuery = considerUserQuery && data.userQuery != null ? data.userQuery.trim() : "";
        if (!userQuery.isEmpty()) {
            query = BOrd.make((String)("neql:" + userQuery));
        } else {
            String neqlQuery = BNeqlizeOrdEditor.makeNeqlizeQuery(data.queryRelation, data.queryTags);
            if (neqlQuery == null || neqlQuery.isEmpty()) {
                return null;
            }
            query = BOrd.make((String)("neql:" + neqlQuery));
        }
        return BOrd.make((BOrd)query, (BOrd)BNeqlizeOrds.getSuffix(data));
    }

    public static BOrd getSuffix(NeqlizeData data) {
        BOrd suffix = BOrd.make((String)"single:");
        if (data.slots != null && data.slots.length > 0) {
            StringJoiner sj = new StringJoiner("/", "slot:", "");
            for (Slot slot : data.slots) {
                sj.add(slot.getName());
            }
            suffix = BOrd.make((BOrd)suffix, (String)sj.toString());
        }
        if (data.viewQuery != null) {
            suffix = BOrd.make((BOrd)suffix, (String)data.viewQuery.toString());
        }
        return suffix;
    }

    @Override
    protected BOrd after(BOrd oldOrd) {
        NeqlizeData data = this.neqlizeDataMap.get(oldOrd);
        BOrd newOrd = BNeqlizeOrds.makeAfterOrd(data, true);
        if (newOrd == null || newOrd == BOrd.NULL) {
            return oldOrd;
        }
        return newOrd;
    }

    @Override
    protected boolean selectable(int row) {
        return this.isRowValid(row);
    }

    protected boolean canEditRow(int row) {
        NeqlizeData data = this.neqlizeDataMap.get(this.before[row]);
        return data.component != null;
    }

    private NeqlizeData resolveAndValidateAfterOrd(NeqlizeData data) {
        data.errorMessage = null;
        BOrd afterOrd = BNeqlizeOrds.makeAfterOrd(data, true);
        if (afterOrd == null || afterOrd.equals((Object)BOrd.NULL)) {
            data.errorMessage = "neqlizeOrds.problemResolvingAfterOrd";
            LOGGER.warning("After Ord " + afterOrd + " is null");
            return data;
        }
        try {
            OrdTarget target = afterOrd.resolve((BObject)this.baseComponent, this.editor.getCurrentContext());
            BComponent afterComponent = BNeqlizeOrds.getComponent(target);
            BComponent beforeComponent = data.component;
            if (afterComponent == null) {
                LOGGER.warning("After Ord " + afterOrd + " did not resolve to a component");
                data.errorMessage = "neqlizeOrds.afterResolutionValueNotMatchBefore";
            } else if (!afterComponent.equals((Object)beforeComponent)) {
                LOGGER.warning("After Ord " + afterOrd + " resolved to " + afterComponent.getSlotPath() + " instead of Before Ord Component " + beforeComponent.getSlotPath());
                data.errorMessage = "neqlizeOrds.afterResolutionValueNotMatchBefore";
            }
        }
        catch (Exception e) {
            data.errorMessage = "neqlizeOrds.problemResolvingAfterOrd";
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception resolving edited After Ord: " + afterOrd, e);
            }
            LOGGER.warning("Exception resolving edited After Ord: " + afterOrd);
        }
        return data;
    }

    private static Map<String, Boolean> makeRetrieveRelationsOptions() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("jsonEntityEncoderShouldEncodeRelations", true);
        options.put("jsonEntityEncoderShouldEncodeTags", false);
        return options;
    }

    public static class NeqlizeData {
        public BComponent component;
        public Collection<Tag> queryTags;
        public Relation queryRelation;
        public Slot[] slots;
        public ViewQuery viewQuery;
        public String userQuery;
        public String errorMessage;
    }

    private class RefreshRowCommand
    extends Command {
        private final int row;

        RefreshRowCommand(BTable table, int row) {
            super((BWidget)table, BOrdChanger.lexicon, "neqlizeOrds.refreshRow");
            this.row = row;
            this.setEnabled(BNeqlizeOrds.this.canEditRow(row));
        }

        public CommandArtifact doInvoke() throws Exception {
            BOrd beforeOrd = BNeqlizeOrds.this.before[this.row];
            List<String> ordStrings = Collections.singletonList(beforeOrd.toString());
            JSONObject options = BNeqlizeOrds.this.buildOptionsJSON();
            Optional<Map<String, Object>> neqlizeRpcResult = BNeqlizeOrds.this.callNeqlizeRpc(BNeqlizeOrds.this.baseComponent, ordStrings, options);
            if (!neqlizeRpcResult.isPresent()) {
                BDialog.error((BWidget)this.getOwner(), (String)BOrdChanger.lexicon.getText("boundOrds.conversionError.title"), (Object)BOrdChanger.lexicon.getText("boundOrds.conversionError.message"));
                return null;
            }
            JSONObject conversionResults = new JSONObject(neqlizeRpcResult.get());
            if (LOGGER.isLoggable(Level.FINE)) {
                BNeqlizeOrds.logResults(conversionResults);
            }
            BNeqlizeOrds.this.processConversionResult(conversionResults, beforeOrd, true);
            NeqlizeData data = (NeqlizeData)BNeqlizeOrds.this.neqlizeDataMap.get(beforeOrd);
            BNeqlizeOrds.this.selectIfSelectable(this.row, data.errorMessage == null);
            BNeqlizeOrds.this.updateAfterOrd(this.row);
            BNeqlizeOrds.this.repaint();
            return null;
        }
    }

    private class RefreshAllCommand
    extends Command {
        public RefreshAllCommand() {
            super((BWidget)BNeqlizeOrds.this, TYPE.getModule(), "neqlizeOrds.refresh");
        }

        public CommandArtifact doInvoke() {
            try {
                if (BNeqlizeOrds.this.refresh(false)) {
                    BNeqlizeOrds.this.repaint();
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException(BOrdChanger.lexicon.getText("boundOrds.conversionFailed"), (Throwable)e);
            }
            return null;
        }
    }

    private class OpenOptionsEditorCommand
    extends Command {
        public OpenOptionsEditorCommand() {
            super((BWidget)BNeqlizeOrds.this, TYPE.getModule(), "neqlizeOrds.options");
        }

        public CommandArtifact doInvoke() throws Exception {
            BNeqlizeOptionsEditor.open((BWidget)BNeqlizeOrds.this, BNeqlizeOrds.this.pxEditorOptions, (BFoxProxySession)BNeqlizeOrds.this.baseComponent.getSession());
            return null;
        }
    }

    private class EditOrdCommand
    extends Command {
        private final int row;

        EditOrdCommand(BTable table, int row) {
            super((BWidget)table, BOrdChanger.lexicon, "neqlizeOrds.editNeqlOrd");
            this.setEnabled(BNeqlizeOrds.this.canEditRow(row));
            this.row = row;
        }

        public CommandArtifact doInvoke() {
            BNeqlizeOrdEditor ordEditor = new BNeqlizeOrdEditor();
            NeqlizeData data = (NeqlizeData)BNeqlizeOrds.this.neqlizeDataMap.get(BNeqlizeOrds.this.before[this.row]);
            String userQuery = data.userQuery;
            ordEditor.init(data.component, BNeqlizeOrds.this.baseRelations, data.queryRelation, data.queryTags, userQuery);
            int result = BDialog.open((BWidget)this.getShell(), (String)BOrdChanger.lexicon.getText("neqlizeOrds.editNeqlOrd.title"), (Object)((Object)ordEditor), (int)3);
            if (result == 1) {
                data.userQuery = ordEditor.getUserQuery();
                data.queryRelation = ordEditor.getQueryRelation();
                data.queryTags = ordEditor.getQueryTags();
                BNeqlizeOrds.this.neqlizeDataMap.put(BNeqlizeOrds.this.before[this.row], BNeqlizeOrds.this.resolveAndValidateAfterOrd(data));
                BNeqlizeOrds.this.after[this.row] = BNeqlizeOrds.this.after(BNeqlizeOrds.this.before[this.row]);
                BNeqlizeOrds.this.selectIfSelectable(this.row, data.errorMessage == null);
                BNeqlizeOrds.this.repaint();
            }
            return null;
        }
    }

    private class NeqlizeController
    extends BOrdChanger.Controller {
        private NeqlizeController() {
        }

        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            menu.add("editOrd", (Command)new EditOrdCommand(BNeqlizeOrds.this.table, subject.getActiveRow()));
            menu.add("refreshRow", (Command)new RefreshRowCommand(BNeqlizeOrds.this.table, subject.getActiveRow()));
            return menu;
        }
    }

    private class NeqlizeRenderer
    extends BOrdChanger.Renderer {
        private NeqlizeRenderer() {
        }

        @Override
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == BNeqlizeOrds.this.afterColumn) {
                return this.getWidthForText(BNeqlizeOrds.this.after[cell.row].toString());
            }
            if (cell.column == BNeqlizeOrds.this.beforeColumn) {
                return this.getWidthForText(BNeqlizeOrds.this.before[cell.row].toString());
            }
            if (cell.column == 3) {
                return this.getWidthForText(BNeqlizeOrds.this.table.getModel().getValueAt(cell.row, cell.column).toString());
            }
            return super.getPreferredCellWidth(cell);
        }

        private double getWidthForText(String text) {
            double width = Theme.table().getCellFont().width(text) + 12.0;
            return Math.min(400.0, width);
        }
    }

    private class NeqlizeModel
    extends BOrdChanger.Model {
        private NeqlizeModel() {
        }

        @Override
        public String getColumnName(int col) {
            if (col == 3) {
                return BOrdChanger.text("neqlizeOrds.path");
            }
            return super.getColumnName(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 3) {
                String rowError = BNeqlizeOrds.this.getDisplayedErrorForRow(row);
                return rowError != null ? rowError : BNeqlizeOrds.this.path[row];
            }
            return super.getValueAt(row, col);
        }
    }
}

