/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.binding;

import com.tridium.px.editor.util.EventUtil;
import java.util.ArrayList;
import javax.baja.naming.BOrd;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;

class ChangeOrds
extends Command {
    BPxEditor editor;
    Entry[] entries;

    ChangeOrds(BPxEditor editor, Entry[] entries) {
        super((BWidget)editor, Lexicon.make((String)"pxEditor"), "commands.changeOrds");
        this.editor = editor;
        this.entries = entries;
    }

    public CommandArtifact doInvoke() throws Exception {
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    static class Entry {
        BComponent component;
        Property prop;
        BOrd oldOrd;
        BOrd newOrd;

        Entry(BComponent component, Property prop, BOrd oldOrd, BOrd newOrd) {
            this.component = component;
            this.prop = prop;
            this.oldOrd = oldOrd;
            this.newOrd = newOrd;
        }
    }

    private class Artifact
    implements CommandArtifact {
        Entry[] bindingEntries;
        Entry[] widgetEntries;

        Artifact() {
            ArrayList<Entry> bindingArray = new ArrayList<Entry>();
            ArrayList<Entry> widgetArray = new ArrayList<Entry>();
            for (int i = 0; i < ChangeOrds.this.entries.length; ++i) {
                if (ChangeOrds.this.entries[i].component instanceof BBinding) {
                    bindingArray.add(ChangeOrds.this.entries[i]);
                    continue;
                }
                if (!(ChangeOrds.this.entries[i].component instanceof BWidget)) continue;
                widgetArray.add(ChangeOrds.this.entries[i]);
            }
            this.bindingEntries = bindingArray.toArray(new Entry[0]);
            this.widgetEntries = widgetArray.toArray(new Entry[0]);
        }

        public void redo() throws Exception {
            Entry e;
            int i;
            String[] props;
            if (this.bindingEntries.length > 0) {
                props = new String[this.bindingEntries.length];
                BBinding[] bindings = new BBinding[this.bindingEntries.length];
                for (i = 0; i < this.bindingEntries.length; ++i) {
                    e = this.bindingEntries[i];
                    e.component.set(e.prop, (BValue)e.newOrd);
                    props[i] = e.prop.getName();
                    bindings[i] = (BBinding)e.component;
                }
                ChangeOrds.this.editor.firePxEvent(EventUtil.bindingsChanged(bindings, props));
            }
            if (this.widgetEntries.length > 0) {
                props = new String[this.widgetEntries.length];
                BWidget[] widgets = new BWidget[this.widgetEntries.length];
                for (i = 0; i < this.widgetEntries.length; ++i) {
                    e = this.widgetEntries[i];
                    e.component.set(e.prop, (BValue)e.newOrd);
                    props[i] = e.prop.getName();
                    widgets[i] = (BWidget)e.component;
                }
                ChangeOrds.this.editor.firePxEvent(EventUtil.widgetsChanged(widgets, props));
            }
        }

        public void undo() throws Exception {
            Entry e;
            int i;
            String[] props;
            if (this.bindingEntries.length > 0) {
                props = new String[this.bindingEntries.length];
                BBinding[] bindings = new BBinding[this.bindingEntries.length];
                for (i = 0; i < this.bindingEntries.length; ++i) {
                    e = this.bindingEntries[i];
                    e.component.set(e.prop, (BValue)e.oldOrd);
                    props[i] = e.prop.getName();
                    bindings[i] = (BBinding)e.component;
                }
                ChangeOrds.this.editor.firePxEvent(EventUtil.bindingsChanged(bindings, props));
            }
            if (this.widgetEntries.length > 0) {
                props = new String[this.widgetEntries.length];
                BWidget[] widgets = new BWidget[this.widgetEntries.length];
                for (i = 0; i < this.widgetEntries.length; ++i) {
                    e = this.widgetEntries[i];
                    e.component.set(e.prop, (BValue)e.oldOrd);
                    props[i] = e.prop.getName();
                    widgets[i] = (BWidget)e.component;
                }
                ChangeOrds.this.editor.firePxEvent(EventUtil.widgetsChanged(widgets, props));
            }
        }
    }
}

