/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.propsheet;

import com.tridium.px.editor.sidebars.propsheet.BPxPropSheet;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BTypeSpecFE;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

class AddPxProperty
extends Command
implements ObjectUtil.NameContainer {
    private static BTypeSpec lastType = BTypeSpec.make((String)"gx", (String)"Brush");
    private static String lastName = "newProp";
    private static final Lexicon lex = Lexicon.make((String)"pxEditor");
    private static final String alreadyExists = lex.getText("pxPropSheet.alreadyExists");
    private BPxPropSheet sheet;

    AddPxProperty(BPxPropSheet sheet) {
        super((BWidget)sheet, Lexicon.make((String)"pxEditor"), "commands.add");
        this.sheet = sheet;
        this.setEnabled(!sheet.readonly);
    }

    public boolean contains(String name) {
        PxProperty[] props = this.sheet.editor.getPxProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public CommandArtifact doInvoke() throws Exception {
        String newName = ObjectUtil.generateUniqueName((String)lastName, (ObjectUtil.NameContainer)this);
        BTextField nameEditor = new BTextField(newName, 25);
        BGridPane nameInner = new BGridPane();
        nameInner.setHalign(BHalign.left);
        nameInner.add(null, (BValue)nameEditor);
        BBorderPane namePane = new BBorderPane((BWidget)nameInner, "Name");
        BTypeSpecFE typeEditor = new BTypeSpecFE();
        BFacets facets = BFacets.make((String)"allowNull", (BIDataValue)BBoolean.FALSE, (String)"targetType", (BIDataValue)BString.make((String)"baja:Simple"), (String)"showAbstract", (BIDataValue)BBoolean.FALSE);
        typeEditor.loadValue((BObject)lastType, (Context)facets);
        BGridPane typeInner = new BGridPane();
        typeInner.setHalign(BHalign.left);
        typeInner.add(null, (BValue)typeEditor);
        BBorderPane typePane = new BBorderPane((BWidget)typeInner, "Type");
        BGridPane pane = new BGridPane(1);
        pane.setColumnAlign(BHalign.fill);
        pane.add(null, (BValue)namePane);
        pane.add(null, (BValue)typePane);
        String title = this.getLabel();
        int buttons = 3;
        if (BDialog.open((BWidget)this.sheet, (String)title, (Object)pane, (int)buttons, null) == 2) {
            return null;
        }
        lastName = nameEditor.getText();
        newName = SlotPath.escape((String)nameEditor.getText());
        BTypeSpec typeSpec = lastType = (BTypeSpec)typeEditor.saveValue();
        BValue value = (BValue)typeSpec.getInstance();
        final PxProperty[] props = this.sheet.editor.getPxProperties();
        for (int i = 0; i < props.length; ++i) {
            PxProperty p = props[i];
            if (!p.getName().equals(newName)) continue;
            BDialog.error((BWidget)this.sheet, (String)title, (Object)alreadyExists);
            return null;
        }
        final PxProperty newProp = new PxProperty(newName, typeSpec, value, new SlotPath[0]);
        CommandArtifact af = new CommandArtifact(){

            public void redo() throws Exception {
                AddPxProperty.this.sheet.insertProperty(props.length, newProp, null);
            }

            public void undo() throws Exception {
                AddPxProperty.this.sheet.removeProperty(props.length);
            }
        };
        af.redo();
        return af;
    }
}

