/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class ArcTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.ArcTo n = (IPathGeom.ArcTo)seg;
        return new Point(n.getX(), n.getY());
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.ArcTo arc = (IPathGeom.ArcTo)seg;
        return new IPathGeom.ArcTo(arc.isAbsolute(), arc.getRadiusX() + dx, arc.getRadiusY() + dy, arc.getXAxisRotation(), arc.getLargeArcFlag(), arc.getSweepFlag(), arc.getX() + dx, arc.getY() + dy);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.ArcTo arc = (IPathGeom.ArcTo)seg;
        Point next = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getX(), arc.getY());
        Point rad = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getRadiusX(), arc.getRadiusY());
        Point h = studio.translateToRoot((BWidget)path, new Point(rad.x, rad.y));
        Point a = studio.translateToRoot((BWidget)path, new Point(pen.x, pen.y));
        Point b = studio.translateToRoot((BWidget)path, new Point(next.x, next.y));
        g.setBrush(BColor.fuchsia);
        g.strokeLine(a.x, a.y, h.x, h.y);
        g.strokeLine(b.x, b.y, h.x, h.y);
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.ArcTo arc = (IPathGeom.ArcTo)seg;
        Point next = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getX(), arc.getY());
        Point rad = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getRadiusX(), arc.getRadiusY());
        ArcTo.paintHandle(g, studio, path, next, BColor.lime);
        ArcTo.paintHandle(g, studio, path, rad, BColor.fuchsia);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.ArcTo arc = (IPathGeom.ArcTo)seg;
        Point next = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getX(), arc.getY());
        Point rad = ArcTo.nextPoint(pen, arc.isAbsolute(), arc.getRadiusX(), arc.getRadiusY());
        ArcTo.addHandle(studio, path, next, map, MouseCursor.move, new Next(idx, next, arc));
        ArcTo.addHandle(studio, path, rad, map, MouseCursor.move, new Radius(idx, rad, arc));
        return next;
    }

    static class Radius
    extends Role {
        Point rad;
        IPathGeom.ArcTo arc;

        Radius(int idx, Point rad, IPathGeom.ArcTo arc) {
            super(rad, idx);
            this.rad = rad;
            this.arc = arc;
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.ArcTo(this.arc.isAbsolute(), this.rad.x + dx, this.rad.y + dy, this.arc.getXAxisRotation(), this.arc.getLargeArcFlag(), this.arc.getSweepFlag(), this.arc.getX(), this.arc.getY());
        }
    }

    static class Next
    extends Role {
        Point next;
        IPathGeom.ArcTo arc;

        Next(int idx, Point next, IPathGeom.ArcTo arc) {
            super(next, idx);
            this.next = next;
            this.arc = arc;
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.ArcTo(this.arc.isAbsolute(), this.arc.getRadiusX() + dx, this.arc.getRadiusY() + dy, this.arc.getXAxisRotation(), this.arc.getLargeArcFlag(), this.arc.getSweepFlag(), this.next.x + dx, this.next.y + dy);
        }
    }
}

