/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class LineTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.LineTo n = (IPathGeom.LineTo)seg;
        return new Point(n.getX(), n.getY());
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.LineTo ln = (IPathGeom.LineTo)seg;
        return new IPathGeom.LineTo(ln.isAbsolute(), ln.getX() + dx, ln.getY() + dy);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.LineTo ln = (IPathGeom.LineTo)seg;
        Point next = LineTo.nextPoint(pen, ln.isAbsolute(), ln.getX(), ln.getY());
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.LineTo ln = (IPathGeom.LineTo)seg;
        Point next = LineTo.nextPoint(pen, ln.isAbsolute(), ln.getX(), ln.getY());
        LineTo.paintHandle(g, studio, path, next, BColor.lime);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.LineTo ln = (IPathGeom.LineTo)seg;
        Point next = LineTo.nextPoint(pen, ln.isAbsolute(), ln.getX(), ln.getY());
        LineTo.addHandle(studio, path, next, map, MouseCursor.move, new LineToRole(next, idx));
        return next;
    }

    static class LineToRole
    extends Role {
        LineToRole(Point orig, int idx) {
            super(orig, idx);
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.LineTo(true, this.orig.x + dx, this.orig.y + dy);
        }
    }
}

