/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class SmoothQuadTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.SmoothQuadTo n = (IPathGeom.SmoothQuadTo)seg;
        return new Point(n.getX(), n.getY());
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.SmoothQuadTo sq = (IPathGeom.SmoothQuadTo)seg;
        return new IPathGeom.SmoothQuadTo(sq.isAbsolute(), sq.getX() + dx, sq.getY() + dy);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.SmoothQuadTo sq = (IPathGeom.SmoothQuadTo)seg;
        Point next = SmoothQuadTo.nextPoint(pen, sq.isAbsolute(), sq.getX(), sq.getY());
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.SmoothQuadTo sq = (IPathGeom.SmoothQuadTo)seg;
        Point next = SmoothQuadTo.nextPoint(pen, sq.isAbsolute(), sq.getX(), sq.getY());
        SmoothQuadTo.paintHandle(g, studio, path, next, BColor.lime);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.SmoothQuadTo sq = (IPathGeom.SmoothQuadTo)seg;
        Point next = SmoothQuadTo.nextPoint(pen, sq.isAbsolute(), sq.getX(), sq.getY());
        SmoothQuadTo.addHandle(studio, path, next, map, MouseCursor.move, new SmoothQuadToRole(next, idx));
        return next;
    }

    static class SmoothQuadToRole
    extends Role {
        SmoothQuadToRole(Point orig, int idx) {
            super(orig, idx);
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.SmoothQuadTo(true, this.orig.x + dx, this.orig.y + dy);
        }
    }
}

