/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans.path;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.shape.BPath;

public class VLineTo
extends SegmentArtisan {
    @Override
    public Point point(Point pen, IPathGeom.Segment seg) {
        IPathGeom.VLineTo vl = (IPathGeom.VLineTo)seg;
        return new Point(pen.x, vl.getY());
    }

    @Override
    public IPathGeom.Segment move(Point pen, IPathGeom.Segment seg, double dx, double dy) {
        if (seg.isRelative()) {
            return seg;
        }
        IPathGeom.VLineTo vl = (IPathGeom.VLineTo)seg;
        return new IPathGeom.VLineTo(vl.isAbsolute(), pen.x + dx);
    }

    @Override
    public Point paintBars(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.VLineTo vl = (IPathGeom.VLineTo)seg;
        Point next = VLineTo.nextPoint(pen, vl.isAbsolute(), pen.x, vl.getY());
        return next;
    }

    @Override
    public Point paintHandles(Graphics g, TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg) {
        IPathGeom.VLineTo vl = (IPathGeom.VLineTo)seg;
        Point next = VLineTo.nextPoint(pen, vl.isAbsolute(), pen.x, vl.getY());
        VLineTo.paintHandle(g, studio, path, next, BColor.lime);
        return next;
    }

    @Override
    public Point addHandles(TrackerStudio studio, BPath path, Point pen, IPathGeom.Segment seg, int idx, PointMap map) {
        IPathGeom.VLineTo vl = (IPathGeom.VLineTo)seg;
        Point next = VLineTo.nextPoint(pen, vl.isAbsolute(), pen.x, vl.getY());
        VLineTo.addHandle(studio, path, next, map, MouseCursor.move, new Next(idx, next, vl));
        return next;
    }

    static class Next
    extends Role {
        Point next;
        IPathGeom.VLineTo vl;

        Next(int idx, Point next, IPathGeom.VLineTo vl) {
            super(next, idx);
            this.next = next;
            this.vl = vl;
        }

        @Override
        public IPathGeom.Segment apply(double dx, double dy) {
            return new IPathGeom.VLineTo(this.vl.isAbsolute(), this.vl.getY() + dy);
        }
    }
}

