/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.px.editor.BPxEditorPane;
import java.util.ArrayList;
import javax.baja.chart.BChartPane;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BConverter;
import javax.baja.util.Lexicon;

public abstract class Reflector {
    public static boolean isDroppable(BWidget w) {
        if (Reflector.isLeaf(w)) {
            return false;
        }
        if (Reflector.isFreeFormPane(w)) {
            return true;
        }
        if (w instanceof BBorderPane) {
            BBorderPane b = (BBorderPane)w;
            return b.getContent() instanceof BNullWidget;
        }
        if (w instanceof BEdgePane) {
            BEdgePane b = (BEdgePane)w;
            return b.getCenter() instanceof BNullWidget;
        }
        return false;
    }

    public static boolean isLeaf(BWidget widget) {
        return !(widget instanceof BPane);
    }

    public static boolean isFreeFormPane(BWidget w) {
        if (!(w instanceof BPane)) {
            return false;
        }
        if (w instanceof BTabbedPane) {
            return true;
        }
        if (w instanceof BChartPane) {
            return true;
        }
        if (w.getType().toString().equals("report:ReportPane")) {
            return true;
        }
        try {
            if (w.getType().is(Sys.getType((String)"mobile:IMobilePane"))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            BPane pane = (BPane)w.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BWidget[] widgets = pane.getChildWidgets();
            return widgets.length == 0;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static BConverter converter(String prop, BBinding[] bindings) {
        for (int i = 0; i < bindings.length; ++i) {
            BValue val = bindings[i].get(prop);
            if (val == null || !(val instanceof BConverter)) continue;
            return (BConverter)val;
        }
        return null;
    }

    public static BComplex cloneFrozen(BComplex comp) {
        try {
            BComplex clone = (BComplex)comp.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            clone.copyFrom(comp);
            return clone;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public static Property[] dynamicProperties(BComponent comp) {
        ArrayList<Property> arr = new ArrayList<Property>();
        SlotCursor c = comp.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.isDynamic()) continue;
            arr.add(p);
        }
        return arr.toArray(new Property[0]);
    }

    public static BCanvasPane canvas(BWidget widget) {
        if (widget == null) {
            return null;
        }
        while (!(widget instanceof BCanvasPane)) {
            if ((widget = widget.getParentWidget()) != null) continue;
            return null;
        }
        return (BCanvasPane)widget;
    }

    public static BMenu optionsMenu(BTable table) {
        BMenu menu = new BMenu();
        menu.add("resizeColumns", (Command)new OptionsMenu(table));
        return menu;
    }

    public static String displayName(BComplex cmplx, boolean describe) {
        return Reflector.displayName(cmplx, TextUtil.getClassName(cmplx.getClass()).substring(1), describe);
    }

    public static String displayName(BComplex cmplx, String name, boolean describe) {
        StringBuilder text = new StringBuilder(name);
        if (describe) {
            Property prop = cmplx.getPropertyInParent();
            if (prop != null && prop.isFrozen()) {
                Reflector.paren(text, cmplx.getDisplayName(null));
            }
            if (cmplx instanceof BComponent) {
                BComponent comp = (BComponent)cmplx;
                BBinding[] bindings = (BBinding[])comp.getChildren(BBinding.class);
                if (bindings.length == 0) {
                    BPxInclude inc;
                    if (comp instanceof BLabel) {
                        BLabel label = (BLabel)comp;
                        if (!label.getText().equals("")) {
                            Reflector.paren(text, label.getText());
                        } else if (!label.getImage().isNull()) {
                            Reflector.paren(text, label.getImage().getOrdList().toString());
                        }
                    } else if (comp instanceof BPxInclude && !(inc = (BPxInclude)comp).getOrd().isNull()) {
                        Reflector.brace(text, inc.getOrd().toString());
                    }
                } else {
                    Reflector.brace(text, bindings[0].getOrd().toString());
                }
            }
        }
        return text.toString();
    }

    private static StringBuilder paren(StringBuilder text, String val) {
        text.append(" (").append(val).append(")");
        return text;
    }

    private static StringBuilder brace(StringBuilder text, String val) {
        text.append(" [").append(val).append("]");
        return text;
    }

    private static String text(String s) {
        return BPxEditorPane.text("media." + s);
    }

    private static String text(String s, Object[] o) {
        return BPxEditorPane.lexicon().getText("media." + s, o);
    }

    static class OptionsMenu
    extends Command {
        BTable table;

        OptionsMenu(BTable table) {
            super((BWidget)table, (Lexicon)UiLexicon.bajaui(), "commands.table.resizeColumns");
            this.table = table;
        }

        public CommandArtifact doInvoke() {
            this.table.sizeColumnsToFit();
            return null;
        }
    }
}

