/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.commands.ApplyPxPropertiesToNewWidgets;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import java.util.ArrayList;
import java.util.List;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.PxEditorSelection;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.transfer.TransferEnvelope;

public class SelectedWidgets
implements PxEditorSelection {
    private static final int SEARCH_RADIUS = 3;
    private BPxEditor editor;
    private BPxEditorPane editorPane;
    private final Subscriber sub;
    private List<BWidget> widgets = new ArrayList<BWidget>();

    public SelectedWidgets(final BPxEditor editor, BPxEditorPane editorPane) {
        this.editor = editor;
        this.editorPane = editorPane;
        this.sub = new Subscriber(){

            public void event(BComponentEvent event) {
                if (event.getId() == 1 || event.getId() == 2) {
                    BComponent comp = event.getSourceComponent();
                    if (comp == null || !(comp instanceof BWidget)) {
                        return;
                    }
                    if (event.getSlot() == null) {
                        return;
                    }
                    if (event.getSlotName() == null) {
                        return;
                    }
                    if (!event.getSlot().isProperty()) {
                        return;
                    }
                    BWidget w = (BWidget)comp;
                    PxWidgetEvent pxEvent = new PxWidgetEvent(event.getId() == 1 ? 0 : 1, w, event.getSlotName(), w.get(event.getSlot().asProperty()));
                    editor.firePxEvent(pxEvent);
                }
            }
        };
    }

    @Override
    public void deselectAll() {
        this.widgets.clear();
        this.sub.unsubscribeAll();
    }

    @Override
    public void deselect(BWidget widget) {
        int idx = this.lookupWidgetIndex(widget);
        if (idx != -1) {
            this.widgets.remove(idx);
            this.sub.unsubscribe((BComponent)widget);
        }
    }

    @Override
    public void select(BWidget widget) {
        int idx = this.lookupWidgetIndex(widget);
        if (idx == -1) {
            this.widgets.add(widget);
            this.sub.subscribe((BComponent)widget);
            this.checkTabbedPane((BComplex)widget);
        }
    }

    @Override
    public void setWidgets(BWidget[] arr) {
        this.widgets.clear();
        this.sub.unsubscribeAll();
        for (int i = 0; i < arr.length; ++i) {
            this.widgets.add(arr[i]);
            this.sub.subscribe((BComponent)arr[i]);
            this.checkTabbedPane((BComplex)arr[i]);
        }
    }

    @Override
    public BWidget[] getWidgets() {
        return this.widgets.toArray(new BWidget[0]);
    }

    @Override
    public boolean isSelected(BWidget widget) {
        return this.lookupWidgetIndex(widget) != -1;
    }

    public Handle getHandle(double x, double y) {
        return (Handle)this.getPointMap().get((double)((int)x), (double)((int)y));
    }

    public BWidget get(int index) {
        return this.widgets.get(index);
    }

    public int size() {
        return this.widgets.size();
    }

    public Handle[] getHandlesHavingRole(Object role) {
        Object[] o = this.getPointMap().getValues();
        ArrayList<Handle> a = new ArrayList<Handle>();
        for (int i = 0; i < o.length; ++i) {
            if (!((Handle)o[i]).role.equals(role)) continue;
            a.add((Handle)o[i]);
        }
        return a.toArray(new Handle[0]);
    }

    public boolean canSelect(BWidget widget) {
        if (this.widgets.size() == 0) {
            return true;
        }
        if (!Reflector.isFreeFormPane(widget.getParentWidget())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getParent() == widget.getParent()) continue;
            return false;
        }
        return true;
    }

    public void resetHandles() {
    }

    private int lookupWidgetIndex(BWidget widget) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            if (widget != this.widgets.get(i)) continue;
            return i;
        }
        return -1;
    }

    private PointMap getPointMap() {
        PointMap pointMap = new PointMap(3);
        if (this.editor.isReadonly()) {
            return pointMap;
        }
        Artisan artisan = Artisan.instance();
        for (int i = 0; i < this.widgets.size(); ++i) {
            artisan.addHandles(this.editorPane.getTrackerStudio(), this.get(i), pointMap);
        }
        return pointMap;
    }

    private void checkTabbedPane(BComplex c) {
        while (c != null && c instanceof BWidget) {
            BComplex p;
            if (c instanceof BLabelPane && (p = c.getParent()) instanceof BTabbedPane) {
                ((BTabbedPane)p).selectLabelPane((BLabelPane)c);
                this.editorPane.forceRootLayout();
                return;
            }
            c = c.getParent();
        }
    }

    public TransferEnvelope envelope() {
        if (this.size() == 0) {
            return null;
        }
        BWidget root = this.editor.getWidget();
        BWidget[] newWidgets = new BWidget[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            BWidget widget = this.get(i);
            newWidgets[i] = this.editor.cloneWidget(widget);
            ApplyPxPropertiesToNewWidgets.storePxPropertyInfoOnNewWidget(this.editor, widget, newWidgets[i]);
        }
        return TransferEnvelope.make((Mark)new Mark((BObject[])newWidgets));
    }
}

