/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.Glyph;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;

public class LayerGlyph
extends Glyph {
    LayerGlyph(BWireSheetPane ws) {
        super(ws);
    }

    @Override
    public void layout() {
        this.setWixelBounds(0, 0, this.ws.grid.getWixelWidth(), this.ws.grid.getWixelHeight());
        super.layout();
    }

    public Glyph getSelectableGlyphAt(int p, int q) {
        Glyph glyph = this.childAt(p, q);
        if (glyph != null && glyph.isSelectable()) {
            return glyph;
        }
        return null;
    }

    public void selectAllInPixelRect(RectGeom r) {
        Glyph[] kids = this.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            Glyph kid = kids[i];
            if (!kid.isSelectable()) continue;
            int x = kid.x;
            int y = kid.y;
            int w = kid.pw;
            int h = kid.ph;
            if (!r.contains((double)x, (double)y) || !r.contains((double)(x + w), (double)(y + h))) continue;
            this.ws.selection.select(kid);
        }
    }

    @Override
    public RectGeom getPrintBounds() {
        Glyph[] kids = this.getChildGlyphs();
        if (kids.length == 0) {
            return new RectGeom(0.0, 0.0, 0.0, 0.0);
        }
        RectGeom r = kids[0].getPrintBounds();
        for (int i = 1; i < kids.length; ++i) {
            RectGeom.bounds((IRectGeom)r, (IRectGeom)kids[i].getPrintBounds(), (RectGeom)r);
        }
        return r;
    }

    @Override
    public RectGeom getGeom() {
        Glyph[] kids = this.getChildGlyphs();
        RectGeom bounds = null;
        for (int i = 0; i < kids.length; ++i) {
            RectGeom kidBounds = kids[i].getGeom();
            if (kidBounds == null) continue;
            bounds = bounds == null ? kidBounds : RectGeom.bounds((IRectGeom)bounds, (IRectGeom)kidBounds, (RectGeom)bounds);
        }
        return bounds;
    }
}

