/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.TileImages;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.workbench.util.WbUtil;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.util.Lexicon;

public abstract class LinkGlyph
extends Glyph {
    int minP;
    int minQ;
    int maxP;
    int maxQ;
    Tile[] tiles = new Tile[0];
    Object selectionKey;
    String linkName = null;

    protected LinkGlyph(BWireSheetPane ws, Object selectionKey) {
        super(ws);
        this.selectionKey = selectionKey;
        this.setWixelBounds(0, 0, 1, 1);
    }

    public abstract StdComponentGlyph getSourceComponentGlyph();

    public abstract StdComponentGlyph getTargetComponentGlyph();

    public abstract SlotBarGlyph getSourceSlotGlyph();

    public abstract SlotBarGlyph getTargetSlotGlyph();

    public boolean isLinkedTo(ComponentGlyph glyph) {
        return glyph == this.getSourceComponentGlyph() || glyph == this.getTargetComponentGlyph();
    }

    public boolean isRelation() {
        return false;
    }

    public abstract String getStatusMessage();

    public abstract int getLinkColorCode();

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public final Object getSelectionKey() {
        return this.selectionKey;
    }

    @Override
    public void popup(double mx, double my) {
        this.ws.controller.doBackgroundPopup(mx, my);
    }

    @Override
    public void mouseEntered() {
        this.showStatus(this.getStatusMessage());
    }

    @Override
    public boolean contains(int p, int q) {
        if (p < this.minP || p > this.maxP || q < this.minQ || q > this.maxQ) {
            return false;
        }
        Tile[] tiles = this.tiles;
        for (int i = 0; i < tiles.length; ++i) {
            if (!tiles[i].contains(p, q)) continue;
            return true;
        }
        return false;
    }

    public boolean inside(RectGeom r) {
        if ((double)(this.minP * this.ws.grid.wixel) < r.x) {
            return false;
        }
        if ((double)(this.minQ * this.ws.grid.wixel) < r.y) {
            return false;
        }
        if ((double)(this.maxP * this.ws.grid.wixel) > r.x + r.width) {
            return false;
        }
        return !((double)(this.maxQ * this.ws.grid.wixel) > r.y + r.height);
    }

    @Override
    public final void doLayout(Glyph[] kids) {
        this.tiles = this.buildTiles();
        this.setWixelBounds(0, 0, 0, 0);
    }

    @Override
    protected final void fillGrid() {
        int minP = Integer.MAX_VALUE;
        int minQ = Integer.MAX_VALUE;
        int maxP = Integer.MIN_VALUE;
        int maxQ = Integer.MIN_VALUE;
        for (int i = 0; i < this.tiles.length; ++i) {
            Tile t = this.tiles[i];
            int p = t.p;
            int q = t.q;
            this.ws.grid.set(p, q, t.type);
            minP = Math.min(minP, p);
            minQ = Math.min(minQ, q);
            maxP = Math.max(maxP, p);
            maxQ = Math.max(maxQ, q);
        }
        this.minP = minP;
        this.minQ = minQ;
        this.maxP = maxP;
        this.maxQ = maxQ;
    }

    protected abstract Tile[] buildTiles();

    public void repaintSelection() {
        int x = this.minP * this.ws.grid.wixel;
        int y = this.minQ * this.ws.grid.wixel;
        int w = (this.maxP - this.minP + 1) * this.ws.grid.wixel;
        int h = (this.maxQ - this.minQ + 1) * this.ws.grid.wixel;
        this.ws.getCanvas().repaint(x, y, w, h);
    }

    @Override
    public final void paint(Graphics g) {
        int linkHighlightColorCode = -1;
        if (BWsOptions.make().getLinkHighlighting()) {
            StdComponentGlyph sourceComp = this.getSourceComponentGlyph();
            StdComponentGlyph targetComp = this.getTargetComponentGlyph();
            if (sourceComp != null && sourceComp.isSelected()) {
                linkHighlightColorCode = sourceComp.getSelectionIndex();
            }
            if (linkHighlightColorCode == -1 && targetComp != null && targetComp.isSelected()) {
                linkHighlightColorCode = targetComp.getSelectionIndex();
            }
        }
        TileImages.Wimages wimages = TileImages.get(this.getLinkColorCode(), linkHighlightColorCode, this.isSelected());
        Tile[] tiles = this.tiles;
        for (int i = 0; i < tiles.length; ++i) {
            Tile t = tiles[i];
            wimages.paint(g, this.ws.grid.wixel, t.type, t.x, t.y);
        }
    }

    @Override
    public void paintSelection(Graphics g) {
    }

    @Override
    public void print(WsPrinting p) {
        Graphics g = p.graphics;
        g.setBrush(BColor.black.toBrush());
        Tile[] tiles = this.tiles;
        double wixel = p.wixel;
        for (int i = 0; i < tiles.length; ++i) {
            Tile t = tiles[i];
            if (!p.paintLinks && (t.type == 4 || t.type == 3)) continue;
            double x = (double)t.p * wixel;
            double y = (double)t.q * wixel;
            this.printTile(p, x, y, t.type);
            if (t.type == 4) {
                if (this.linkName == null) continue;
                g.setFont(p.small);
                g.drawString(this.linkName, x + wixel + 2.0, y + p.small.getAscent());
                continue;
            }
            if (t.type != 3 || this.linkName == null) continue;
            g.setFont(p.small);
            g.drawString(this.linkName, x - wixel, y + p.small.getAscent());
        }
    }

    private void printTile(WsPrinting p, double x, double y, int type) {
        Graphics g = p.graphics;
        double w = p.wixel;
        double h = w / 2.0;
        switch (type) {
            case 1: {
                g.strokeLine(x, y + h, x + w, y + h);
                break;
            }
            case 2: {
                g.strokeLine(x + h, y, x + h, y + w);
                break;
            }
            case 3: {
                g.strokeLine(x, y + h, x + w, y + h);
                break;
            }
            case 4: {
                g.strokeLine(x, y + h, x + w, y + h);
                break;
            }
            case 5: 
            case 6: {
                g.strokeLine(x, y + h, x + w, y + h);
                g.strokeLine(x + h, y, x + h, y + w);
                break;
            }
            case 7: {
                g.strokeLine(x, y + h, x + h, y);
                break;
            }
            case 8: {
                g.strokeLine(x, y + h, x + h, y + w);
                break;
            }
            case 9: {
                g.strokeLine(x + h, y, x + w, y + h);
                break;
            }
            case 10: {
                g.strokeLine(x + h, y + w, x + w, y + h);
                break;
            }
            default: {
                System.out.println("???printTile??? " + type);
            }
        }
    }

    BOrd getGotoOrd() {
        throw new IllegalStateException();
    }

    String getGotoLinkSourceHandle() {
        return "";
    }

    String getGotoLinkSourceSlotName() {
        return "";
    }

    String getGotoLinkTargetHandle() {
        return "";
    }

    String getGotoLinkTargetSlotName() {
        return "";
    }

    protected String getHandleFromOrd(BOrd ord) {
        OrdQuery[] queries = ord.parse();
        for (int i = 0; i < queries.length; ++i) {
            if (!queries[i].getScheme().equals("h")) continue;
            return queries[i].getBody();
        }
        BObject obj = ord.get((BObject)this.ws.controller.container);
        if (obj.isComponent()) {
            return obj.asComponent().getHandle().toString();
        }
        throw new IllegalStateException();
    }

    public int getMinP() {
        return this.minP;
    }

    public int getMinQ() {
        return this.minQ;
    }

    public int getMaxP() {
        return this.maxP;
    }

    public int getMaxQ() {
        return this.maxQ;
    }

    public static class Tile {
        final int p;
        final int q;
        final int x;
        final int y;
        final int type;

        public Tile(int p, int q, int type, BWireSheetPane ws) {
            this.p = p;
            this.q = q;
            this.x = p * ws.grid.wixel;
            this.y = q * ws.grid.wixel;
            this.type = type;
        }

        public final boolean contains(int p, int q) {
            return this.p == p && this.q == q;
        }

        public String toString() {
            return "" + this.p + "," + this.q + "," + this.x + "," + this.y + "," + this.type;
        }
    }

    protected class GotoLinkCommand
    extends Command {
        protected GotoLinkCommand() {
            super((BWidget)LinkGlyph.this.ws.getCanvas(), WsConst.lex, "linkGotoLink");
        }

        protected GotoLinkCommand(BWidget owner, Lexicon lexicon, String keyBase) {
            super(owner, lexicon, keyBase);
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            BOrd ord = LinkGlyph.this.getGotoOrd();
            BComponent gotoComp = (BComponent)ord.get((BObject)LinkGlyph.this.ws.getView().getCurrentValueSpace());
            BComponent gotoParent = (BComponent)gotoComp.getParent();
            StringBuilder ordBuff = new StringBuilder();
            ordBuff.append(gotoParent.getNavOrd().toString());
            ordBuff.append("|view:");
            ordBuff.append(WbUtil.getBestViewId((BObject)gotoParent, (String)LinkGlyph.this.ws.getView().getType().toString(), (BWidget)LinkGlyph.this.ws, (Context)LinkGlyph.this.ws.context, (String[])new String[0])).append("?");
            ordBuff.append("sHandle").append("=").append(LinkGlyph.this.getGotoLinkSourceHandle()).append(";");
            ordBuff.append("sSlot").append("=").append(LinkGlyph.this.getGotoLinkSourceSlotName()).append(";");
            ordBuff.append("tHandle").append("=").append(LinkGlyph.this.getGotoLinkTargetHandle()).append(";");
            ordBuff.append("tSlot").append("=").append(LinkGlyph.this.getGotoLinkTargetSlotName());
            LinkGlyph.this.ws.getWbShell().hyperlink(new HyperlinkInfo(BOrd.make((String)ordBuff.toString()), event.getInputEvent()));
            return null;
        }
    }

    class GotoCommand
    extends Command {
        GotoCommand() {
            super((BWidget)LinkGlyph.this.ws.getCanvas(), WsConst.lex, "linkGoto");
        }

        GotoCommand(BWidget owner, Lexicon lexicon, String keyBase) {
            super(owner, lexicon, keyBase);
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            BOrd ord = LinkGlyph.this.getGotoOrd();
            if (ord.toString().startsWith("h:")) {
                BComponent c = (BComponent)ord.get((BObject)LinkGlyph.this.ws.controller.container);
                ord = c.getNavOrd();
            }
            LinkGlyph.this.ws.getWbShell().hyperlink(new HyperlinkInfo(ord, event.getInputEvent()));
            return null;
        }
    }
}

