/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;

public abstract class LinkLinkGlyph
extends LinkGlyph {
    public final BLink link;
    public final BRelation relation;
    StdComponentGlyph targetComp;
    SlotBarGlyph targetSlot;
    int linkColorCode;

    protected LinkLinkGlyph(BWireSheetPane ws, BLink link, StdComponentGlyph targetComp) {
        super(ws, "Link:" + targetComp.handle + "." + link.getName());
        this.link = link;
        this.relation = null;
        this.targetComp = targetComp;
        this.targetSlot = targetComp.getVisibleSlotBar(link.getTargetSlotName());
        this.linkColorCode = BWsOptions.make().toLinkColorCode(link);
    }

    protected LinkLinkGlyph(BWireSheetPane ws, BRelation relation, StdComponentGlyph targetComp, StdComponentGlyph sourceComp) {
        super(ws, targetComp);
        if (targetComp != null & sourceComp != null) {
            this.selectionKey = "Relation:" + targetComp.handle + '.' + sourceComp.handle + '.' + relation.getName();
        }
        this.link = null;
        this.relation = relation;
        this.targetComp = targetComp;
        this.targetSlot = targetComp.getVisibleRelationBar(relation, true);
        this.linkColorCode = BWsOptions.make().toLinkColorCode(relation);
    }

    @Override
    public StdComponentGlyph getTargetComponentGlyph() {
        return this.targetComp;
    }

    @Override
    public SlotBarGlyph getTargetSlotGlyph() {
        return this.targetSlot;
    }

    @Override
    public int getLinkColorCode() {
        return this.linkColorCode;
    }

    public boolean isLink() {
        return this.link != null;
    }

    @Override
    public boolean isRelation() {
        return this.relation != null;
    }
}

