/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.sys.engine.NRelationKnob;
import com.tridium.util.LinkUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.commands.DeleteRelationsCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.RelationKnob;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class RelationKnobGlyph
extends LinkGlyph {
    NRelationKnob rKnob;
    StdComponentGlyph sourceComp;
    SlotBarGlyph sourceSlot;
    int linkColorCode;

    protected RelationKnobGlyph(BWireSheetPane ws, RelationKnob rKnob, StdComponentGlyph sourceComp) {
        super(ws, "RelationKnob:" + sourceComp.handle + "." + ((NRelationKnob)rKnob).id);
        this.rKnob = (NRelationKnob)rKnob;
        this.sourceComp = sourceComp;
        this.sourceSlot = sourceComp.getVisibleRelationBar(rKnob);
        this.linkColorCode = BWsOptions.make().toLinkColorCode(rKnob);
    }

    @Override
    public StdComponentGlyph getSourceComponentGlyph() {
        return this.sourceComp;
    }

    @Override
    public StdComponentGlyph getTargetComponentGlyph() {
        return null;
    }

    @Override
    public SlotBarGlyph getSourceSlotGlyph() {
        return this.sourceSlot;
    }

    @Override
    public SlotBarGlyph getTargetSlotGlyph() {
        return null;
    }

    @Override
    public String getStatusMessage() {
        return LinkUtil.toDisplay((RelationKnob)this.rKnob);
    }

    @Override
    public int getLinkColorCode() {
        return this.linkColorCode;
    }

    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    BOrd getGotoOrd() {
        return this.rKnob.getRelationOrd();
    }

    @Override
    public void popup(double mx, double my) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new GotoRelationCommand());
        menu.add(null, (Command)new GotoCommand());
        menu.add(null, (Command)new DeleteRelationsCommand(this.ws));
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        this.ws.controller.addLinkSelection(menu, p, q);
        menu.open((BWidget)this.ws.getCanvas(), mx, my);
    }

    @Override
    protected String getGotoLinkSourceHandle() {
        return this.getHandleFromOrd(this.rKnob.getEndpointOrd());
    }

    @Override
    protected String getGotoLinkSourceSlotName() {
        return this.rKnob.getRelationId();
    }

    @Override
    protected String getGotoLinkTargetHandle() {
        return this.getHandleFromOrd(this.rKnob.getRelationOrd());
    }

    @Override
    protected String getGotoLinkTargetSlotName() {
        return this.rKnob.getRelationId();
    }

    @Override
    public void doubleClicked(BMouseEvent event) {
        new GotoRelationCommand().invoke(new CommandEvent((BInputEvent)event));
    }

    @Override
    public void findLinks(WsPrinting p) {
        this.linkName = p.addKnobLink(LinkUtil.toDisplaySource((RelationKnob)this.rKnob), LinkUtil.toDisplayTarget((RelationKnob)this.rKnob));
    }

    @Override
    public LinkGlyph.Tile[] buildTiles() {
        if (this.sourceSlot == null) {
            System.out.println("ERROR: LinkKnobGlyph.noSourceSlot: " + this.rKnob);
            return new LinkGlyph.Tile[0];
        }
        int p = this.sourceSlot.absP() - 1;
        int q = this.sourceSlot.absQ();
        return new LinkGlyph.Tile[]{new LinkGlyph.Tile(p, q, 3, this.ws)};
    }

    public BRelation getRelation() {
        BComponent targetComp = (BComponent)this.rKnob.getRelationOrd().get((BObject)this.sourceComp.component);
        targetComp.lease();
        BRelation[] relations = targetComp.getComponentRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (!relations[i].getRelationId().equals(this.rKnob.getRelationId())) continue;
            return relations[i];
        }
        return null;
    }

    protected class GotoRelationCommand
    extends LinkGlyph.GotoLinkCommand {
        protected GotoRelationCommand() {
            super((BWidget)RelationKnobGlyph.this.ws.getCanvas(), WsConst.lex, "relationGotoRelation");
        }
    }

    class GotoCommand
    extends LinkGlyph.GotoCommand {
        GotoCommand() {
            super((BWidget)RelationKnobGlyph.this.ws.getCanvas(), WsConst.lex, "relationGoto");
        }
    }
}

