/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LayerGlyph;
import com.tridium.wiresheet.LinkLayerGlyph;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.style.IStylable;

public class RootGlyph
extends Glyph {
    public final LayerGlyph componentLayer;
    public final LinkLayerGlyph linkLayer;

    RootGlyph(BWireSheetPane ws) {
        super(ws);
        this.componentLayer = new LayerGlyph(ws);
        this.add(this.componentLayer);
        this.linkLayer = new LinkLayerGlyph(ws);
        this.add(this.linkLayer);
    }

    public Glyph getSelectableGlyphAt(int p, int q) {
        Glyph glyph = this.componentLayer.getSelectableGlyphAt(p, q);
        if (glyph == null) {
            glyph = this.linkLayer.getSelectableGlyphAt(p, q);
        }
        return glyph;
    }

    @Override
    public Glyph descendentAt(int p, int q) {
        Glyph glyph = this.componentLayer.descendentAt(p, q);
        if (glyph == null) {
            glyph = this.linkLayer.descendentAt(p, q);
        }
        return glyph;
    }

    public void selectAllInPixelRect(RectGeom r) {
        this.componentLayer.selectAllInPixelRect(r);
        this.linkLayer.selectAllInPixelRect(r);
    }

    @Override
    public void removeAll() {
        this.componentLayer.removeAll();
        this.linkLayer.removeAll();
    }

    @Override
    public RectGeom getPrintBounds() {
        RectGeom r = new RectGeom(0.0, 0.0, 0.0, 0.0);
        RectGeom.bounds((IRectGeom)r, (IRectGeom)this.componentLayer.getPrintBounds(), (RectGeom)r);
        RectGeom.bounds((IRectGeom)r, (IRectGeom)this.linkLayer.getPrintBounds(), (RectGeom)r);
        return r;
    }

    @Override
    public void paint(Graphics g) {
        BWsCanvas canvas = this.ws.getCanvas();
        WiresheetTheme theme = Theme.wiresheet();
        g.setBrush(theme.canvas().getBackground((IStylable)this));
        g.fillRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        BWsOptions options = BWsOptions.make();
        double maxWidth = options.getMaxWidth() * this.ws.grid.wixel;
        double maxHeight = options.getMaxHeight() * this.ws.grid.wixel;
        if (options.getShowGrid()) {
            double width = Math.min(canvas.getWidth(), maxWidth);
            double height = Math.min(canvas.getHeight(), maxHeight);
            g.setBrush(theme.canvas().getGridColor((IStylable)this));
            int x = this.ws.grid.wixel;
            while ((double)x < width) {
                g.strokeLine((double)x, 0.0, (double)x, height);
                x += this.ws.grid.wixel;
            }
            int y = this.ws.grid.wixel;
            while ((double)y < height) {
                g.strokeLine(0.0, (double)y, width, (double)y);
                y += this.ws.grid.wixel;
            }
        }
        g.setBrush(theme.canvas().getOutline((IStylable)this));
        g.strokeLine(0.0, maxHeight, maxWidth, maxHeight);
        g.strokeLine(maxWidth, 0.0, maxWidth, maxHeight);
        this.linkLayer.paint(g);
        this.componentLayer.paint(g);
    }

    @Override
    public String getStyleSelector() {
        return "wire-sheet";
    }
}

