/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.MoveGlyphsCommand;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class MoveState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private double xo;
    private double yo;
    private Point original;

    public MoveState(BWireSheetPane ws, RectGeom bounds, double mx, double my) {
        super(ws);
        this.x = bounds.x;
        this.y = bounds.y;
        this.w = bounds.width;
        this.h = bounds.height;
        this.xo = mx - bounds.x;
        this.yo = my - bounds.y;
        this.original = new Point(this.x, this.y);
        BWsCanvas canvas = ws.getCanvas();
        canvas.setMouseCursor(moveCursor);
        canvas.repaint();
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.transition(new NormalState(this.ws));
        double mx = event.getX();
        double my = event.getY();
        this.computeMovePt(mx, my);
        int pDiff = (int)((this.x - this.original.x) / (double)this.ws.grid.wixel);
        int qDiff = (int)((this.y - this.original.y) / (double)this.ws.grid.wixel);
        new MoveGlyphsCommand(this.ws, this.selection.getComponentGlyphs(), pDiff, qDiff).invoke();
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        double ox = this.x;
        double oy = this.y;
        double ow = this.w;
        double oh = this.h;
        double mx = event.getX();
        double my = event.getY();
        this.computeMovePt(mx, my);
        double dx = Math.min(this.x, ox);
        double dy = Math.min(this.y, oy);
        double dw = Math.max(this.x + this.w, ox + ow) - dx;
        double dh = Math.max(this.y + this.h, oy + oh) - dy;
        this.ws.getCanvas().repaint(dx - 1.0, dy - 1.0, dw + 2.0, dh + 2.0);
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        if (this.pulseViewport(event)) {
            this.mouseDragged(event);
        }
    }

    private void computeMovePt(double mx, double my) {
        this.x = mx - this.xo;
        this.y = my - this.yo;
        this.x = this.snapToGrid(this.x);
        this.y = this.snapToGrid(this.y);
        double wMax = BWsOptions.make().getMaxWidth() * this.ws.grid.wixel;
        double hMax = BWsOptions.make().getMaxHeight() * this.ws.grid.wixel;
        if (this.x + this.w > wMax) {
            this.x = wMax - this.w;
        }
        if (this.y + this.h > hMax) {
            this.y = hMax - this.h;
        }
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
    }

    @Override
    public void paintFx(Graphics g) {
        g.setBrush(BColor.black);
        g.strokeRect(this.x, this.y, this.w, this.h);
    }
}

