/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.MoveGlyphsCommand;
import com.tridium.wiresheet.states.LinkState;
import com.tridium.wiresheet.states.MoveState;
import com.tridium.wiresheet.states.ResizeState;
import com.tridium.wiresheet.states.RubberBandState;
import com.tridium.wiresheet.states.ThumbnailOverState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;

public class NormalState
extends WsState {
    private int cursorType = -1;
    private Point dragCheckPoint = null;
    private Glyph pressedGlyph;
    private Glyph mouseOverGlyph;
    private ResizeZone resizeZone;
    private Glyph linkOver;
    private int linkOverZone;

    public NormalState(BWireSheetPane ws) {
        super(ws);
        BWsCanvas canvas = ws.getCanvas();
        canvas.setMouseCursor(normalCursor);
        canvas.repaint();
    }

    public NormalState(BWireSheetPane ws, WsController controller) {
        super(ws, controller);
        BWsCanvas canvas = ws.getCanvas();
        canvas.setMouseCursor(normalCursor);
        canvas.repaint();
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        if (!event.isControlDown()) {
            switch (event.getKeyCode()) {
                case 38: {
                    this.move(0, -1);
                    break;
                }
                case 40: {
                    this.move(0, 1);
                    break;
                }
                case 37: {
                    this.move(-1, 0);
                    break;
                }
                case 39: {
                    this.move(1, 0);
                }
            }
        } else {
            switch (event.getKeyCode()) {
                case 38: {
                    this.ws.commands.zoomIn.invoke();
                    break;
                }
                case 40: {
                    this.ws.commands.zoomOut.invoke();
                }
            }
        }
    }

    void move(int pDiff, int qDiff) {
        ComponentGlyph[] glyphs = this.selection.getComponentGlyphs();
        if (glyphs != null && glyphs.length > 0) {
            new MoveGlyphsCommand(this.ws, glyphs, pDiff, qDiff).invoke();
        }
    }

    @Override
    public void transition(WsState newState) {
        this.setMouseOver(null);
        super.transition(newState);
    }

    @Override
    public void mouseWheel(BMouseWheelEvent event) {
        if (event.isControlDown()) {
            this.ws.controller.zoom((int)(-event.getPreciseWheelRotation()));
            event.consume();
            this.ws.relayout();
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        double mx = event.getX();
        double my = event.getY();
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        if (event.isPopupTrigger()) {
            this.popup(event, mx, my);
            return;
        }
        if (this.isButton1(event)) {
            if (event.isShiftDown() && this.linkOver != null) {
                this.transition(new LinkState(this.ws, this.linkOver, this.linkOverZone, mx, my));
                return;
            }
            this.dragCheckPoint = new Point(mx, my);
        } else {
            this.dragCheckPoint = null;
        }
        this.pressedGlyph = this.selection.getSelectableGlyphAt(p, q);
        if (this.isButton1(event) && event.getClickCount() > 1 && this.pressedGlyph != null) {
            this.pressedGlyph.doubleClicked(event);
        }
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        double mx = event.getX();
        double my = event.getY();
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        if (event.isPopupTrigger()) {
            this.popup(event, mx, my);
            return;
        }
        Glyph glyph = this.selection.getSelectableGlyphAt(p, q);
        if (glyph != null && glyph == this.pressedGlyph) {
            if (this.isMultiple(event)) {
                if (glyph.isSelected()) {
                    this.selection.unselect(glyph);
                } else {
                    this.selection.select(glyph);
                }
            } else {
                this.selection.unselectAll();
                this.selection.select(glyph);
            }
        } else {
            this.selection.unselectAll();
        }
        this.pressedGlyph = null;
        this.ws.getCanvas().setMouseCursor(normalCursor);
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.checkMouseOver(event);
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        double mx = event.getX();
        double my = event.getY();
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        if (this.dragCheckPoint == null) {
            return;
        }
        if (Math.abs(this.dragCheckPoint.x - mx) < 8.0 && Math.abs(this.dragCheckPoint.y - my) < 8.0) {
            return;
        }
        if (this.resizeZone != null) {
            this.transition(new ResizeState(this.ws, this.resizeZone, mx, my));
            return;
        }
        if (this.linkOver != null) {
            this.transition(new LinkState(this.ws, this.linkOver, this.linkOverZone, mx, my));
            return;
        }
        int dragP = (int)this.dragCheckPoint.x / this.ws.grid.wixel;
        int dragQ = (int)this.dragCheckPoint.y / this.ws.grid.wixel;
        Glyph glyph = this.selection.getSelectableGlyphAt(dragP, dragQ);
        if (glyph != null) {
            RectGeom bounds;
            if (!glyph.isSelected()) {
                this.selection.unselectAll();
                this.selection.select(glyph);
            }
            if ((bounds = this.selection.getSelectionPixelBounds()) != null) {
                int xCheck = (int)this.dragCheckPoint.x;
                int yCheck = (int)this.dragCheckPoint.y;
                this.transition(new MoveState(this.ws, bounds, xCheck, yCheck));
            }
            return;
        }
        this.transition(new RubberBandState(this.ws, this.dragCheckPoint, mx, my));
    }

    private boolean isMultiple(BMouseEvent event) {
        return event.isShiftDown() || event.isControlDown();
    }

    private boolean isButton1(BMouseEvent event) {
        boolean b3;
        int mods = event.getModifiersEx();
        boolean b1 = (mods & 0x400) != 0;
        boolean b2 = (mods & 0x800) != 0;
        boolean bl = b3 = (mods & 0x1000) != 0;
        if (b1) {
            return true;
        }
        return !b1 && !b2 && !b3;
    }

    private void popup(BMouseEvent event, double mx, double my) {
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        Glyph glyph = this.selection.getSelectableGlyphAt(p, q);
        if (glyph != null) {
            if (!glyph.isSelected()) {
                if (!this.isMultiple(event)) {
                    this.selection.unselectAll();
                }
                this.selection.select(glyph);
            }
            glyph.popup(mx, my);
        } else {
            this.controller.doBackgroundPopup(mx, my);
        }
    }

    private void checkMouseOver(BMouseEvent event) {
        double mx = event.getX();
        double my = event.getY();
        BThumbnail thumb = this.ws.getThumbnail();
        Point abs = this.translateToCanvasPane(event);
        if (this.ws.commands.showThumbnail.isSelected() && thumb.contains(abs.x - thumb.getX(), abs.y - thumb.getY())) {
            this.transition(new ThumbnailOverState(this.ws));
            return;
        }
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        this.setResizeZone(this.selection.getResizeAt(mx, my));
        this.setMouseOver(this.ws.getCanvas().getRootGlyph().descendentAt(p, q));
        this.checkLinkOver(this.mouseOverGlyph, p, q);
    }

    private void setResizeZone(ResizeZone z) {
        if (z != this.resizeZone) {
            this.resizeZone = z;
            if (z == null) {
                this.ws.getCanvas().setMouseCursor(normalCursor);
            } else {
                this.ws.getCanvas().setMouseCursor(z.mouseCursor);
            }
        }
    }

    private void setMouseOver(Glyph glyph) {
        if (glyph != this.mouseOverGlyph) {
            this.ws.getShell().showStatus(null);
            if (this.mouseOverGlyph != null) {
                this.mouseOverGlyph.setMouseOver(false);
            }
            if (glyph != null) {
                glyph.setMouseOver(true);
            }
            this.mouseOverGlyph = glyph;
        }
    }

    private void checkLinkOver(Glyph glyph, int p, int q) {
        int zone = 0;
        if (glyph != null && (zone = glyph.getLinkHotSpot(p - glyph.absP(), q - glyph.absQ())) == 0) {
            glyph = null;
        }
        if (glyph != this.linkOver) {
            if (this.linkOver != null) {
                this.linkOver.setLinkOver(0);
            }
            this.linkOver = glyph;
            this.linkOverZone = zone;
            if (glyph != null) {
                glyph.setLinkOver(zone);
            }
            BWsCanvas canvas = this.ws.getCanvas();
            switch (zone) {
                case 0: {
                    canvas.setMouseCursor(normalCursor);
                    break;
                }
                case 1: {
                    canvas.setMouseCursor(linkSourceCursor);
                    break;
                }
                case 2: {
                    canvas.setMouseCursor(linkTargetCursor);
                }
            }
        }
    }

    private void checkRelateOver(Glyph glyph, int p, int q) {
        int zone = 0;
        if (glyph != null && (zone = glyph.getRelateHotSpot(p - glyph.absP(), q - glyph.absQ())) == 0) {
            glyph = null;
        }
        if (glyph != this.linkOver) {
            if (this.linkOver != null) {
                this.linkOver.setLinkOver(0);
            }
            this.linkOver = glyph;
            this.linkOverZone = zone;
            if (glyph != null) {
                glyph.setLinkOver(zone);
            }
            BWsCanvas canvas = this.ws.getCanvas();
            switch (zone) {
                case 0: {
                    canvas.setMouseCursor(normalCursor);
                    break;
                }
                case 1: {
                    canvas.setMouseCursor(linkSourceCursor);
                    break;
                }
                case 2: {
                    canvas.setMouseCursor(linkTargetCursor);
                }
            }
        }
    }
}

