/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.Point;
import javax.baja.ui.event.BMouseEvent;

public class ThumbnailDragState
extends WsState {
    private Point anchor;

    public ThumbnailDragState(BWireSheetPane ws, Point anchor, double mx, double my) {
        super(ws);
        BThumbnail thumb = ws.getThumbnail();
        anchor.translate(-thumb.getX(), -thumb.getY());
        this.anchor = anchor;
        ws.getScrollPane().setMouseCursor(moveCursor);
        this.updateOptions(mx, my);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.transition(new NormalState(this.ws));
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        this.updateOptions(mx, my);
        BWsOptions.make().save();
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        this.updateOptions(mx, my);
    }

    private void updateOptions(double mx, double my) {
        double sb = Theme.scrollBar().getFixedWidth();
        double w = this.ws.getWidth() - sb;
        double h = this.ws.getHeight() - sb;
        BThumbnail thumb = this.ws.getThumbnail();
        double tw = thumb.getWidth();
        double th = thumb.getHeight();
        mx -= this.anchor.x;
        my -= this.anchor.y;
        if (mx > w) {
            mx = w;
        }
        if (my > h) {
            my = h;
        }
        if (mx < 0.0) {
            mx = 0.0;
        }
        if (my < 0.0) {
            my = 0.0;
        }
        double x = mx + tw / 2.0 < w / 2.0 ? mx : Math.min(-1.0, -(w - mx - tw));
        double y = my + th / 2.0 < h / 2.0 ? my : Math.min(-1.0, -(h - my - th));
        BWsOptions.make().setThumbnailX((int)x);
        BWsOptions.make().setThumbnailY((int)y);
        this.ws.relayout();
    }
}

