/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import com.tridium.wiresheet.states.ThumbnailDragState;
import com.tridium.wiresheet.states.ViewportDragState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;

public class ThumbnailOverState
extends WsState {
    private Point dragCheckPoint;

    public ThumbnailOverState(BWireSheetPane ws) {
        super(ws);
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        if (event.isControlDown()) {
            switch (event.getKeyCode()) {
                case 38: {
                    this.ws.commands.zoomIn.invoke();
                    break;
                }
                case 40: {
                    this.ws.commands.zoomOut.invoke();
                }
            }
        }
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.dragCheckPoint = this.translateToCanvasPane(event);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        double y;
        double x;
        this.dragCheckPoint = null;
        Point abs = this.translateToCanvasPane(event);
        BThumbnail thumb = this.ws.getThumbnail();
        if (thumb.contains(x = abs.x - thumb.getX(), y = abs.y - thumb.getY())) {
            this.centerViewport((int)x, (int)y);
        }
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        BThumbnail thumb = this.ws.getThumbnail();
        if (!thumb.contains(mx - thumb.getX(), my - thumb.getY())) {
            this.transition(new NormalState(this.ws));
            return;
        }
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        if (this.dragCheckPoint == null) {
            return;
        }
        if (Math.abs(this.dragCheckPoint.x - mx) < 8.0 && Math.abs(this.dragCheckPoint.y - my) < 8.0) {
            return;
        }
        if (event.isControlDown()) {
            this.transition(new ThumbnailDragState(this.ws, this.dragCheckPoint, mx, my));
        } else {
            this.transition(new ViewportDragState(this.ws, this.dragCheckPoint, mx, my));
        }
    }

    @Override
    public void mouseWheel(BMouseWheelEvent event) {
        if (event.isControlDown()) {
            this.ws.controller.zoom((int)(-event.getPreciseWheelRotation()));
            event.consume();
            this.ws.relayout();
        }
    }

    private void centerViewport(int xThumb, int yThumb) {
        RectGeom orig = this.ws.getScrollPane().getViewport();
        double ww = orig.width / (double)this.ws.grid.wixel;
        double wh = orig.height / (double)this.ws.grid.wixel;
        double p = (double)(xThumb - 1) - ww / 2.0;
        double q = (double)(yThumb - 1) - wh / 2.0;
        RectGeom viewport = new RectGeom(p * (double)this.ws.grid.wixel, q * (double)this.ws.grid.wixel, orig.width, orig.height);
        this.ws.getScrollPane().scrollToVisible(viewport);
    }
}

