/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.BIBearerTokenProvider;
import com.tridium.cloud.client.backup.BCloudBackupJob;
import com.tridium.cloud.client.backup.BCloudBackupService;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BCloudDeleteBackupJob
extends BCloudBackupJob {
    public static final Type TYPE = Sys.loadType(BCloudDeleteBackupJob.class);
    private List<String> backupIds = Collections.emptyList();
    private final HttpUtils httpUtils = StandardHttpUtils.getInstance();

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCloudDeleteBackupJob() {
    }

    public BCloudDeleteBackupJob(List<String> backupIds) {
        this.backupIds = backupIds;
    }

    public void run(Context cx) throws Exception {
        String moduleName = this.getType().getModule().getModuleName();
        this.log().message(moduleName, "cloudBackupDeleteJob.deletingBackups");
        BCloudBackupService backupSrv = BCloudBackupService.getBackupService();
        Optional connectorSrv = BIBearerTokenProvider.getCloudConnector();
        if (!connectorSrv.isPresent()) {
            throw new LocalizableException(this.getType().getModule().getModuleName(), "connectorNotAvailable");
        }
        if (!((BCloudConnector)connectorSrv.get()).isConnected()) {
            throw new LocalizableException(this.getType().getModule().getModuleName(), "notConnected");
        }
        for (int i = 0; i < this.backupIds.size(); ++i) {
            this.log().message(moduleName, "cloudBackupDeleteJob.deletingBackup", new String[]{"" + (i + 1), "" + this.backupIds.size()});
            String id = this.backupIds.get(i);
            String deleteUri = String.format("%s/api/v1/systems/%s/backups/%s", backupSrv.getBackupUrl(), ((BCloudConnector)connectorSrv.get()).getId(), id);
            this.httpUtils.delete(deleteUri, HttpUtils.makeAuthHeaderMap((String)backupSrv.getBearerToken()), Optional.empty(), Optional.empty());
        }
        this.log().message(moduleName, "cloudBackupDeleteJob.deletedBackups");
    }
}

