/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.cloud.client.backup;

import com.tridium.cloud.client.backup.BRandomizedTimeTriggerMode;
import java.util.concurrent.ThreadLocalRandom;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="triggerMode", type="BRandomizedTimeTriggerMode", defaultValue="BRandomizedTimeTriggerMode.manual", flags=8), @NiagaraProperty(name="nextTrigger", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=8), @NiagaraProperty(name="lastTrigger", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="calculateRandomInterval", flags=20), @NiagaraAction(name="scheduleEvent", flags=20), @NiagaraAction(name="execute", flags=20), @NiagaraAction(name="fireTrigger", flags=24)})
public final class BRandomizedTimeTrigger
extends BComponent {
    public static final Property triggerMode = BRandomizedTimeTrigger.newProperty((int)8, (BValue)BRandomizedTimeTriggerMode.manual, null);
    public static final Property nextTrigger = BRandomizedTimeTrigger.newProperty((int)8, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastTrigger = BRandomizedTimeTrigger.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Action calculateRandomInterval = BRandomizedTimeTrigger.newAction((int)20, null);
    public static final Action scheduleEvent = BRandomizedTimeTrigger.newAction((int)20, null);
    public static final Action execute = BRandomizedTimeTrigger.newAction((int)20, null);
    public static final Action fireTrigger = BRandomizedTimeTrigger.newAction((int)24, null);
    public static final Type TYPE = Sys.loadType(BRandomizedTimeTrigger.class);
    private volatile Clock.Ticket ticket = Clock.expiredTicket;

    public BRandomizedTimeTriggerMode getTriggerMode() {
        return (BRandomizedTimeTriggerMode)this.get(triggerMode);
    }

    public void setTriggerMode(BRandomizedTimeTriggerMode v) {
        this.set(triggerMode, (BValue)v, null);
    }

    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    public void setNextTrigger(BAbsTime v) {
        this.set(nextTrigger, (BValue)v, null);
    }

    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    public void setLastTrigger(BAbsTime v) {
        this.set(lastTrigger, (BValue)v, null);
    }

    public void calculateRandomInterval() {
        this.invoke(calculateRandomInterval, null, null);
    }

    public void scheduleEvent() {
        this.invoke(scheduleEvent, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void fireTrigger() {
        this.invoke(fireTrigger, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (Sys.atSteadyState()) {
            this.scheduleEvent();
        }
    }

    public void atSteadyState() throws Exception {
        this.scheduleEvent();
    }

    public void stopped() throws Exception {
        this.ticket.cancel();
    }

    public void changed(Property property, Context cx) {
        if (this.isRunning()) {
            if (property.equals(triggerMode)) {
                this.calculateRandomInterval();
            } else if (property.equals(nextTrigger)) {
                this.scheduleEvent();
            }
        }
    }

    public void doCalculateRandomInterval() {
        long bound = this.getTriggerMode().getMillis();
        if (bound > 0L) {
            BRelTime interval = BRelTime.make((long)ThreadLocalRandom.current().nextLong(bound));
            BAbsTime next = BAbsTime.now().add(interval);
            this.setNextTrigger(next);
        } else {
            this.setNextTrigger(BAbsTime.DEFAULT);
        }
        this.doScheduleEvent();
    }

    public void doScheduleEvent() {
        this.ticket.cancel();
        if (this.isRunning() && !this.getTriggerMode().isManual()) {
            this.ticket = Clock.schedule((BComponent)this, (BAbsTime)this.getNextTrigger(), (Action)execute, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        try {
            this.fireTrigger();
        }
        finally {
            long bound = this.getTriggerMode().getMillis();
            if (bound > 0L) {
                BAbsTime now = BAbsTime.now();
                BRelTime interval = BRelTime.make((long)bound);
                BAbsTime next = this.getNextTrigger();
                while ((next = next.add(interval)).isBefore(now)) {
                }
                this.setNextTrigger(next);
            }
            this.doScheduleEvent();
        }
    }

    public void doFireTrigger() {
        this.setLastTrigger(BAbsTime.now());
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("Randomized Time Trigger");
        out.prop((Object)"Mode", (Object)this.getTriggerMode());
        out.prop((Object)"Next Trigger", (Object)this.getNextTrigger());
        out.prop((Object)"Last Trigger", (Object)this.getLastTrigger());
        out.prop((Object)"Ticket Expired", (Object)(this.ticket.isExpired() ? "Yes" : "No"));
        out.prop((Object)"Ticket", (Object)this.ticket);
        out.endProps();
        super.spy(out);
    }
}

